package com.macrofocus.high_d.distributions

import com.macrofocus.common.properties.SimpleProperty
import com.macrofocus.high_d.axis.AxisModel
import com.macrofocus.license.LicenseModel
import com.macrofocus.order.MutableVisibleOrder
import org.mkui.component.CPInteractiveComponent
import org.mkui.component.absolute.AbsoluteCPContainer
import org.mkui.component.absolute.Layout
import org.mkui.component.button.CPButton
import org.mkui.geom.Rectangle
import org.mkui.geom.Rectangle2D
import org.molap.subset.DistributionDimension
import kotlin.math.max

class DefaultDistributionsView<Row, Column, Value, Bin> :
    AbstractDistributionsView<Row, Column, Value, Bin>() {
    override val component: AbsoluteCPContainer = AbsoluteCPContainer(object : Layout {
        override fun layout(container: AbsoluteCPContainer, width: Double, height: Double) {
            runLayout()
        }
    })

    private val axisLabels: MutableMap<AxisModel<*, *>, CPButton> = HashMap<AxisModel<*, *>, CPButton>()
    override val distibutionsComponent: DistributionsComponent<Row, Column, Value, Bin>

    private var licenseModel: LicenseModel? = null

    init {
        distibutionsComponent = DefaultDistributionsComponent(this)
        component.addComponent(distibutionsComponent.component)

        setLicenseModel(licenseModel)
    }

    private fun runLayout() {
        if (width > 0 && height > 0) {
            var headerMaximumHeight = 0.0
            val axisOrder: MutableVisibleOrder<AxisModel<Row, Column>>? = model?.getAxisGroupModel()?.axisOrder
            if (axisOrder != null) {
                for (axisModel in axisOrder.iterableAll()) {
                    checkNotNull(axisModel)

                    val header: CPButton = getHeader(axisModel)
                    if (axisOrder.isVisible(axisModel)) {
                        val i = axisOrder.indexOf(axisModel)

                        val x1Location: Double = model!!.getLocation(axisModel)
                        val x2Location = if (i + 1 < axisOrder.size()) {
                            model!!.getLocation(axisOrder[i + 1])
                        } else {
                            1.0
                        }

                        if (x1Location != null && x2Location != null) {
                            val x = (x1Location * width)
                            val y = 0.0
                            val width = (x2Location * width) - x
                            // ToDo
//                        val height: Double = header.getNativeComponent().getOffsetHeight()
                            val height = 20.0
                            headerMaximumHeight = max(height, headerMaximumHeight)

                            component.setBounds(
                                header,
                                Rectangle(x.toInt(), y.toInt(), width.toInt(), height.toInt())
                            )
                        }

                        component.setVisible(header, true)
                    } else {
                        component.setVisible(header, false)
                    }
                }

                component.setBounds(
                    distibutionsComponent.component, Rectangle(
                        0, headerMaximumHeight.toInt(),
                        width, (height - headerMaximumHeight).toInt()
                    )
                )
                distibutionsComponent.scheduleUpdate()
            }
        }
    }

    fun getHeader(axisModel: AxisModel<*, *>): CPButton {
        if (!axisLabels.containsKey(axisModel)) {
            val label: CPButton = createAxisHeaderView(axisModel)
            //            label.addMouseListener(new MouseAdapter() {
//                @Override
//                public void mousePressed(MouseEvent e) {
//                    model.setOrder(axisModel);
//                }
//
//                @Override
//                public void mouseExited(MouseEvent e) {
//                    nativeComponent.requestFocusInWindow(true);
//                }
//            });
            //        label.setModel(model.getButtonModel(index));
            axisLabels[axisModel] = label
            component.addComponent(label)
        }
        return axisLabels[axisModel]!!
    }

    protected fun createAxisHeaderView(axisModel: AxisModel<*, *>): CPButton {
        val button: CPButton = CPButton(text = SimpleProperty(axisModel.name))
        return button
    }

    override fun refresh() {
        runLayout()
    }

    override fun getClosestDistribution(x: Int, y: Int): DistributionDimension<Row, Value, Bin>? {
        val b: Rectangle2D = component.getBounds(distibutionsComponent.component)!!
        if (b.contains(x.toDouble(), y.toDouble())) {
            return distibutionsComponent.getClosestDistribution((x - b.x).toInt(), (y - b.y).toInt())
        }

        return null
    }

    override fun getClosestBin(x: Int, y: Int): Bin? {
        val b: Rectangle2D = component.getBounds(distibutionsComponent.component)!!
        if (b.contains(x.toDouble(), y.toDouble())) {
            return distibutionsComponent.getClosestBin((x - b.x).toInt(), (y - b.y).toInt())
        }

        return null
    }

    override fun getBins(rect: Rectangle2D): List<Bin>? {
        val b: Rectangle2D = component.getBounds(distibutionsComponent.component)!!
        if (b.contains(rect.x, rect.y)) {
            return distibutionsComponent.getBins(
                Rectangle2D.Double(
                    rect.x - b.x,
                    rect.y - b.y,
                    rect.width,
                    rect.height
                )
            )
        }

        return null
    }

    override fun getClosestRow(x: Int, y: Int): Row? {
        val b: Rectangle2D = component.getBounds(distibutionsComponent.component)!!
        if (b.contains(x.toDouble(), y.toDouble())) {
            return distibutionsComponent.getClosestRow((x - b.x).toInt(), (y - b.y).toInt())
        }

        return null
    }

    override fun setLicenseModel(licenseModel: LicenseModel?) {
    }

    val width: Int
        get() = component.width.toInt()

    val height: Int
        get() = component.height.toInt()
}
