/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.list

import com.macrofocus.common.collection.UniversalComparator
import org.molap.dataframe.DataFrame

class DefaultListModel<R, C, V>(dataFrame: DataFrame<R, C, V>, column: C) : AbstractListModel<Any?>() {
    val indexModel: EfficientIndexModel<R, C, V> = EfficientIndexModel<R, C, V>(dataFrame, column, UniversalComparator())
    override var listContentModel: ListContentModel<Any?> = DefaultListContentModel<Any?>(indexModel)
}