/*
 * Copyright (c) 2012 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.parallelcoordinates
/**
 * This class provides a skeletal implementation of the ParallelCoordinatesModel interface to minimize the effort
 * required to implement this interface.
 */
abstract class AbstractParallelCoordinatesModel<O, C> : ParallelCoordinatesModel<O, C> {
    private val listeners: MutableList<ParallelCoordinatesListener> = ArrayList<ParallelCoordinatesListener>()

    /**
     * {@inheritDoc}
     */
    override fun addParallelCoordinatesListener(listener: ParallelCoordinatesListener) {
        listeners.add(listener)
    }

    /**
     * {@inheritDoc}
     */
    override fun removeParallelCoordinateListener(listener: ParallelCoordinatesListener) {
        listeners.remove(listener)
    }

    fun fireParallelCoordinatesChanged() {
        for (listener in listeners) {
            listener.pararallelCoordinatesChanged()
        }
    }
}