package com.macrofocus.high_d.parallelcoordinates

import org.mkui.colormap.ColorMapFactory
import org.mkui.component.CPComponent
import org.mkui.palette.PaletteFactory
import org.molap.dataframe.DataFrame

class DefaultParallelCoordinates<Row,Column> : AbstractParallelCoordinates<Row,Column>() {
    override val component: CPComponent
        get() = view!!.component

    override fun createModel(dataFrame: DataFrame<Row,Column, *>?): ParallelCoordinatesModel<Row, Column> {
        return DefaultParallelCoordinatesModel<Row, Column>(ColorMapFactory(PaletteFactory.instance), dataFrame!!)
    }

    override fun createView(): ParallelCoordinatesView<Row, Column>? {
        return DefaultParallelCoordinatesView()
    }

    override fun createController(view: ParallelCoordinatesView<Row, Column>?): ParallelCoordinatesController<Row, Column>? {
        return DefaultParallelCoordinatesController(view!!)
    }
}