package com.macrofocus.high_d.parallelcoordinates

import org.mkui.canvas.CPCanvas

class DefaultParallelCoordinatesComponent<Row, C>(view: ParallelCoordinatesView<Row, C>, level: Int) : AbstractParallelCoordinatesComponent<Row, C>(view, CPCanvas(), level) {
    override fun getWidth(): Int {
        return canvas.getWidth().toInt()
    }

    override fun getHeight(): Int {
        return canvas.getHeight().toInt()
    }

    override fun refresh() {
        canvas.refresh()
    }

    override fun repaint() {
        canvas.redraw()
    }

    override fun scheduleUpdate() {
        timer.restart()
        canvas.refresh()
    }

    override fun waitUntilReady() {
    }

    override fun reset() {
        canvas.refresh()
    }
}