/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.parallelcoordinatesmatrix

import com.macrofocus.common.filter.Filter
import com.macrofocus.common.selection.MutableSelection
import com.macrofocus.common.selection.MutableSingleSelection
import com.macrofocus.high_d.axis.group.AxisGroupModel
import com.macrofocus.high_d.axis.hierarchy.AxisHierarchy
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesSettings
import org.mkui.coloring.MutableColoring
import org.mkui.colormapping.MutableColorMapping
import org.mkui.visual.Visual
import org.molap.dataframe.DataFrame

interface ParallelCoordinatesMatrixModel<O, C> {
    fun getVisual(): Visual<O, C>

    /**
     * Obtains the model used for probing objects in the scatter plot (aka mouse over).
     *
     * @return the model used for probing.
     */
    fun getProbing(): MutableSingleSelection<O>

    /**
     * Obtains the model used for selecting objects in the scatter plot.
     *
     * @return the model used for selection.
     */
    fun getSelection(): MutableSelection<O>

    /**
     * Obtains the model used for filtering objects in the scatter plot.
     *
     * @return the model used for filtering.
     */
    fun getFilter(): Filter<O>

    /**
     * Gets model holding the color mapping of each object.
     *
     * @return the model holding the color of each object.
     */
    fun getColorMapping(): MutableColorMapping<O, *>

    /**
     * Gets model holding the colors of each object.
     *
     * @return the model holding the color of each object.
     */
    fun getColoring(): MutableColoring<O>

    /**
     * Returns the number of data objects (typically rows).
     *
     * @return the number of data objects
     */
    val objectCount: Int

    /**
     * @param index
     *
     * @return
     */
    fun getObject(index: Int): O
    fun getAxisGroupModel(): AxisGroupModel<O, C>
    fun getDataFrame(): DataFrame<O, C, *>
    fun getAxisHierarchy(): AxisHierarchy<O, C>
    fun getSettings(): ParallelCoordinatesSettings

    /**
     * Add a listener for receiving interesting events about changes in the model.
     *
     * @param listener the listener to add.
     */
    fun addParallelCoordinatesMatrixListener(listener: ParallelCoordinatesMatrixListener)

    /**
     * Remove a listener from the list of listeners that should be notified about changes in the model.
     *
     * @param listener the listener to remove.
     */
    fun removeParallelCoordinatesMatrixListener(listener: ParallelCoordinatesMatrixListener)
}