package com.macrofocus.high_d.scatterplot

import com.macrofocus.common.units.invoke
import org.mkui.colormap.ColorMapFactory
import org.mkui.component.CPComponent
import org.mkui.component.panel.Row
import org.mkui.palette.PaletteFactory
import org.molap.dataframe.DataFrame

class DefaultScatterPlot<Row, Column> : AbstractScatterPlot<Row, Column>() {
    override val component: CPComponent
        get() = view!!.component

    override fun createModel(dataFrame: DataFrame<Row, Column, *>?): ScatterPlotModel<Row, Column> {
        return DefaultScatterPlotModel(ColorMapFactory(PaletteFactory.instance), dataFrame!!)
    }

    override fun createView(): ScatterPlotView<Row, Column>? {
        return DefaultScatterPlotView()
    }

    override fun createController(view: ScatterPlotView<*, *>?): ScatterPlotController<*, *>? {
        return DefaultScatterPlotController(view)
    }
}