/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.scatterplotmatrix

import com.macrofocus.license.LicenseModel
import org.molap.dataframe.DataFrame

/**
 * Created by luc on 25/04/16.
 */
abstract class AbstractScatterPlotMatrix<Row, Column> : ScatterPlotMatrix<Row, Column> {
    override var model: ScatterPlotMatrixModel<Row, Column>? = null
        set(value) {
            if (field !== value) {
                field = value

                // Register it to the current view
                view?.model = value
            }
        }

    override var view: ScatterPlotMatrixView<Row, Column>? = null
        set(value) {
            if (field !== value) {
                // Deregister the current view
                field?.model = null
                field = value
                if (value != null) {
                    value.model = model
                    field!!.setLicenseModel(licenseModel)
                }
            }
        }

    override var controller: ScatterPlotMatrixController<Row, Column>? = null
        set(value) {
            if (field !== value) {
                field?.view = null
                field = value
                if (value != null) {
                    value.view = view
                }
            }
        }

    /**
     * Loads the specified Swing TableModel.
     *
     * @param dataFrame a Swing TableModel
     */
    protected open fun load(dataFrame: DataFrame<Row, Column, *>) {
        model = createScatterPlotMatrixModel(dataFrame)
    }

    /**
     * Creates a model that can be used by the parallel coordinates component
     *
     * @param dataFrame a Swing TableModel
     *
     * @return a ParallelCoordinatesModel instance
     */
    protected abstract fun createScatterPlotMatrixModel(dataFrame: DataFrame<Row, Column, *>): ScatterPlotMatrixModel<Row, Column>

    /**
     * Creates a view that can be used by the parallel coordinates component
     *
     * @return a ParallelCoordinatesView instance
     */
    protected abstract fun createView(): ScatterPlotMatrixView<Row, Column>?

    /**
     * Creates a controller that can be used by the parallel coordinates component
     *
     * @param view the view that should be controlled
     *
     * @return
     */
    protected abstract fun createController(view: ScatterPlotMatrixView<Row, Column>?): ScatterPlotMatrixController<Row, Column>?

    companion object {
        protected var licenseModel: LicenseModel? = null

        /**
         * Register the license key that legally entitle the use of ScatterPlotMatrix. This should be called prior to the
         * first instantiation of this component.
         *
         * @param username the user name
         * @param key      the license key
         */
        @kotlin.jvm.JvmStatic
        fun setLicenseKey(username: String?, key: String?) {
//            licenseModel = SimpleLicenseModel(ApplicationModelFactory.HIGHD_API, username, key)
        }
    }
}