/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.scatterplotmatrix

import com.macrofocus.common.properties.*
import com.macrofocus.high_d.axis.AxisModel
import com.macrofocus.high_d.parallelcoordinatesmatrix.ScatterPlotMatrixComponent
import com.macrofocus.order.OrderEvent
import com.macrofocus.order.OrderListener
import org.mkui.canvas.Rendering
import org.mkui.color.MkColorFactory
import org.mkui.graphics.colortheme.ColorTheme
import org.mkui.graphics.colortheme.LightColorTheme
import org.mkui.rubberband.RubberBand
import org.mkui.rubberband.SimpleRubberBand

/**
 * Created by luc on 25/04/16.
 */
abstract class AbstractScatterPlotMatrixView<Row, Column>() : ScatterPlotMatrixView<Row, Column> {
    override var model: ScatterPlotMatrixModel<Row, Column>? = null
    set(value) {
        field?.getAxisGroupModel()!!.axisOrder!!.removeOrderListener(orderListener)
        field = value
        getScatterPlotMatrixComponent()?.model = value
        field?.getAxisGroupModel()!!.axisOrder!!.addOrderListener(orderListener)
    }

    private val rubberBand: RubberBand
    private var isSelectionMode = true
    protected val properties: MutableProperties<ScatterPlotMatrixView.PropertyType> = EnumProperties(ScatterPlotMatrixView.PropertyType.values())
    private val propertiesListener: PropertiesListener<ScatterPlotMatrixView.PropertyType> = object : PropertiesListener<ScatterPlotMatrixView.PropertyType> {
        override fun propertyChanged(name: ScatterPlotMatrixView.PropertyType, event: PropertyEvent<Any?>) {
            createOverplots()
        }
    }
    private val orderListener: OrderListener<AxisModel<Row,Column>> = object : OrderListener<AxisModel<Row,Column>> {
        override fun orderChanged(event: OrderEvent<AxisModel<Row,Column>>?) {
            refresh()
        }

        override fun orderVisibility(event: OrderEvent<AxisModel<Row,Column>>) {
            refresh()
        }

        override fun orderAdded(event: OrderEvent<AxisModel<Row,Column>>) {
            refresh()
        }

        override fun orderRemoved(event: OrderEvent<AxisModel<Row, Column>>) {
            refresh()
        }
    }

    override fun isSelectionMode(): Boolean {
        return isSelectionMode
    }

    override fun setSelectionMode(value: Boolean) {
        isSelectionMode = value
    }

    protected abstract fun refresh()
    protected abstract fun getScatterPlotMatrixComponent(): ScatterPlotMatrixComponent<Row,Column>?

    override fun getColorTheme(): MutableProperty<ColorTheme> {
        return properties.getProperty(ScatterPlotMatrixView.PropertyType.ColorTheme) as MutableProperty<ColorTheme>
    }

    override fun setColorTheme(colorTheme: MutableProperty<ColorTheme>) {
        properties.replaceProperty<ColorTheme>(ScatterPlotMatrixView.PropertyType.ColorTheme, colorTheme)
    }

    override fun getShowTiming(): MutableProperty<Boolean> {
        return properties.getProperty(ScatterPlotMatrixView.PropertyType.ShowTiming) as MutableProperty<Boolean>
    }

    override fun getShowFiltered(): MutableProperty<Boolean> {
        return properties.getProperty(ScatterPlotMatrixView.PropertyType.ShowFiltered) as MutableProperty<Boolean>
    }

    override fun setShowFiltered(showFiltered: MutableProperty<Boolean>) {
        properties.replaceProperty<Boolean>(ScatterPlotMatrixView.PropertyType.ShowFiltered, showFiltered)
    }

    override fun getAntialiasing(): MutableProperty<Boolean> {
        return properties.getProperty(ScatterPlotMatrixView.PropertyType.Antialiasing) as MutableProperty<Boolean>
    }

    override fun setAntialiasing(antialiasing: MutableProperty<Boolean>) {
        properties.replaceProperty<Boolean>(ScatterPlotMatrixView.PropertyType.Antialiasing, antialiasing)
    }

    override fun getRendering(): MutableProperty<Rendering> {
        return properties.getProperty(ScatterPlotMatrixView.PropertyType.Rendering) as MutableProperty<Rendering>
    }

    override fun setRendering(rendering: MutableProperty<Rendering>) {
        properties.replaceProperty<Rendering>(ScatterPlotMatrixView.PropertyType.Rendering, rendering)
    }

    protected open fun createOverplots() {
        if (getScatterPlotMatrixComponent() != null) {
            getScatterPlotMatrixComponent()!!.createOverplots()
            getScatterPlotMatrixComponent()!!.scheduleUpdate()
        }
    }

    override fun getRubberBand(): RubberBand {
        return rubberBand
    }

    init {
        properties.createProperty<Boolean>(ScatterPlotMatrixView.PropertyType.ShowTiming, false)
        properties.createProperty<Boolean>(ScatterPlotMatrixView.PropertyType.ShowFiltered, true)
        properties.createProperty<Boolean>(ScatterPlotMatrixView.PropertyType.Antialiasing, true)
        properties.createProperty<Any>(ScatterPlotMatrixView.PropertyType.Rendering, Rendering.Density)
        properties.createProperty<Any>(ScatterPlotMatrixView.PropertyType.ColorTheme, LightColorTheme())
        properties.addPropertiesListener(propertiesListener)
        rubberBand = SimpleRubberBand()
    }
}