package com.macrofocus.high_d.scatterplotmatrix

import com.macrofocus.colormapping.implementation.SimpleColorMapping
import com.macrofocus.common.units.invoke
import org.mkui.colormap.ColorMapFactory
import org.mkui.component.CPComponent
import org.mkui.component.panel.Row
import org.mkui.palette.PaletteFactory
import org.molap.dataframe.DataFrame

class DefaultScatterPlotMatrix<Row, Column> : AbstractScatterPlotMatrix<Row, Column>() {
    override val component: CPComponent
        get() = TODO("Not yet implemented")

    override fun createScatterPlotMatrixModel(dataFrame: DataFrame<Row, Column, *>): ScatterPlotMatrixModel<Row, Column> {
        return DefaultScatterPlotMatrixModel(dataFrame, SimpleColorMapping(ColorMapFactory(PaletteFactory.instance), dataFrame))
    }

    override fun createView(): ScatterPlotMatrixView<Row, Column>? {
        return DefaultScatterPlotMatrixView()
    }

    override fun createController(view: ScatterPlotMatrixView<Row, Column>?): ScatterPlotMatrixController<Row, Column>? {
        return DefaultScatterPlotMatrixController(view)
    }
}