/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.som

abstract class AbsractSOMModel<Row, Column> : SOMModel<Row, Column> {
    private val listeners: MutableList<SOMListener> = ArrayList<SOMListener>()

    /**
     * {@inheritDoc}
     */
    override fun addSOMListener(listener: SOMListener) {
        listeners.add(listener)
    }

    /**
     * {@inheritDoc}
     */
    override fun removeSOMListener(listener: SOMListener) {
        listeners.remove(listener)
    }

    protected fun firedSOMChanged() {
        for (listener in listeners) {
            listener.somChanged()
        }
    }
}