/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.tablelens

import com.macrofocus.common.properties.*
import com.macrofocus.order.OrderEvent
import com.macrofocus.order.OrderListener
import org.mkui.canvas.Rendering
import org.mkui.graphics.colortheme.ColorTheme
import org.mkui.graphics.colortheme.LightColorTheme
import org.mkui.rubberband.RubberBand
import org.mkui.rubberband.SimpleRubberBand

abstract class AbstractTableLensView<Row, Column> : TableLensView<Row, Column> {
    protected val properties: MutableProperties<TableLensView.PropertyType> = EnumProperties(TableLensView.PropertyType.values())
    private val rubberBand: RubberBand
    protected val orderListener: OrderListener<Row> = object : OrderListener<Row> {
        override fun orderChanged(event: OrderEvent<Row>?) {
            refresh()
        }

        override fun orderVisibility(event: OrderEvent<Row>) {
            refresh()
        }

        override fun orderAdded(event: OrderEvent<Row>) {
            refresh()
        }

        override fun orderRemoved(event: OrderEvent<Row>) {
            refresh()
        }
    }
    private val propertiesListener: PropertiesListener<TableLensView.PropertyType> = object : PropertiesListener<TableLensView.PropertyType> {
        override fun propertyChanged(name: TableLensView.PropertyType, event: PropertyEvent<Any?>) {
            createOverplots()
        }
    }

    override fun getColorTheme(): MutableProperty<ColorTheme> {
        return properties.getProperty(TableLensView.PropertyType.ColorTheme) as MutableProperty<ColorTheme>
    }

    override fun setColorTheme(colorTheme: MutableProperty<ColorTheme>?) {
        properties.replaceProperty(TableLensView.PropertyType.ColorTheme, colorTheme!!)
    }

    override fun isShowTiming(): Boolean {
        return properties.getProperty(TableLensView.PropertyType.ShowTiming).value as Boolean
    }

    override fun setShowTiming(showTiming: Boolean) {
        properties.getProperty(TableLensView.PropertyType.ShowTiming).value = showTiming
    }

    override fun getShowFiltered(): Property<Boolean> {
        return properties.getProperty(TableLensView.PropertyType.ShowFiltered) as Property<Boolean>
    }

    override fun setShowFiltered(showFiltered: MutableProperty<Boolean>?) {
        properties.replaceProperty(TableLensView.PropertyType.ShowFiltered, showFiltered!!)
        createOverplots()
    }

    override fun getAntialiasing(): MutableProperty<Boolean> {
        return properties.getProperty(TableLensView.PropertyType.Antialiasing) as MutableProperty<Boolean>
    }

    override fun setAntialiasing(antialiasing: MutableProperty<Boolean>?) {
        properties.replaceProperty(TableLensView.PropertyType.Antialiasing, antialiasing!!)
        createOverplots()
    }

    override fun getRendering(): MutableProperty<Rendering> {
        return properties.getProperty(TableLensView.PropertyType.Rendering) as MutableProperty<Rendering>
    }

    override fun setRendering(rendering: MutableProperty<Rendering>?) {
        properties.replaceProperty(TableLensView.PropertyType.Rendering, rendering!!)
        createOverplots()
    }

    override fun getColumnSize(): MutableProperty<Int?> {
        return properties.getProperty(TableLensView.PropertyType.ColumnSize) as MutableProperty<Int?>
    }

    override fun getRowSize(): MutableProperty<Int?> {
        return properties.getProperty(TableLensView.PropertyType.RowSize) as MutableProperty<Int?>
    }

    protected abstract fun createOverplots()
    protected abstract fun refresh()
    override fun getRubberBand(): RubberBand {
        return rubberBand
    }

    init {
        properties.createProperty(TableLensView.PropertyType.ShowTiming, false)
        properties.createProperty(TableLensView.PropertyType.ShowFiltered, true)
        properties.createProperty(TableLensView.PropertyType.Antialiasing, true)
        properties.createProperty(TableLensView.PropertyType.Rendering, Rendering.Density)
        properties.createProperty(TableLensView.PropertyType.ColumnSize, 45)
        properties.createProperty(TableLensView.PropertyType.RowSize, 0)
        properties.createProperty(TableLensView.PropertyType.ColorTheme, LightColorTheme())
        properties.addPropertiesListener(propertiesListener)
        rubberBand = SimpleRubberBand()
    }
}