package com.macrofocus.high_d.tablelens

import org.mkui.colormap.ColorMapFactory
import org.mkui.component.CPComponent
import org.mkui.palette.PaletteFactory
import org.molap.dataframe.DataFrame

class DefaultTableLens<Row,Column> : AbstractTableLens<Row, Column>() {
    override val component: CPComponent
        get() = view!!.component

    override fun createModel(dataFrame: DataFrame<Row, Column, *>): TableLensModel<Row, Column> {
        return DefaultTableLensModel(ColorMapFactory(PaletteFactory.instance), dataFrame)
    }

    override fun createView(): TableLensView<Row, Column>? {
        return DefaultTableLensView()
    }

    override fun createController(view: TableLensView<Row, Column>?): TableLensController<Row, Column>? {
        return DefaultTableLensController(view)
    }
}