package com.macrofocus.high_d.tablelens

import com.macrofocus.common.properties.SimpleProperty
import com.macrofocus.high_d.axis.AxisModel
import com.macrofocus.license.LicenseModel
import com.macrofocus.order.MutableVisibleOrder
import org.mkui.canvas.MouseListener
import org.mkui.canvas.MouseMotionListener
import org.mkui.component.absolute.AbsoluteCPContainer
import org.mkui.component.absolute.Layout
import org.mkui.component.label.CPLabel
import org.mkui.geom.Rectangle2D
import kotlin.math.max

class DefaultTableLensView<Row,Column> : AbstractTableLensView<Row,Column>() {
    override val component: AbsoluteCPContainer = AbsoluteCPContainer(object : Layout {
        override fun layout(container: AbsoluteCPContainer, width: Double, height: Double) {
            runLayout()
        }
    })

    private val axisLabels: MutableMap<AxisModel<Row,Column>, CPLabel> = HashMap<AxisModel<Row,Column>, CPLabel>()
    override var model: TableLensModel<Row, Column>? = null
        get() = field
        set(value) {
            field = value
            tableLensComponent.model = value
        }
    private val tableLensComponent: TableLensComponent<Row, Column> = DefaultTableLensComponent(this)
    private var isSelectionMode = true

    init {
        component.addComponent(tableLensComponent)
    }

    override fun createOverplots() {
        if (tableLensComponent != null) {
            tableLensComponent.createOverplots()
            tableLensComponent.scheduleUpdate()
        }
    }

    override fun refresh() {
        runLayout()
    }

    private fun runLayout() {
        if(model != null && getWidth() > 0 && getHeight() > 0) {
            var headerMaximumHeight = 0.0
            val axisOrder: MutableVisibleOrder<AxisModel<Row, Column>>? = model!!.getAxisGroupModel().axisOrder
            for (axisModel: AxisModel<Row, Column> in axisOrder!!.iterableAll()) {
                val header: CPLabel = getHeader(axisModel)
                if (axisOrder.isVisible(axisModel)) {
                    val i = axisOrder.indexOf(axisModel)
                    val x1Location: Double? = model?.getLocation(axisModel)
                    var x2Location: Double?
                    if (i + 1 < axisOrder.size()) {
                        x2Location = model?.getLocation((axisOrder.get(i + 1)))
                    } else {
                        x2Location = 1.0
                    }
                    if (x1Location != null && x2Location != null) {
                        val x = (x1Location * getWidth())
                        val y = 0.0
                        val width = (x2Location * getWidth()) - x
                        val height: Double = 12.0 // header.prefHeight(width)
                        headerMaximumHeight = max(height, headerMaximumHeight)

                        component.setBounds(header, Rectangle2D.Double(x, y, width, height))
                    }
                    component.setVisible(header, true)
                } else {
                    component.setVisible(header, false)
                }
            }
            val bounds = Rectangle2D.Double(0.0, headerMaximumHeight, getWidth().toDouble(), getHeight() - headerMaximumHeight)
            component.setBounds(tableLensComponent, bounds)
        }
    }

    fun getHeader(axisModel: AxisModel<Row,Column>): CPLabel {
        if (!axisLabels.containsKey(axisModel)) {
            val label: CPLabel = createAxisHeaderView(axisModel)
            //            label.addMouseListener(new MouseAdapter() {
//                @Override
//                public void mousePressed(MouseEvent e) {
//                    model.setOrder(axisModel);
//                }
//
//                @Override
//                public void mouseExited(MouseEvent e) {
//                    nativeComponent.requestFocusInWindow(true);
//                }
//            });
            //        label.setModel(model.getButtonModel(index));
            axisLabels.put(axisModel, label)
            component.addComponent(label)
        }
        return axisLabels.get(axisModel)!!
    }

    protected fun createAxisHeaderView(axisModel: AxisModel<Row, Column>): CPLabel {
//        return new AxisHeaderView(axisModel);
        val button: CPLabel = CPLabel(SimpleProperty(axisModel.name))
//        val button: CPLabel = CPLabel(SimpleProperty(axisModel.name))
//        button.setOnAction(object : javafx.event.EventHandler<javafx.event.ActionEvent?>() {
//            fun handle(event: javafx.event.ActionEvent) {
//                model!!.setOrder(axisModel)
//            }
//        })
        return button
    }
    override fun getClosestRow(x: Int, y: Int): Row {
        return tableLensComponent.getClosestRow(x, y)!!
    }

    override fun getRows(rect: Rectangle2D?): List<Row> {
        return tableLensComponent.getRows(rect!!)
    }

    override fun isSelectionMode(): Boolean {
        return isSelectionMode
    }

    override fun setSelectionMode(value: Boolean) {
        isSelectionMode = value
    }

    override fun getWidth(): Int {
        return component.width.toInt()
    }

    override fun getHeight(): Int {
        return component.height.toInt()
    }

    override fun setLicenseModel(licenseModel: LicenseModel?) {
        TODO("Not yet implemented")
    }
}