/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.tablelens

import org.mkui.component.CPComponent
import org.mkui.component.CPComponentProvider

interface TableLens<Row, Column> : CPComponentProvider {
    /**
     * Returns the model used by the scatter plot component.
     *
     * @return the model in use
     */
    var model: TableLensModel<Row, Column>?

    /**
     * Returns the view used by the parallel coordinates component.
     *
     * @return the view in use
     */
    var view: TableLensView<Row, Column>?

    /**
     * Returns the controller used by the parallel coordinates component.
     *
     * @return the controller in use
     */
    var controller: TableLensController<Row, Column>?
}