package com.macrofocus.high_d.tablelens

import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.Property
import com.macrofocus.license.LicenseModel
import org.mkui.canvas.MouseListener
import org.mkui.canvas.MouseMotionListener
import org.mkui.canvas.Rendering
import org.mkui.component.CPComponentProvider
import org.mkui.component.CPInteractiveComponentProvider
import org.mkui.geom.Rectangle2D
import org.mkui.graphics.colortheme.ColorTheme
import org.mkui.rubberband.RubberBand

interface TableLensView<Row, Column> : CPInteractiveComponentProvider {
    enum class PropertyType {
        ShowTiming, ShowFiltered, Rendering, Antialiasing, ColumnSize, ColorTheme, RowSize
    }

    fun getClosestRow(x: Int, y: Int): Row

    /**
     * Returns the nodes overlapping the specified rectangle.
     *
     * @param rect the rectangle in screen coordinates
     *
     * @return the list of nodes
     */
    fun getRows(rect: Rectangle2D?): List<Row>
    fun isSelectionMode(): Boolean
    fun setSelectionMode(value: Boolean)
    fun getWidth(): Int
    fun getHeight(): Int

    /**
     * Returns whether information about refresh rate should be displayed.
     *
     * @return true to display refresh rate information, false otherwise
     */
    fun isShowTiming(): Boolean

    /**
     * Sets whether information about refresh rate should be displayed.
     *
     * @param showTiming true to display refresh rate information, false otherwise
     */
    fun setShowTiming(showTiming: Boolean)
    fun setLicenseModel(licenseModel: LicenseModel?)

    /**
     * Returns the ScatterPlotModel that provides the data displayed by this ScatterPlotView.
     *
     * @return the ScatterPlotModel that provides the data displayed by this ScatterPlotView
     *
     * @see .setModel
     */
    var model: TableLensModel<Row, Column>?

    /**
     * Returns the color theme to use.
     *
     * @return the color theme
     */
    fun getColorTheme(): MutableProperty<ColorTheme>

    /**
     * Sets the color theme to use.
     *
     * @param colorTheme the color theme to use
     */
    fun setColorTheme(colorTheme: MutableProperty<ColorTheme>?)
    fun getShowFiltered(): Property<Boolean>
    fun setShowFiltered(showFiltered: MutableProperty<Boolean>?)
    fun getRendering(): MutableProperty<Rendering>
    fun setRendering(rendering: MutableProperty<Rendering>?)
    fun getAntialiasing(): MutableProperty<Boolean>
    fun setAntialiasing(antialiasing: MutableProperty<Boolean>?)
    fun getColumnSize(): MutableProperty<Int?>
    fun getRowSize(): MutableProperty<Int?>
    fun getRubberBand(): RubberBand
}