/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.barchart

import org.mkui.component.CPComponent

interface BarChart<Row, Column> : CPComponent {
    /**
     * Returns the model used by the scatter plot component.
     *
     * @return the model in use
     */
    var model: BarChartModel<Row, Column>?

    /**
     * Returns the view used by the parallel coordinates component.
     *
     * @return the view in use
     */
    var view: BarChartView<Row, Column>?

    /**
     * Returns the controller used by the parallel coordinates component.
     *
     * @return the controller in use
     */
    var controller: BarChartController<Row, Column>?
}