package com.macrofocus.high_d.distributions

import org.mkui.colormap.ColorMapFactory
import org.mkui.component.CPComponent
import org.mkui.palette.PaletteFactory
import org.molap.dataframe.DataFrame
import org.molap.subset.SubsetDataFrame

class DefaultDistributions<Row, Column, Value, Bin> : AbstractDistributions<Row, Column, Value, Bin>() {
    override val component: CPComponent
        get() = view!!.component

    override fun createModel(dataFrame: DataFrame<Row, Column, Value>?): DistributionsModel<Row, Column, Value, Bin> {
        return DefaultDistributionsModel<Row, Column, Value, Bin>(ColorMapFactory(PaletteFactory.instance),dataFrame!!, SubsetDataFrame<Row, Column, Value>(dataFrame!!))
    }

    override fun createView(): DistributionsView<Row, Column, *, *>? {
        return DefaultDistributionsView<Row, Column, Value, Bin>()
    }

    override fun createController(view: DistributionsView<*, *, *, *>?): DistributionsController<*, *, *, *>? {
        return DefaultDistributionsController<Row, Column, Value, Bin>()
    }
}