/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.distributions

import org.mkui.component.CPComponent
import org.mkui.geom.Rectangle2D
import org.molap.subset.DistributionDimension

/**
 * Created by luc on 12/06/16.
 */
interface DistributionsComponent<Row, Column, Value, Bin> {
    val component: CPComponent

    fun scheduleUpdate()
    var model: DistributionsModel<Row, Column, Value, Bin>?
    fun getClosestDistribution(x: Int, y: Int): DistributionDimension<Row, Value, Bin>?
    fun getClosestBin(x: Int, y: Int): Bin?
    fun getBins(rect: Rectangle2D): List<Bin>?
    fun getClosestRow(x: Int, y: Int): Row?
    fun clearCache()
    fun createOverplots()
}