/*
 * Copyright (c) 2013 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.distributions

import com.macrofocus.common.collection.SimpleImmutableEntry
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.Property
import com.macrofocus.common.selection.MutableSingleSelection
import com.macrofocus.high_d.axis.AxisModel
import com.macrofocus.license.LicenseModel
import org.mkui.canvas.Rendering
import org.mkui.component.CPInteractiveComponent
import org.mkui.component.CPInteractiveComponentProvider
import org.mkui.geom.Rectangle2D
import org.mkui.graphics.colortheme.ColorTheme
import org.mkui.interaction.InteractionMode
import org.mkui.rubberband.RubberBand
import org.molap.subset.DistributionDimension
import org.molap.subset.SingleBinningDimension

interface DistributionsView<Row, Column, Value, Bin> : CPInteractiveComponentProvider {
    override val component: CPInteractiveComponent

    fun getDistributionDimension(axisModel: AxisModel<Row, Column>): DistributionDimension<Row, Value, Bin>?
    enum class PropertyType {
        Orientation, ShowFiltered, Antialiasing, ColorTheme, Rendering, ShowTiming, InteractionMode
    }

    enum class Orientation {
        Horizontal, Vertical
    }

    fun getClosestDistribution(x: Int, y: Int): DistributionDimension<Row, Value, Bin>?
    fun getClosestBin(x: Int, y: Int): Bin?
    fun getBins(rect: Rectangle2D): List<Bin>?
    fun getClosestRow(x: Int, y: Int): Row?
    fun isSelectionMode(): Boolean
    fun setSelectionMode(value: Boolean)
    fun setLicenseModel(licenseModel: LicenseModel?)

    /**
     * Returns the ScatterPlotModel that provides the data displayed by this ScatterPlotView.
     *
     * @return the ScatterPlotModel that provides the data displayed by this ScatterPlotView
     *
     * @see .setModel
     */
    var model: DistributionsModel<Row, Column, Value, Bin>?
    fun getProbing(): MutableSingleSelection<SimpleImmutableEntry<SingleBinningDimension<Row, Bin>, Bin>>
    fun getOrientation(): Property<Orientation?>

    /**
     * Returns the color theme to use.
     *
     * @return the color theme
     */
    fun getColorTheme(): MutableProperty<ColorTheme>

    /**
     * Sets the color theme to use.
     *
     * @param colorTheme the color theme to use
     */
    fun setColorTheme(colorTheme: MutableProperty<ColorTheme>?)
    fun getShowFiltered(): Property<Boolean>

    /**
     * Returns whether information about refresh rate should be displayed.
     *
     * @return true to display refresh rate information, false otherwise
     */
    fun getShowTiming(): MutableProperty<Boolean>

    /**
     * Sets whether information about refresh rate should be displayed.
     *
     * @param showTiming true to display refresh rate information, false otherwise
     */
    fun setShowTiming(showTiming: MutableProperty<Boolean>?)
    fun setShowFiltered(showFiltered: MutableProperty<Boolean>?)
    fun getRendering(): Property<Rendering>
    fun setRendering(rendering: MutableProperty<Rendering>?)
    fun getAntialiasing(): MutableProperty<Boolean>
    fun setAntialiasing(antialiasing: MutableProperty<Boolean>?)
    fun getInteractionMode(): MutableProperty<InteractionMode?>
    fun setInteractionMode(interactionMode: MutableProperty<InteractionMode>?)
    fun getRubberBand(): RubberBand
}