/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.list

abstract class AbstractIndexModel<V> : IndexModel<V> {
    override fun getObjectIndex(`object`: Any): Int {
        var index = -1
        for (i in 0 until objectCount) {
            if (`object` == getObject(i)) {
                index = i
            }
        }
        return index
    }

    override fun getObjectIndexStartWith(string: String): Int {
        var index = -1
        for (i in 0 until objectCount) {
            if (getObject(i).toString().uppercase().startsWith(string.uppercase())) {
                index = i
                break
            }
        }
        return index
    }

    override fun hasRow(index: Int, row: Int): Boolean {
        var hasRow = false
        for (j in 0 until getRowCount(index)) {
            if (row == getRow(index, j)) {
                hasRow = true
                break
            }
        }
        return hasRow
    }
}