/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.list

class DefaultListContentModel<V>(indexModel: IndexModel<V>) : AbstractListContentModel<V>() {
    private val indexModel: IndexModel<V>
    override fun getObject(index: Int): V? {
        return indexModel.getObject(index)
    }

    override fun getObjectIndexStartWith(string: String): Int {
        return indexModel.getObjectIndexStartWith(string)
    }

    override val objectCount: Int
        get() = indexModel.objectCount

    init {
        this.indexModel = indexModel
    }
}