/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.list

interface IndexModel<V> {
    fun getObject(index: Int): V?
    fun getObjectIndex(`object`: Any): Int
    fun getObjectIndexStartWith(string: String): Int
    val objectCount: Int
    fun addObject(source: Any?, `object`: Any?)
    fun replaceObject(source: Any?, oldkey: Any?, newkey: Any?)
    fun removeObject(source: Any?, index: Int, key: Any?)
    fun getRow(index: Int, j: Int): Int
    fun hasRow(index: Int, row: Int): Boolean
    fun getRowCount(index: Int): Int
    fun addRow(source: Any?, index: Int, row: Int)
    fun removeRow(source: Any?, index: Int, row: Int)
    fun getMissing(j: Int): Int
    val missingCount: Int
    fun addMissing(source: Any?, row: Int)
    fun removeMissing(source: Any?, row: Int)
    fun getIndex(row: Int, j: Int): Int
    fun getIndexCount(row: Int): Int
    fun addIndexListener(indexListener: com.macrofocus.high_d.list.IndexListener?)
}