/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.parallelcoordinates

import org.molap.dataframe.DataFrame

abstract class AbstractParallelCoordinates<Row, Column> : ParallelCoordinates<Row, Column> {
    override var model: ParallelCoordinatesModel<Row, Column>? = null
        set(value) {
            if (field !== value) {
                field = value

                // Register it to the current view
                view?.model = value
            }
        }

    override var view: ParallelCoordinatesView<Row, Column>? = null
        set(value) {
            if (field !== value) {
                // Deregister the current view
                field?.model = null
                field = value
                if (value != null) {
                    value.model = model
//                    field!!.setLicenseModel(licenseModel)
                }
            }
        }

    override var controller: ParallelCoordinatesController<Row, Column>? = null
        set(value) {
            if (field !== value) {
                field?.view = null
                field = value
                if (value != null) {
                    value.view = view
                }
            }
        }

    /**
     * Loads the specified data frame.
     *
     * @param dataFrame a data frame
     */
    protected fun load(dataFrame: DataFrame<Row,Column, *>?) {
        model = createModel(dataFrame)
    }

    /**
     * Creates a model that can be used by the parallel coordinates component
     *
     * @param dataFrame a Swing TableModel
     *
     * @return a ParallelCoordinatesModel instance
     */
    protected abstract fun createModel(dataFrame: DataFrame<Row,Column,*>?): ParallelCoordinatesModel<Row, Column>

    /**
     * Creates a view that can be used by the parallel coordinates component
     *
     * @return a ParallelCoordinatesView instance
     */
    protected abstract fun createView(): ParallelCoordinatesView<Row, Column>?

    /**
     * Creates a controller that can be used by the parallel coordinates component
     *
     * @param view the view that should be controlled
     *
     * @return a ParallelCoordinatesController instance
     */
    protected abstract fun createController(view: ParallelCoordinatesView<Row, Column>?): ParallelCoordinatesController<Row, Column>?

    companion object {
//        protected var licenseModel: LicenseModel? = null

        /**
         * Register the license key that legally entitle the use of ParallelCoordinates. This should be called prior to the
         * first instantiation of this component.
         *
         * @param username the user name
         * @param key      the license key
         */
        fun setLicenseKey(username: String?, key: String?) {
//            licenseModel = SimpleLicenseModel(ApplicationModelFactory.HIGHD_API, username, key)
        }
    }
}