package com.macrofocus.high_d.parallelcoordinates

import com.macrofocus.high_d.axis.AxisListener
import com.macrofocus.high_d.axis.AxisView
import org.mkui.component.CPComponent

class DefaultAxisComponents<Row, Column>(label: CPComponent?) : AxisComponents {
    private var axisView: AxisView<Row, Column>? = null

    private var maxLabel: CPComponent? = null

    private var minLabel: CPComponent? = null
    private var label: CPComponent? = null

    init {
        minLabel = createMinLabel()
        maxLabel = createMaxLabel()
        this.label = label
    }

    private val axisListener: AxisListener = object : AxisListener {
        override fun axisChanged() {
            updateMinMaxLabels()
        }
    }

    fun getAxisView(): AxisView<Row, Column>? {
        return axisView
    }

    fun setAxisView(axisView: AxisView<Row, Column>) {
        if (this.axisView !== axisView) {
            if (this.axisView != null) {
                this.axisView?.model?.removeAxisListener(axisListener)
            }

            this.axisView = axisView

            if (this.axisView != null) {
                this.axisView?.model?.addAxisListener(axisListener)
            }

            updateMinMaxLabels()
        }
    }

    private fun updateMinMaxLabels() {
//        final AxisModel axisModel = axisView.getModel();
//        maxLabel.setValue(axisModel.isNumerical() ? axisModel.getMaximum() : axisModel.getFormattedMaximum());
//        minLabel.setValue(axisModel.isNumerical() ? axisModel.getMinimum() : axisModel.getFormattedMinimum());
//        if(axisModel.isNumerical()) {
//            JFormattedTextField.AbstractFormatterFactory tf = new JFormattedTextField.AbstractFormatterFactory() {
//                @Override
//                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
//                    return new JFormattedTextField.AbstractFormatter() {
//                        @Override
//                        public Object stringToValue(String text) throws ParseException {
//                            return NumberFormat.getNumberInstance().parse(text);
//                        }
//
//                        @Override
//                        public String valueToString(Object value) throws ParseException {
//                            return NumberFormat.getNumberInstance().format(value);
//                        }
//                    };
//                }
//            };
//            maxLabel.setFormatterFactory(tf);
//            minLabel.setFormatterFactory(tf);
//        }
//        maxLabel.setEditable(axisModel.isNumerical());
//        minLabel.setEditable(axisModel.isNumerical());
    }

    fun getLabel(): CPComponent?{
        return label
    }

    fun getMinLabel(): CPComponent? {
        return minLabel
    }

    fun getMaxLabel(): CPComponent? {
        return maxLabel
    }

    private fun createMaxLabel(): CPComponent? {
//        final JFormattedTextField field = new JFormattedTextField() {
//            @Override
//            public void updateUI() {
//                setFont(null);
//                super.updateUI();
//                final Font font = getFont();
//                setFont(font.deriveFont(font.getSize2D() - 2));
//                setOpaque(false);
//                setBorder(null);
////                if(view.getColorTheme() != null)
////                   setForeground(view.getColorTheme().getForeground());
//            }
//
//            @Override
//            public Dimension getPreferredSize() {
//                return new Dimension(super.getPreferredSize().width, axisView.getBeforeTrackGap());
//            }
//        };
//        field.putClientProperty("Synthetica.opaque", Boolean.FALSE);
//        field.putClientProperty("Synthetica.background.alpha", 0.50f);
//
//        field.addPropertyChangeListener("value", new PropertyChangeListener() {
//            @Override
//            public void propertyChange(final PropertyChangeEvent evt) {
//                final Object value = field.getValue();
//                if(value instanceof Number) {
//                    final double max = ((Number) value).doubleValue();
//                    final RangeSliderModel rangeSliderModel = axisView.getModel().getRangeSliderModel();
//                    if (rangeSliderModel.getCurrentMaximum() > max) {
//                        rangeSliderModel.setValues(this, rangeSliderModel.getCurrentMinimum(), max);
//                    }
//                    axisView.getModel().setMaximum(max);
//                }
//            }
//        });
//        return field;
        return null
    }

    private fun createMinLabel(): CPComponent? {
//        final JFormattedTextField field = new JFormattedTextField() {
//            @Override
//            public void updateUI() {
//                setFont(null);
//                super.updateUI();
//                final Font font = getFont();
//                setFont(font.deriveFont(font.getSize2D() - 2));
//                setOpaque(false);
//                setBorder(null);
////                if(view.getColorTheme() != null)
////                    setForeground(view.getColorTheme().getForeground());
//            }
//
//            @Override
//            public Dimension getPreferredSize() {
//                return new Dimension(super.getPreferredSize().width, axisView.getAfterTrackGap());
//            }
//        };
//        field.putClientProperty("Synthetica.opaque", Boolean.FALSE);
//        field.putClientProperty("Synthetica.background.alpha", 0.50f);
//
//        field.addPropertyChangeListener("value", new PropertyChangeListener() {
//            @Override
//            public void propertyChange(final PropertyChangeEvent evt) {
//                final Object value = field.getValue();
//                if(value instanceof Number) {
//                    final double min = ((Number) value).doubleValue();
//                    final RangeSliderModel rangeSliderModel = axisView.getModel().getRangeSliderModel();
//                    if (rangeSliderModel.getCurrentMinimum() < min) {
//                        rangeSliderModel.setValues(this, min, rangeSliderModel.getCurrentMaximum());
//                    }
//                    axisView.getModel().setMinimum(min);
//                }
//            }
//        });
//        return field;
        return null
    }
}