/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.parallelcoordinatesmatrix

import com.macrofocus.license.LicenseModel
import org.molap.dataframe.DataFrame

abstract class AbstractParallelCoordinatesMatrix<Row, Column> : ParallelCoordinatesMatrix<Row, Column> {
    override var model: ParallelCoordinatesMatrixModel<Row, Column>? = null
        set(value) {
            if (field !== value) {
                field = value

                // Register it to the current view
                view?.model = value
            }
        }

    override var view: ParallelCoordinatesMatrixView<Row, Column>? = null
        set(value) {
            if (field !== value) {
                // Deregister the current view
                field?.model = null
                field = value
                if (value != null) {
                    value.model = model
                    field!!.setLicenseModel(licenseModel)
                }
            }
        }

    override var controller: ParallelCoordinatesMatrixController<Row, Column>? = null
        set(value) {
            if (field !== value) {
                field?.view = null
                field = value
                if (value != null) {
                    value.view = view
                }
            }
        }

    /**
     * Loads the specified Swing TableModel.
     *
     * @param dataFrame a Swing TableModel
     */
    fun load(dataFrame: DataFrame<Row, Column, *>?) {
        model = createParallelCoordinatesMatrixModel(dataFrame)
    }

    /**
     * Creates a model that can be used by the parallel coordinates component
     *
     * @param dataFrame a Swing TableModel
     *
     * @return a ParallelCoordinatesModel instance
     */
    protected abstract fun createParallelCoordinatesMatrixModel(dataFrame: DataFrame<Row,Column,*>?): ParallelCoordinatesMatrixModel<Row, Column>

    /**
     * Creates a view that can be used by the parallel coordinates component
     *
     * @return a ParallelCoordinatesView instance
     */
    protected abstract fun createView(): ParallelCoordinatesMatrixView<Row,Column>?

    companion object {
        protected var licenseModel: LicenseModel? = null

        /**
         * Register the license key that legally entitle the use of ParallelCoordinatesMatrix. This should be called prior
         * to the first instantiation of this component.
         *
         * @param username the user name
         * @param key      the license key
         */
        fun setLicenseKey(username: String?, key: String?) {
//            licenseModel = SimpleLicenseModel(ApplicationModelFactory.HIGHD_API_V1, username, key)
        }
    }
}