package com.macrofocus.high_d.scatterplot

abstract class AbstractScatterPlotModel<Row, Column> : ScatterPlotModel<Row, Column> {
    private val listeners: MutableList<ScatterPlotListener> =
        ArrayList<ScatterPlotListener>()

    /**
     * {@inheritDoc}
     */
    override fun addScatterPlotListener(listener: ScatterPlotListener) {
        listeners.add(listener)
    }

    /**
     * {@inheritDoc}
     */
    override fun removeScatterPlotListener(listener: ScatterPlotListener) {
        listeners.remove(listener)
    }

    protected fun fireScatterPlotChanged() {
        for (listener in listeners) {
            listener.scatterPlotChanged()
        }
    }
}