@file:OptIn(ExperimentalTime::class)

package com.macrofocus.high_d.scatterplot

import com.macrofocus.common.properties.MutableProperties
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.license.LicenseModel
import com.macrofocus.plot.guide.*
import org.mkui.component.CPComponent
import kotlin.time.ExperimentalTime
import kotlin.time.Instant

class DefaultScatterPlotView<Row, C> : AbstractScatterPlotView<Row, C>() {
    init {
        xGuide = XNumberOneDScreenTransformAxisGuide(Guide.Type.Bottom, screenTransform.x)
        yGuide = YNumberOneDScreenTransformAxisGuide(Guide.Type.Left, screenTransform.y)
    }

    override val component: CPComponent
        get() = canvas

    override fun updateAxisType() {
        if (model != null && model!!.getX().isActive) {
            if (model!!.getX().selected?.type == Instant::class) {
                xGuide!!.setAxis(DateAxis())
            } else {
                xGuide!!.setAxis(NumberAxis())
            }
        }
        if (model != null && model!!.getY().isActive) {
            if (model!!.getY().selected?.type == Instant::class) {
                yGuide!!.setAxis(DateAxis())
            } else {
                yGuide!!.setAxis(NumberAxis())
            }
        }
    }

    override fun setLicenseModel(licenseModel: LicenseModel?) {
    }

    override fun isShowTiming(): Boolean {
        TODO("Not yet implemented")
    }

    override fun setShowTiming(showTiming: Boolean) {
        TODO("Not yet implemented")
    }

    override fun getSizeProportion(): MutableProperty<SizeProportion> {
        TODO("Not yet implemented")
    }

    override fun setMaintainAspectRatio(maintainAspectRatio: Boolean) {
        TODO("Not yet implemented")
    }

    override fun isMaintainAspectRatio(): Boolean {
        TODO("Not yet implemented")
    }
}
