package com.macrofocus.high_d.scatterplot

import com.macrofocus.common.filter.Filter
import com.macrofocus.common.selection.MutableSelection
import com.macrofocus.common.selection.MutableSingleSelection
import com.macrofocus.high_d.axis.AxisModel
import com.macrofocus.high_d.axis.group.AxisGroupModel
import org.mkui.coloring.MutableColoring
import org.mkui.colormapping.MutableColorMapping
import org.mkui.visual.Visual
import org.molap.dataframe.DataFrame

interface ScatterPlotModel<Row, Column> {
    fun getVisual(): Visual<Row, Column>
    fun getAxisGroupModel(): AxisGroupModel<Row,Column>

    /**
     * Obtains the model used for probing objects in the scatter plot (aka mouse over).
     *
     * @return the model used for probing.
     */
    fun getProbing(): MutableSingleSelection<Row>

    /**
     * Obtains the model used for selecting objects in the scatter plot.
     *
     * @return the model used for selection.
     */
    fun getSelection(): MutableSelection<Row>

    /**
     * Obtains the model used for filtering objects in the scatter plot.
     *
     * @return the model used for filtering.
     */
    fun getFilter(): Filter<Row>

    /**
     * Gets model holding the color mapping of each object.
     *
     * @return the model holding the color of each object.
     */
    fun getColorMapping(): MutableColorMapping<Row, Column>

    /**
     * Gets model holding the colors of each object.
     *
     * @return the model holding the color of each object.
     */
    fun getColoring(): MutableColoring<Row>

    /**
     * Returns the number of data objects (typically rows).
     *
     * @return the number of data objects
     */
    val objectCount: Int

    /**
     * @param index
     *
     * @return
     */
    fun getObject(index: Int): Row
    fun getXAxisModel(): AxisModel<Row,*>?
    fun getYAxisModel(): AxisModel<Row,*>?
    fun getY2AxisModel(): AxisModel<Row,*>?
    fun getSizeAxisModel(): AxisModel<Row,*>?
    fun getX(): MutableSingleSelection<AxisModel<Row, Column>>
    fun getY(): MutableSingleSelection<AxisModel<Row, Column>>
    fun getY2(): MutableSingleSelection<AxisModel<Row, Column>>
    fun getSize(): MutableSingleSelection<AxisModel<Row, Column>>

    //    MutableSingleSelection<Column> getLabel();
    fun getDataFrame(): DataFrame<Row,Column,*>
    fun getAnnotationDataFrame(): DataFrame<*,Column,*>?

    /**
     * Add a listener for receiving interesting events about changes in the model.
     *
     * @param listener the listener to add.
     */
    fun addScatterPlotListener(listener: ScatterPlotListener)

    /**
     * Remove a listener from the list of listeners that should be notified about changes in the model.
     *
     * @param listener the listener to remove.
     */
    fun removeScatterPlotListener(listener: ScatterPlotListener)
}