/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.som

import org.mkui.component.CPComponent

interface SOM<Row, Column> : CPComponent {
    /**
     * Returns the model used by the scatter plot component.
     *
     * @return the model in use
     */
    /**
     * Sets the model to be used for the scatter plot component and register it to the view.
     *
     * @param model the model to be used
     */
    var model: SOMModel<Row, Column>?

    /**
     * Returns the view used by the parallel coordinates component.
     *
     * @return the view in use
     */
    /**
     * Sets the view to be used by the parallel coordinates component and register the model currently in use. It will
     * also register itself to
     * the controller.
     *
     * @param view the view to be used
     */
    var view: SOMView<Row, Column>?
    /**
     * Returns the controller used by the parallel coordinates component.
     *
     * @return the controller in use
     */
    /**
     * Sets the controller to be used by the parallel coordinates component and register the view currently in use.
     *
     * @param controller the controller in use
     */
    var controller: SOMController<Row, Column>?
}