/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.statistics

import com.macrofocus.colormapping.implementation.SimpleColorMapping
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.selection.MutableSelection
import com.macrofocus.common.selection.MutableSingleSelection
import com.macrofocus.high_d.axis.group.AxisGroupModel
import com.macrofocus.high_d.table.ShowFilteredDataFrame
import com.macrofocus.high_d.table.Table
import com.macrofocus.visual.SimpleVisual
import com.macrofocus.visual.SimpleVisualObjects
import org.mkui.colormap.ColorMapFactory
import org.mkui.graphics.colortheme.ColorTheme
import org.mkui.visual.Visual
import org.molap.dataframe.DataFrame

/**
 * Created by luc on 02/06/16.
 */
abstract class AbstractStatistics<R, C, V>(private val  colorMapFactory: ColorMapFactory) :
    Statistics<R, C, V> {
    protected val table: Table<StatisticsDataFrame.Stat, C?, Any?>?
    override fun setModel(
        dataFrame: DataFrame<R, C, V>,
        visual: Visual<R, C>,
        axisGroupModel: AxisGroupModel<R, C>
    ) {
        val statisticsDataFrame: StatisticsDataFrame<R, C> = StatisticsDataFrame<R, C>(
            dataFrame,
            visual.probing,
            visual.selection,
            visual.filter,
            visual.colorMapping,
            visual.coloring
        )
        val annotationDataFrame: DataFrame<StatisticsDataFrame.Stat, C?, Any?> =
            PresentationStatisticsDataFrame<R, C>(
                statisticsDataFrame,
                axisGroupModel
            )
        val visualObjects: SimpleVisualObjects<StatisticsDataFrame.Stat> = SimpleVisualObjects(annotationDataFrame)
        val v: Visual<StatisticsDataFrame.Stat, C?> = SimpleVisual(
            visualObjects,
            visual.annotationProbing as MutableSingleSelection<StatisticsDataFrame.Stat>,
            visual.annotationSelection as MutableSelection<StatisticsDataFrame.Stat>,
            SimpleColorMapping(colorMapFactory, annotationDataFrame)
        )
        table!!.setModel(
            ShowFilteredDataFrame<StatisticsDataFrame.Stat, C?, Any?>(
                annotationDataFrame as DataFrame<StatisticsDataFrame.Stat, C?, Any?>,
                annotationDataFrame,
                table.getShowFiltered()
            ), v, axisGroupModel as AxisGroupModel<StatisticsDataFrame.Stat, C?>
        )
    }

    protected abstract fun createTable(): Table<StatisticsDataFrame.Stat, C?, Any?>?
    override fun getColorTheme(): MutableProperty<ColorTheme> {
        return table!!.getColorTheme()
    }

    override fun setColorTheme(colorTheme: MutableProperty<ColorTheme>) {
        table!!.setColorTheme(colorTheme)
    }

    init {
        table = createTable()
    }
}