/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.statistics

import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.high_d.axis.group.AxisGroupModel
import org.mkui.component.CPComponent
import org.mkui.component.CPComponentProvider
import org.mkui.graphics.colortheme.ColorTheme
import org.mkui.visual.Visual
import org.molap.dataframe.DataFrame

/**
 * Created by luc on 02/06/16.
 */
interface Statistics<R, C, V> : CPComponentProvider {
    fun setModel(
        dataFrame: DataFrame<R,C,V>,
        visual: Visual<R, C>,
        axisGroupModel: AxisGroupModel<R, C>
    )

    /**
     * Returns the color theme to use.
     *
     * @return the color theme
     */
    fun getColorTheme(): MutableProperty<ColorTheme>

    /**
     * Sets the color theme to use.
     *
     * @param colorTheme the color theme to use
     */
    fun setColorTheme(colorTheme: MutableProperty<ColorTheme>)
}