/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.table

import com.macrofocus.common.properties.EnumProperties
import com.macrofocus.common.properties.MutableProperties
import com.macrofocus.common.properties.MutableProperty
import org.mkui.graphics.colortheme.ColorTheme
import org.mkui.graphics.colortheme.LightColorTheme

/**
 * Created by luc on 04/11/15.
 */
abstract class AbstractTable<R, C, V>() : Table<R, C, V> {
    protected val properties: MutableProperties<Table.PropertyType> = EnumProperties<Table.PropertyType>(Table.PropertyType.values())
    private var isSelectionMode = true
    private var locksmith: Any
    fun getLocksmith(): Any {
        return locksmith
    }

    override fun setLocksmith(locksmith: Any) {
        this.locksmith = locksmith
    }

    fun isSelectionMode(): Boolean {
        return isSelectionMode
    }

    fun setSelectionMode(value: Boolean) {
        isSelectionMode = value
    }

    override fun getShowFiltered(): MutableProperty<Boolean> {
        return properties.getProperty(Table.PropertyType.ShowFiltered) as MutableProperty<Boolean>
    }

    override fun setShowFiltered(showFiltered: MutableProperty<Boolean>) {
        properties.replaceProperty<Boolean>(Table.PropertyType.ShowFiltered, showFiltered) as MutableProperty<Boolean>
    }

    override fun getInteractionMode(): MutableProperty<Table.InteractionMode?> {
        return properties.getProperty(Table.PropertyType.InteractionMode) as MutableProperty<Table.InteractionMode?>
    }

    fun getStyle(): MutableProperty<Table.Style> {
        return properties.getProperty(Table.PropertyType.Style) as MutableProperty<Table.Style>
    }

    override fun getShowDistribution(): MutableProperty<Boolean> {
        return properties.getProperty(Table.PropertyType.ShowDistribution) as MutableProperty<Boolean>
    }

    override fun setColorTheme(colorTheme: MutableProperty<ColorTheme>) {
        properties.replaceProperty<ColorTheme>(Table.PropertyType.ColorTheme, colorTheme) as MutableProperty<ColorTheme>
    }

    override fun getColorTheme(): MutableProperty<ColorTheme> {
        return properties.getProperty(Table.PropertyType.ColorTheme) as MutableProperty<ColorTheme>
    }

    init {
        properties.createProperty<Boolean>(Table.PropertyType.ShowFiltered, true)
        properties.createProperty<Any>(Table.PropertyType.InteractionMode, Table.InteractionMode.Select)
        properties.createProperty<Any>(Table.PropertyType.Style, Table.Style.Border)
        properties.createProperty<Boolean>(Table.PropertyType.ShowDistribution, true)
        properties.createProperty<ColorTheme>(Table.PropertyType.ColorTheme, LightColorTheme())
        locksmith = this
    }
}