/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.table

import com.macrofocus.common.format.CPFormat
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.high_d.axis.group.AxisGroupModel
import org.mkui.component.CPComponent
import org.mkui.graphics.colortheme.ColorTheme
import org.mkui.visual.Visual
import org.molap.dataframe.DataFrame
import org.molap.dataframe.SortOrder

/**
 * Created by luc on 27/07/15.
 */
interface Table<R, C, V> : CPComponent {
    enum class PropertyType {
        ShowFiltered, InteractionMode, Style, ColorTheme, ShowDistribution
    }

    /**
     * Interaction mode.
     */
    enum class InteractionMode {
        /**
         * Selection mode.
         */
        Select, Toggle, Filter, Details, None
    }

    enum class Style {
        Border, Alternate
    }

    enum class ColumnResizePolicy {
        Constrained, Unconstrained
    }

    fun setModel(dataFrame: ShowFilteredDataFrame<R, C, V>?, visual: Visual<R, C>?, axisGroupModel: AxisGroupModel<R, C>?)
    fun getSortedDataFrame(): DataFrame<R, C, V>?

    /**
     * Returns the color theme to use.
     *
     * @return the color theme
     */
    fun getColorTheme(): MutableProperty<ColorTheme>

    /**
     * Sets the color theme to use.
     *
     * @param colorTheme the color theme to use
     */
    fun setColorTheme(colorTheme: MutableProperty<ColorTheme>)
    fun adjustColumns(columnHeaderIncluded: Boolean, dynamicAdjustment: Boolean)
    fun setColumnVisible(column: C, visible: Boolean)
    fun setHidable(column: C, hidable: Boolean)
    fun setSortKey(column: C, order: SortOrder?)
    fun setLocksmith(locksmith: Any)
    fun setFormat(column: C, format: CPFormat<Any?>?)
    fun setLabel(column: C, label: String?)
    fun setFrozenColumnCount(columnCount: Int)
    fun reset()
    fun getShowFiltered(): MutableProperty<Boolean>
    fun setShowFiltered(showFiltered: MutableProperty<Boolean>)
    fun getInteractionMode(): MutableProperty<InteractionMode?>
    fun getShowDistribution(): MutableProperty<Boolean>
    fun setColumnResizePolicy(policy: ColumnResizePolicy?)
    fun setCellRenderer(column: C, renderer: CellRenderer<R, C, V>?)
    fun setDetailsFactory(alwaysVisible: Boolean, factory: DetailsFactory<R>?)
    interface DetailsFactory<R> {
        fun createDetails(row: R): CPComponent?
    }

    interface CellRenderer<R, C, V> {
        fun create(): CPComponent?
        fun render(component: CPComponent?, row: R, column: C, value: V) : CPComponent?
    }
}