package com.macrofocus.high_d.tablelens

import org.mkui.canvas.CPCanvas
import org.mkui.canvas.MouseListener
import org.mkui.canvas.MouseMotionListener
import org.mkui.component.CPComponent
import org.mkui.component.CPInteractiveComponent

class DefaultTableLensComponent<Row,Column>(view: TableLensView<Row, Column>) : AbstractTableLensComponent<Row,Column>(view) {
    override fun getWidth(): Int {
        return canvas.getWidth().toInt()
    }

    override fun getHeight(): Int {
        return canvas.getHeight().toInt()
    }

    override fun refresh() {
        canvas.refresh()
    }

    override fun repaint() {
        canvas.redraw()
    }

    override fun scheduleUpdate() {
        timer.restart()
        canvas.refresh()
    }
}