/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.distributions;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.RandomAccessIterable;
import com.macrofocus.common.collection.SimpleImmutableEntry;
import com.macrofocus.common.crossplatform.CPHelper;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.common.timer.CPTimer;
import com.macrofocus.common.timer.CPTimerListener;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.distributions.AbstractDistributionsComponent;
import com.macrofocus.high_d.distributions.DistributionsComponent;
import com.macrofocus.high_d.distributions.DistributionsListener;
import com.macrofocus.high_d.distributions.DistributionsModel;
import com.macrofocus.high_d.distributions.DistributionsView;
import com.macrofocus.high_d.distributions.FixedBinsHistogram;
import com.macrofocus.high_d.distributions.Histogram;
import com.macrofocus.order.MutableVisibleOrder;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.scene.paint.Color;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.CPCanvas;
import org.mkui.color.MkColorFactory;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.graphics.AbstractIDrawing;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.colortheme.ColorTheme;
import org.mkui.palette.Palette;
import org.mkui.rubberband.RubberBand;
import org.mkui.rubberband.RubberbandDrawing;
import org.molap.subset.DimensionEvent;
import org.molap.subset.DimensionListener;
import org.molap.subset.DistributionDimension;
import org.molap.subset.SingleBinningDimension;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b'\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u0003*\u0004\b\u0003\u0010\u00042\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0005:\u0003DEFB%\u0012\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020+H\u0016J\u0018\u0010-\u001a\n\u0012\u0004\u0012\u00028\u0003\u0018\u00010.2\u0006\u0010/\u001a\u000200H\u0016J\u001f\u00101\u001a\u0004\u0018\u00018\u00032\u0006\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u00104J,\u00105\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u0001062\u0006\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u000eH\u0016J\u001f\u00107\u001a\u0004\u0018\u00018\u00002\u0006\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u00104J\b\u00108\u001a\u00020\u000eH$J\"\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH\u0002J)\u0010;\u001a\u00020<2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00030>2\u0006\u0010?\u001a\u00028\u0003H\u0004\u00a2\u0006\u0002\u0010@J\b\u0010A\u001a\u00020\u000eH$J\b\u0010B\u001a\u00020+H\u0014J\b\u0010C\u001a\u00020+H$R(\u0010\t\u001a\u001c\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000RX\u0010\u001b\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u001a2 \u0010\u0019\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u001a@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR \u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020%X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R,\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006G"}, d2={"Lcom/macrofocus/high_d/distributions/AbstractDistributionsComponent;", "Row", "Column", "Value", "Bin", "Lcom/macrofocus/high_d/distributions/DistributionsComponent;", "view", "Lcom/macrofocus/high_d/distributions/DistributionsView;", "(Lcom/macrofocus/high_d/distributions/DistributionsView;)V", "axisHistogramCache", "", "Lcom/macrofocus/high_d/axis/AxisModel;", "Lcom/macrofocus/high_d/distributions/Histogram;", "binSize", "", "canvas", "Lorg/mkui/canvas/CPCanvas;", "getCanvas", "()Lorg/mkui/canvas/CPCanvas;", "canvas$delegate", "Lkotlin/Lazy;", "listener", "Lcom/macrofocus/high_d/distributions/DistributionsListener;", "margin", "", "value", "Lcom/macrofocus/high_d/distributions/DistributionsModel;", "model", "getModel", "()Lcom/macrofocus/high_d/distributions/DistributionsModel;", "setModel", "(Lcom/macrofocus/high_d/distributions/DistributionsModel;)V", "orderListener", "Lcom/macrofocus/order/OrderListener;", "scale", "Lcom/macrofocus/high_d/distributions/AbstractDistributionsComponent$Scale;", "timer", "Lcom/macrofocus/common/timer/CPTimer;", "getTimer", "()Lcom/macrofocus/common/timer/CPTimer;", "getView", "()Lcom/macrofocus/high_d/distributions/DistributionsView;", "clearCache", "", "createOverplots", "getBins", "", "rect", "Lorg/mkui/geom/Rectangle2D;", "getClosestBin", "x", "y", "(II)Ljava/lang/Object;", "getClosestDistribution", "Lorg/molap/subset/DistributionDimension;", "getClosestRow", "getHeight", "getHistogram", "axisModel", "getState", "Lcom/macrofocus/high_d/distributions/AbstractDistributionsComponent$State;", "dimension", "Lorg/molap/subset/SingleBinningDimension;", "bin", "(Lorg/molap/subset/SingleBinningDimension;Ljava/lang/Object;)Lcom/macrofocus/high_d/distributions/AbstractDistributionsComponent$State;", "getWidth", "refresh", "repaint", "HistogramIDrawing", "Scale", "State", "highd"})
@StabilityInferred(parameters=0)
public abstract class AbstractDistributionsComponent<Row, Column, Value, Bin>
implements DistributionsComponent<Row, Column, Value, Bin> {
    @NotNull
    private final DistributionsView<Row, Column, Value, Bin> view;
    @Nullable
    private DistributionsModel<Row, Column, Value, Bin> model;
    @NotNull
    private final Lazy canvas$delegate;
    @NotNull
    private final Map<AxisModel<?, ?>, Histogram<Row>> axisHistogramCache;
    private final double margin;
    private final int binSize;
    @NotNull
    private final Scale scale;
    @NotNull
    private final CPTimer timer;
    @NotNull
    private final DistributionsListener listener;
    @NotNull
    private final OrderListener<AxisModel<Row, Column>> orderListener;
    public static final int $stable = 8;

    public AbstractDistributionsComponent(@NotNull DistributionsView<Row, Column, Value, Bin> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        this.view = view;
        this.canvas$delegate = LazyKt.lazy((Function0)canvas.2.INSTANCE);
        this.axisHistogramCache = new HashMap();
        this.margin = 0.2;
        this.binSize = 10;
        this.scale = Scale.Local;
        this.timer = CPHelper.Companion.getInstance().createTimer("DistributionResizer", 40, true, new CPTimerListener(this){
            final /* synthetic */ AbstractDistributionsComponent<Row, Column, Value, Bin> this$0;
            {
                this.this$0 = $receiver;
            }

            public void timerTriggered() {
                if (this.this$0.getWidth() > 0 && this.this$0.getHeight() > 0) {
                    this.this$0.refresh();
                }
            }
        });
        this.listener = new DistributionsListener(this){
            final /* synthetic */ AbstractDistributionsComponent<Row, Column, Value, Bin> this$0;
            {
                this.this$0 = $receiver;
            }

            public void distributionsChanged() {
                this.this$0.getTimer().restart();
            }
        };
        this.orderListener = new OrderListener<AxisModel<Row, Column>>(this){
            final /* synthetic */ AbstractDistributionsComponent<Row, Column, Value, Bin> this$0;
            {
                this.this$0 = $receiver;
            }

            public void orderChanged(@Nullable OrderEvent<AxisModel<Row, Column>> event) {
                this.this$0.scheduleUpdate();
            }

            public void orderVisibility(@NotNull OrderEvent<AxisModel<Row, Column>> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.scheduleUpdate();
            }

            public void orderAdded(@NotNull OrderEvent<AxisModel<Row, Column>> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.scheduleUpdate();
            }

            public void orderRemoved(@NotNull OrderEvent<AxisModel<Row, Column>> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.scheduleUpdate();
            }
        };
    }

    @NotNull
    protected final DistributionsView<Row, Column, Value, Bin> getView() {
        return this.view;
    }

    @Override
    @Nullable
    public DistributionsModel<Row, Column, Value, Bin> getModel() {
        return this.model;
    }

    @Override
    public void setModel(@Nullable DistributionsModel<Row, Column, Value, Bin> value) {
        if (this.model != null) {
            DistributionsModel<Row, Column, Value, Bin> distributionsModel = this.model;
            Intrinsics.checkNotNull(distributionsModel);
            distributionsModel.removeDistributionsListener(this.listener);
            DistributionsModel<Row, Column, Value, Bin> distributionsModel2 = this.model;
            Intrinsics.checkNotNull(distributionsModel2);
            MutableVisibleOrder mutableVisibleOrder = distributionsModel2.getAxisGroupModel().getAxisOrder();
            Intrinsics.checkNotNull((Object)mutableVisibleOrder);
            mutableVisibleOrder.removeOrderListener(this.orderListener);
        }
        this.model = value;
        if (value != null) {
            this.createOverplots();
            DistributionsModel<Row, Column, Value, Bin> distributionsModel = this.model;
            Intrinsics.checkNotNull(distributionsModel);
            distributionsModel.addDistributionsListener(this.listener);
            DistributionsModel<Row, Column, Value, Bin> distributionsModel3 = this.model;
            Intrinsics.checkNotNull(distributionsModel3);
            MutableVisibleOrder mutableVisibleOrder = distributionsModel3.getAxisGroupModel().getAxisOrder();
            Intrinsics.checkNotNull((Object)mutableVisibleOrder);
            mutableVisibleOrder.addOrderListener(this.orderListener);
        }
        this.axisHistogramCache.clear();
        if (value != null) {
            this.timer.restart();
        }
    }

    @NotNull
    protected final CPCanvas getCanvas() {
        Lazy lazy = this.canvas$delegate;
        return (CPCanvas)lazy.getValue();
    }

    @NotNull
    protected final CPTimer getTimer() {
        return this.timer;
    }

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract void repaint();

    private final Histogram<Row> getHistogram(AxisModel<Row, Column> axisModel) {
        if (!this.axisHistogramCache.containsKey(axisModel)) {
            FixedBinsHistogram<Row> histogram = null;
            if (axisModel.isNumerical()) {
                MutableProperty mutableProperty = axisModel.getBinCount();
                Intrinsics.checkNotNull((Object)mutableProperty);
                Property binCount = (Property)mutableProperty;
                binCount.addPropertyListener((PropertyListener)new PropertyListener<Integer>(this, axisModel){
                    final /* synthetic */ AbstractDistributionsComponent<Row, Column, Value, Bin> this$0;
                    final /* synthetic */ AxisModel<Row, Column> $axisModel;
                    {
                        this.this$0 = $receiver;
                        this.$axisModel = $axisModel;
                    }

                    public void propertyChanged(@NotNull PropertyEvent<Integer> event) {
                        Intrinsics.checkNotNullParameter(event, (String)"event");
                        AbstractDistributionsComponent.access$getAxisHistogramCache$p(this.this$0).remove(this.$axisModel);
                        this.this$0.getTimer().restart();
                    }
                });
                int n = ((Number)binCount.getValue()).intValue();
                double d = axisModel.getMinimum();
                double d2 = axisModel.getMaximum();
                DistributionsModel<Row, Column, Value, Bin> distributionsModel = this.getModel();
                Intrinsics.checkNotNull(distributionsModel);
                histogram = new FixedBinsHistogram<Row>(n, d, d2, distributionsModel.getFilter());
            } else {
                int n = (int)(axisModel.getMaximum() - axisModel.getMinimum()) + 1;
                double d = axisModel.getMinimum();
                double d3 = axisModel.getMaximum();
                DistributionsModel<Row, Column, Value, Bin> distributionsModel = this.getModel();
                Intrinsics.checkNotNull(distributionsModel);
                histogram = new FixedBinsHistogram<Row>(n, d, d3, distributionsModel.getFilter());
            }
            for (Object row : axisModel) {
                Number value = axisModel.getValue(row);
                if (value == null) continue;
                histogram.addValue(row, value.doubleValue());
            }
            this.axisHistogramCache.put(axisModel, histogram);
        }
        Histogram<Row> histogram = this.axisHistogramCache.get(axisModel);
        Intrinsics.checkNotNull(histogram);
        return histogram;
    }

    protected void refresh() {
        this.clearCache();
        this.repaint();
    }

    @Override
    public void clearCache() {
        this.axisHistogramCache.clear();
    }

    @Override
    @Nullable
    public DistributionDimension<Row, Value, Bin> getClosestDistribution(int x, int y) {
        DistributionsModel<Row, Column, Value, Bin> distributionsModel = this.getModel();
        Intrinsics.checkNotNull(distributionsModel);
        MutableVisibleOrder mutableVisibleOrder = distributionsModel.getAxisGroupModel().getAxisOrder();
        Intrinsics.checkNotNull((Object)mutableVisibleOrder);
        MutableVisibleOrder axisOrder = mutableVisibleOrder;
        int n = axisOrder.size();
        for (int i = 0; i < n; ++i) {
            double d;
            AxisModel xAxisModel = (AxisModel)axisOrder.get(i);
            DistributionsModel<Row, Column, Value, Bin> distributionsModel2 = this.getModel();
            Intrinsics.checkNotNull(distributionsModel2);
            double x1Location = distributionsModel2.getLocation(xAxisModel);
            double x2Location = 0.0;
            if (i + 1 < axisOrder.size()) {
                DistributionsModel<Row, Column, Value, Bin> distributionsModel3 = this.getModel();
                Intrinsics.checkNotNull(distributionsModel3);
                d = distributionsModel3.getLocation((AxisModel)axisOrder.get(i + 1));
            } else {
                d = 1.0;
            }
            x2Location = d;
            int x1 = (int)(x1Location * (double)this.getWidth()) + 1;
            int w = (int)((x2Location * (double)this.getWidth() - (double)x1) * (1.0 - this.margin));
            int x2 = x1 + w;
            if (x < x1 || x > x2) continue;
            return this.view.getDistributionDimension(xAxisModel);
        }
        return null;
    }

    @Override
    @Nullable
    public Bin getClosestBin(int x, int y) {
        DistributionsModel<Row, Column, Value, Bin> distributionsModel = this.getModel();
        Intrinsics.checkNotNull(distributionsModel);
        MutableVisibleOrder mutableVisibleOrder = distributionsModel.getAxisGroupModel().getAxisOrder();
        Intrinsics.checkNotNull((Object)mutableVisibleOrder);
        MutableVisibleOrder axisOrder = mutableVisibleOrder;
        int n = axisOrder.size();
        for (int i = 0; i < n; ++i) {
            DistributionDimension<Row, Value, Bin> dimension;
            double d;
            AxisModel xAxisModel = (AxisModel)axisOrder.get(i);
            DistributionsModel<Row, Column, Value, Bin> distributionsModel2 = this.getModel();
            Intrinsics.checkNotNull(distributionsModel2);
            double x1Location = distributionsModel2.getLocation(xAxisModel);
            double x2Location = 0.0;
            if (i + 1 < axisOrder.size()) {
                DistributionsModel<Row, Column, Value, Bin> distributionsModel3 = this.getModel();
                Intrinsics.checkNotNull(distributionsModel3);
                d = distributionsModel3.getLocation((AxisModel)axisOrder.get(i + 1));
            } else {
                d = 1.0;
            }
            x2Location = d;
            int x1 = (int)(x1Location * (double)this.getWidth()) + 1;
            int w = (int)((x2Location * (double)this.getWidth() - (double)x1) * (1.0 - this.margin));
            int x2 = x1 + w;
            if (x < x1 || x > x2) continue;
            Intrinsics.checkNotNull(this.view.getDistributionDimension(xAxisModel));
            boolean j = false;
            RandomAccessIterable randomAccessIterable = dimension.getBins();
            Intrinsics.checkNotNull((Object)randomAccessIterable);
            for (Object bin : randomAccessIterable) {
                int y1 = this.getHeight() - (int)((dimension.getBinStartValue(bin) - dimension.getMinValue()) * (double)this.getHeight() / (dimension.getMaxValue() - dimension.getMinValue()));
                int y2 = this.getHeight() - (int)((dimension.getBinEndValue(bin) - dimension.getMinValue()) * (double)this.getHeight() / (dimension.getMaxValue() - dimension.getMinValue()));
                if (y < y2 || y > y1) continue;
                return (Bin)bin;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public List<Bin> getBins(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        List list = null;
        DistributionsModel<Row, Column, Value, Bin> distributionsModel = this.getModel();
        Intrinsics.checkNotNull(distributionsModel);
        AxisGroupModel<Row, Column> axisGroupModel = distributionsModel.getAxisGroupModel();
        Intrinsics.checkNotNull(axisGroupModel);
        MutableVisibleOrder mutableVisibleOrder = axisGroupModel.getAxisOrder();
        Intrinsics.checkNotNull((Object)mutableVisibleOrder);
        MutableVisibleOrder axisOrder = mutableVisibleOrder;
        int n = axisOrder.size();
        for (int i = 0; i < n; ++i) {
            DistributionDimension<Row, Value, Bin> dimension;
            double d;
            AxisModel xAxisModel = (AxisModel)axisOrder.get(i);
            DistributionsModel<Row, Column, Value, Bin> distributionsModel2 = this.getModel();
            Intrinsics.checkNotNull(distributionsModel2);
            double x1Location = distributionsModel2.getLocation(xAxisModel);
            double x2Location = 0.0;
            if (i + 1 < axisOrder.size()) {
                DistributionsModel<Row, Column, Value, Bin> distributionsModel3 = this.getModel();
                Intrinsics.checkNotNull(distributionsModel3);
                d = distributionsModel3.getLocation((AxisModel)axisOrder.get(i + 1));
            } else {
                d = 1.0;
            }
            x2Location = d;
            int x1 = (int)(x1Location * (double)this.getWidth()) + 1;
            int w = (int)((x2Location * (double)this.getWidth() - (double)x1) * (1.0 - this.margin));
            int x2 = x1 + w;
            if (!(rect.getX() >= (double)x1) || !(rect.getX() <= (double)x2)) continue;
            DistributionDimension<Row, Value, Bin> distributionDimension = dimension = this.view.getDistributionDimension(xAxisModel);
            Intrinsics.checkNotNull(distributionDimension);
            RandomAccessIterable randomAccessIterable = distributionDimension.getBins();
            Intrinsics.checkNotNull((Object)randomAccessIterable);
            for (Object bin : randomAccessIterable) {
                int y1 = this.getHeight() - (int)((dimension.getBinStartValue(bin) - dimension.getMinValue()) * (double)this.getHeight() / (dimension.getMaxValue() - dimension.getMinValue()));
                int y2 = this.getHeight() - (int)((dimension.getBinEndValue(bin) - dimension.getMinValue()) * (double)this.getHeight() / (dimension.getMaxValue() - dimension.getMinValue()));
                if (!(rect.getY() >= (double)y2) || !(rect.getY() <= (double)y1)) continue;
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(bin);
            }
        }
        return list;
    }

    @Override
    @Nullable
    public Row getClosestRow(int x, int y) {
        AxisModel xAxisModel;
        int i;
        int n;
        DistributionsModel<Row, Column, Value, Bin> distributionsModel = this.getModel();
        Intrinsics.checkNotNull(distributionsModel);
        MutableVisibleOrder mutableVisibleOrder = distributionsModel.getAxisGroupModel().getAxisOrder();
        Intrinsics.checkNotNull((Object)mutableVisibleOrder);
        MutableVisibleOrder axisOrder = mutableVisibleOrder;
        int max_count = 0;
        if (this.scale == Scale.Global) {
            n = axisOrder.size();
            for (i = 0; i < n; ++i) {
                xAxisModel = (AxisModel)axisOrder.get(i);
                Histogram<Row> histogram = this.getHistogram(xAxisModel);
                max_count = Math.max(max_count, histogram.getMaxDensity());
            }
        }
        n = axisOrder.size();
        for (i = 0; i < n; ++i) {
            double d;
            xAxisModel = (AxisModel)axisOrder.get(i);
            DistributionsModel<Row, Column, Value, Bin> distributionsModel2 = this.getModel();
            Intrinsics.checkNotNull(distributionsModel2);
            double x1Location = distributionsModel2.getLocation(xAxisModel);
            double x2Location = 0.0;
            if (i + 1 < axisOrder.size()) {
                DistributionsModel<Row, Column, Value, Bin> distributionsModel3 = this.getModel();
                Intrinsics.checkNotNull(distributionsModel3);
                d = distributionsModel3.getLocation((AxisModel)axisOrder.get(i + 1));
            } else {
                d = 1.0;
            }
            x2Location = d;
            int x1 = (int)(x1Location * (double)this.getWidth()) + 1;
            int w = (int)((x2Location * (double)this.getWidth() - (double)x1) * (1.0 - this.margin));
            int x2 = x1 + w;
            if (x < x1 || x > x2) continue;
            Histogram<Row> histogram = this.getHistogram(xAxisModel);
            int n2 = histogram.getNumberOfBins();
            for (int j = 0; j < n2; ++j) {
                int y1 = this.getHeight() - (int)((histogram.getBinStartValue(j) - histogram.getMinValue()) * (double)this.getHeight() / (histogram.getMaxValue() - histogram.getMinValue()));
                int y2 = this.getHeight() - (int)((histogram.getBinEndValue(j) - histogram.getMinValue()) * (double)this.getHeight() / (histogram.getMaxValue() - histogram.getMinValue()));
                if (y < y2 || y > y1) continue;
                int activeCountAtBin = histogram.getActiveDensity(j);
                if (activeCountAtBin > 0) {
                    int activeWidth;
                    int max_width = x2 - x1;
                    if (this.scale == Scale.Local) {
                        max_count = histogram.getMaxDensity();
                    }
                    if ((activeWidth = activeCountAtBin * max_width / max_count) <= 0) continue;
                    int index = (x - x1) * (activeCountAtBin - 1) / activeWidth;
                    return index >= 0 && index < activeCountAtBin ? (Row)histogram.getActiveRowAtBin(j, index) : null;
                }
                return null;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected final State getState(@NotNull SingleBinningDimension<Row, Bin> dimension, Bin bin) {
        Intrinsics.checkNotNullParameter(dimension, (String)"dimension");
        v0 = dimension.getFilterExact();
        Intrinsics.checkNotNull((Object)v0);
        if (!v0.isActive()) ** GOTO lbl-1000
        v1 = dimension.getFilterExact();
        Intrinsics.checkNotNull((Object)v1);
        if (v1.isSelected(bin)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = selected = false;
        }
        if (selected && dimension.getActiveDensity(bin) > 0.0) {
            if (this.view.getProbing().isActive() && this.view.getProbing().isSelected((Object)new SimpleImmutableEntry(dimension, bin))) {
                v3 = dimension.getFilterExact();
                Intrinsics.checkNotNull((Object)v3);
                v4 = v3.isSelected(bin) ? State.ProbedSelected : State.Probed;
            } else {
                v5 = dimension.getFilterExact();
                Intrinsics.checkNotNull((Object)v5);
                v4 = v5.isSelected(bin) ? State.Selected : State.Active;
            }
        } else {
            v4 = dimension.getActiveDensity(bin) > 0.0 ? (this.view.getProbing().isActive() && this.view.getProbing().isSelected((Object)new SimpleImmutableEntry(dimension, bin)) ? State.ProbedSelectable : State.Selectable) : State.Inactive;
        }
        return v4;
    }

    @Override
    public void createOverplots() {
        if (this.getModel() != null) {
            this.getCanvas().removeAllLayers();
            this.getCanvas().addLayer((IDrawing)new HistogramIDrawing());
            RubberBand rubberBand = this.view.getRubberBand();
            this.getCanvas().addLayer((IDrawing)new RubberbandDrawing(this, rubberBand){
                final /* synthetic */ AbstractDistributionsComponent<Row, Column, Value, Bin> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                @NotNull
                protected Property<ColorTheme> getColorTheme() {
                    return (Property)this.this$0.getView().getColorTheme();
                }
            });
        }
    }

    public static final /* synthetic */ Map access$getAxisHistogramCache$p(AbstractDistributionsComponent $this) {
        return $this.axisHistogramCache;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/macrofocus/high_d/distributions/AbstractDistributionsComponent$Scale;", "", "(Ljava/lang/String;I)V", "Global", "Local", "highd"})
    private static final class Scale
    extends Enum<Scale> {
        public static final /* enum */ Scale Global = new Scale();
        public static final /* enum */ Scale Local = new Scale();
        private static final /* synthetic */ Scale[] $VALUES;

        public static Scale[] values() {
            return (Scale[])$VALUES.clone();
        }

        public static Scale valueOf(String value) {
            return Enum.valueOf(Scale.class, value);
        }

        static {
            $VALUES = scaleArray = new Scale[]{Scale.Global, Scale.Local};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0084\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/macrofocus/high_d/distributions/AbstractDistributionsComponent$State;", "", "(Ljava/lang/String;I)V", "Active", "Probed", "Selected", "ProbedSelected", "Selectable", "ProbedSelectable", "Inactive", "highd"})
    protected static final class State
    extends Enum<State> {
        public static final /* enum */ State Active = new State();
        public static final /* enum */ State Probed = new State();
        public static final /* enum */ State Selected = new State();
        public static final /* enum */ State ProbedSelected = new State();
        public static final /* enum */ State Selectable = new State();
        public static final /* enum */ State ProbedSelectable = new State();
        public static final /* enum */ State Inactive = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.Active, State.Probed, State.Selected, State.ProbedSelected, State.Selectable, State.ProbedSelectable, State.Inactive};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u0000*\u0004\b\u0004\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R/\u0010\b\u001a \u0012\u001c\u0012\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00030\u000b\u0012\u0004\u0012\u00028\u00030\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/macrofocus/high_d/distributions/AbstractDistributionsComponent$HistogramIDrawing;", "FontMetrics", "Lorg/mkui/graphics/AbstractIDrawing;", "(Lcom/macrofocus/high_d/distributions/AbstractDistributionsComponent;)V", "dimensionListener", "Lorg/molap/subset/DimensionListener;", "getDimensionListener", "()Lorg/molap/subset/DimensionListener;", "probingListener", "Lcom/macrofocus/common/selection/SingleSelectionListener;", "Lcom/macrofocus/common/collection/SimpleImmutableEntry;", "Lorg/molap/subset/SingleBinningDimension;", "getProbingListener", "()Lcom/macrofocus/common/selection/SingleSelectionListener;", "selectionListener", "Lcom/macrofocus/common/selection/SelectionListener;", "draw", "", "g", "Lorg/mkui/graphics/IGraphics;", "point", "Lorg/mkui/geom/Point2D;", "width", "", "height", "clipBounds", "Lorg/mkui/geom/Rectangle;", "highd"})
    private final class HistogramIDrawing<FontMetrics>
    extends AbstractIDrawing {
        @NotNull
        private final SelectionListener<Bin> selectionListener = new SelectionListener<Bin>(this){
            final /* synthetic */ HistogramIDrawing<FontMetrics> this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(@NotNull SelectionEvent<Bin> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                HistogramIDrawing.access$notifyIDrawingChanged(this.this$0);
            }
        };
        @NotNull
        private final DimensionListener<Row> dimensionListener = new DimensionListener<Row>(this){
            final /* synthetic */ HistogramIDrawing<FontMetrics> this$0;
            {
                this.this$0 = $receiver;
            }

            public void dimensionChanged(@NotNull DimensionEvent<Row> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                HistogramIDrawing.access$notifyIDrawingChanged(this.this$0);
            }

            public void selectedCountChanged() {
                HistogramIDrawing.access$notifyIDrawingChanged(this.this$0);
            }
        };
        @NotNull
        private final SingleSelectionListener<SimpleImmutableEntry<SingleBinningDimension<Row, Bin>, Bin>> probingListener = new SingleSelectionListener<SimpleImmutableEntry<SingleBinningDimension<Row, Bin>, Bin>>(this){
            final /* synthetic */ HistogramIDrawing<FontMetrics> this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(@NotNull SingleSelectionEvent<SimpleImmutableEntry<SingleBinningDimension<Row, Bin>, Bin>> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                HistogramIDrawing.access$notifyIDrawingChanged(this.this$0);
            }
        };

        public HistogramIDrawing() {
            DistributionsModel distributionsModel = AbstractDistributionsComponent.this.getModel();
            Intrinsics.checkNotNull(distributionsModel);
            MutableVisibleOrder axisOrder = distributionsModel.getAxisGroupModel().getAxisOrder();
            MutableVisibleOrder mutableVisibleOrder = axisOrder;
            Intrinsics.checkNotNull((Object)mutableVisibleOrder);
            int n = mutableVisibleOrder.size();
            for (int i = 0; i < n; ++i) {
                SingleBinningDimension dimension;
                AxisModel xAxisModel = (AxisModel)axisOrder.get(i);
                SingleBinningDimension singleBinningDimension = dimension = (SingleBinningDimension)AbstractDistributionsComponent.this.getView().getDistributionDimension(xAxisModel);
                Intrinsics.checkNotNull((Object)singleBinningDimension);
                singleBinningDimension.addDimensionListener(this.dimensionListener);
                MutableSelection mutableSelection = dimension.getFilterExact();
                Intrinsics.checkNotNull((Object)mutableSelection);
                mutableSelection.addWeakSelectionListener(this.selectionListener);
            }
            AbstractDistributionsComponent.this.getView().getProbing().addWeakSingleSelectionListener(this.probingListener);
        }

        @NotNull
        public final DimensionListener<Row> getDimensionListener() {
            return this.dimensionListener;
        }

        @NotNull
        public final SingleSelectionListener<SimpleImmutableEntry<SingleBinningDimension<Row, Bin>, Bin>> getProbingListener() {
            return this.probingListener;
        }

        public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
            AxisModel xAxisModel;
            int i;
            int n;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
            g.setColor(((ColorTheme)AbstractDistributionsComponent.this.getView().getColorTheme().getValue()).getBackground());
            g.fillRectangle(0, 0, AbstractDistributionsComponent.this.getWidth(), AbstractDistributionsComponent.this.getHeight());
            DistributionsModel distributionsModel = AbstractDistributionsComponent.this.getModel();
            Intrinsics.checkNotNull(distributionsModel);
            MutableVisibleOrder mutableVisibleOrder = distributionsModel.getAxisGroupModel().getAxisOrder();
            Intrinsics.checkNotNull((Object)mutableVisibleOrder);
            MutableVisibleOrder axisOrder = mutableVisibleOrder;
            double max_count = 0.0;
            if (AbstractDistributionsComponent.this.scale == Scale.Global) {
                n = axisOrder.size();
                for (i = 0; i < n; ++i) {
                    DistributionDimension dimension;
                    xAxisModel = (AxisModel)axisOrder.get(i);
                    Intrinsics.checkNotNull(AbstractDistributionsComponent.this.getView().getDistributionDimension(xAxisModel));
                    max_count = (Boolean)AbstractDistributionsComponent.this.getView().getShowFiltered().getValue() != false ? Math.max(max_count, dimension.getMaxDensity()) : Math.max(max_count, dimension.getMaxActiveDensity());
                }
            }
            n = axisOrder.size();
            for (i = 0; i < n; ++i) {
                RandomAccessIterable bins;
                double d;
                xAxisModel = (AxisModel)axisOrder.get(i);
                DistributionsModel distributionsModel2 = AbstractDistributionsComponent.this.getModel();
                Intrinsics.checkNotNull(distributionsModel2);
                double x1Location = distributionsModel2.getLocation(xAxisModel);
                double x2Location = 0.0;
                if (i + 1 < axisOrder.size()) {
                    DistributionsModel distributionsModel3 = AbstractDistributionsComponent.this.getModel();
                    Intrinsics.checkNotNull(distributionsModel3);
                    d = distributionsModel3.getLocation((AxisModel)axisOrder.get(i + 1));
                } else {
                    d = 1.0;
                }
                x2Location = d;
                DistributionDimension dimension = AbstractDistributionsComponent.this.getView().getDistributionDimension(xAxisModel);
                int x1 = (int)(x1Location * (double)AbstractDistributionsComponent.this.getWidth()) + 1;
                int w = (int)((x2Location * (double)AbstractDistributionsComponent.this.getWidth() - (double)x1) * (1.0 - AbstractDistributionsComponent.this.margin));
                int x2 = x1 + w;
                g.setColor(((ColorTheme)AbstractDistributionsComponent.this.getView().getColorTheme().getValue()).getGhostedPalette().getColor(1.0));
                g.drawLine(x1 - 1, 0, x1 - 1, AbstractDistributionsComponent.this.getHeight());
                int max_width = x2 - x1;
                if (AbstractDistributionsComponent.this.scale == Scale.Local) {
                    double d2;
                    if (((Boolean)AbstractDistributionsComponent.this.getView().getShowFiltered().getValue()).booleanValue()) {
                        DistributionDimension distributionDimension = dimension;
                        Intrinsics.checkNotNull(distributionDimension);
                        d2 = distributionDimension.getMaxDensity();
                    } else {
                        DistributionDimension distributionDimension = dimension;
                        Intrinsics.checkNotNull(distributionDimension);
                        d2 = distributionDimension.getMaxActiveDensity();
                    }
                    max_count = d2;
                }
                int x_prev = x1;
                int active_x_prev = x1;
                DistributionDimension distributionDimension = dimension;
                Intrinsics.checkNotNull(distributionDimension);
                Intrinsics.checkNotNull((Object)distributionDimension.getBins());
                Iterator it = bins.iterator();
                int j = 0;
                while (it.hasNext()) {
                    Object bin = it.next();
                    State state = AbstractDistributionsComponent.this.getState((SingleBinningDimension)dimension, bin);
                    Color outlineColor = null;
                    Color fillColor = null;
                    Color labelColor = null;
                    Palette palette = ((ColorTheme)AbstractDistributionsComponent.this.getView().getColorTheme().getValue()).getPalette();
                    switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                        case 1: {
                            outlineColor = null;
                            fillColor = palette.getColor(0.3);
                            labelColor = palette.getColor(0.7);
                            break;
                        }
                        case 2: {
                            outlineColor = ((ColorTheme)AbstractDistributionsComponent.this.getView().getColorTheme().getValue()).getProbing();
                            fillColor = palette.getColor(0.3);
                            labelColor = ((ColorTheme)AbstractDistributionsComponent.this.getView().getColorTheme().getValue()).getProbing();
                            break;
                        }
                        case 3: {
                            outlineColor = null;
                            fillColor = palette.getColor(0.55);
                            labelColor = palette.getColor(1.0);
                            break;
                        }
                        case 4: {
                            outlineColor = ((ColorTheme)AbstractDistributionsComponent.this.getView().getColorTheme().getValue()).getProbing();
                            fillColor = palette.getColor(0.55);
                            labelColor = ((ColorTheme)AbstractDistributionsComponent.this.getView().getColorTheme().getValue()).getProbing();
                            break;
                        }
                        case 5: {
                            outlineColor = null;
                            fillColor = palette.getColor(0.1);
                            labelColor = palette.getColor(0.3);
                            break;
                        }
                        case 6: {
                            outlineColor = ((ColorTheme)AbstractDistributionsComponent.this.getView().getColorTheme().getValue()).getProbing();
                            fillColor = palette.getColor(0.1);
                            labelColor = palette.getColor(0.7);
                            break;
                        }
                        case 7: {
                            outlineColor = null;
                            fillColor = palette.getColor(0.05);
                            labelColor = palette.getColor(0.2);
                            break;
                        }
                        default: {
                            outlineColor = null;
                            fillColor = MkColorFactory.Companion.getInstance().getGray();
                            labelColor = null;
                        }
                    }
                    if (dimension.getDensity(bin) > 0.0) {
                        int n2;
                        double selectionCountAtBin;
                        int width2 = (Integer)(dimension.getDensity(bin) * (double)max_width / max_count);
                        double binStartValue = dimension.getBinStartValue(bin);
                        int y1 = AbstractDistributionsComponent.this.getHeight() - (Integer)((binStartValue - dimension.getMinValue()) * (double)AbstractDistributionsComponent.this.getHeight() / (dimension.getMaxValue() - dimension.getMinValue()));
                        double binEndValue = dimension.getBinEndValue(bin);
                        int y2 = AbstractDistributionsComponent.this.getHeight() - (Integer)((binEndValue - dimension.getMinValue()) * (double)AbstractDistributionsComponent.this.getHeight() / (dimension.getMaxValue() - dimension.getMinValue()));
                        if (((Boolean)AbstractDistributionsComponent.this.getView().getShowFiltered().getValue()).booleanValue()) {
                            g.setColor(((ColorTheme)AbstractDistributionsComponent.this.getView().getColorTheme().getValue()).getGhostedPalette().getColor(0.0));
                            g.fillRectangle(x1, y2, width2, y1 - y2);
                        }
                        double activeCountAtBin = dimension.getActiveDensity(bin);
                        int activeWidth = (int)(activeCountAtBin * (double)max_width / max_count);
                        Color color = fillColor;
                        Intrinsics.checkNotNull((Object)color);
                        g.setColor(color);
                        g.fillRectangle(x1, y2, activeWidth, y1 - y2);
                        if (outlineColor != null) {
                            g.setColor(outlineColor);
                            g.drawRectange(x1, y2, activeWidth, y1 - y2);
                        }
                        if ((selectionCountAtBin = dimension.getSelectionDensity(bin)) > 0.0) {
                            int selectionWidth = (int)(selectionCountAtBin * (double)max_width / max_count);
                            g.setColor(((ColorTheme)AbstractDistributionsComponent.this.getView().getColorTheme().getValue()).getSelection());
                            g.fillRectangle(x1, y2, selectionWidth, y1 - y2);
                        }
                        if (((Boolean)AbstractDistributionsComponent.this.getView().getShowFiltered().getValue()).booleanValue()) {
                            int n3;
                            g.setColor(((ColorTheme)AbstractDistributionsComponent.this.getView().getColorTheme().getValue()).getGhostedPalette().getColor(1.0));
                            g.drawLine(x_prev, y1, x1 + width2, y1);
                            g.drawLine(x1 + width2, y1, x1 + width2, y2);
                            if (j == bins.size() - 1 || dimension.getBinStartValue(bins.get(j + 1)) != binEndValue) {
                                g.drawLine(x1 + width2, y2, x1, y2);
                                n3 = x1;
                            } else {
                                n3 = x1 + width2;
                            }
                            x_prev = n3;
                        }
                        g.setColor(((ColorTheme)AbstractDistributionsComponent.this.getView().getColorTheme().getValue()).getVisiblePalette().getColor(1.0));
                        g.drawLine(active_x_prev, y1, x1 + activeWidth, y1);
                        g.drawLine(x1 + activeWidth, y1, x1 + activeWidth, y2);
                        if (!it.hasNext() || dimension.getBinStartValue(bins.get(j + 1)) != binEndValue) {
                            g.drawLine(x1 + activeWidth, y2, x1, y2);
                            n2 = x1;
                        } else {
                            n2 = active_x_prev = x1 + activeWidth;
                        }
                        if (activeCountAtBin > 0.0) {
                            int r = 0;
                            while ((double)r < activeCountAtBin) {
                                ++r;
                            }
                        }
                    }
                    ++j;
                }
            }
        }

        public static final /* synthetic */ void access$notifyIDrawingChanged(HistogramIDrawing $this) {
            $this.notifyIDrawingChanged();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                nArray[State.Active.ordinal()] = 1;
                nArray[State.Probed.ordinal()] = 2;
                nArray[State.Selected.ordinal()] = 3;
                nArray[State.ProbedSelected.ordinal()] = 4;
                nArray[State.Selectable.ordinal()] = 5;
                nArray[State.ProbedSelectable.ordinal()] = 6;
                nArray[State.Inactive.ordinal()] = 7;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

