/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.tablelens;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.command.Future;
import com.macrofocus.common.concurrent.Callable;
import com.macrofocus.common.concurrent.ExecutorService;
import com.macrofocus.common.concurrent.Runtime;
import com.macrofocus.common.crossplatform.CPHelper;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.timer.CPTimer;
import com.macrofocus.common.timer.CPTimerListener;
import com.macrofocus.high_d.axis.AxisListener;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.tablelens.AbstractTableLensComponent;
import com.macrofocus.high_d.tablelens.TableLensComponent;
import com.macrofocus.high_d.tablelens.TableLensListener;
import com.macrofocus.high_d.tablelens.TableLensModel;
import com.macrofocus.high_d.tablelens.TableLensView;
import com.macrofocus.order.MutableVisibleOrder;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.paint.Color;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.CPCanvas;
import org.mkui.canvas.PaletteProvider;
import org.mkui.canvas.Rendering;
import org.mkui.color.MkColorKt;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.graphics.AbstractIDrawing;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.colortheme.ColorTheme;
import org.mkui.graphics.pressure.LogPressure;
import org.mkui.graphics.pressure.Pressure;
import org.mkui.palette.FixedPalette;
import org.mkui.rubberband.RubberBand;
import org.mkui.rubberband.RubberbandDrawing;
import org.mkui.visual.VisualLayer;
import org.mkui.visual.VisualListener;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b'\u0018\u0000 :*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u00029:B\u001b\b\u0004\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010$\u001a\u00020%H\u0016J\u001f\u0010&\u001a\u0004\u0018\u00018\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020(H$J\u0010\u0010,\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000.2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020(H$J%\u00102\u001a\u00020(2\u0006\u00103\u001a\u00028\u00002\u0006\u00104\u001a\u00020(2\u0006\u00105\u001a\u00020(H\u0002\u00a2\u0006\u0002\u00106J\b\u00107\u001a\u00020%H$J\b\u00108\u001a\u00020%H$R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R@\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00142\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0014@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R(\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010\u0006\u00a8\u0006;"}, d2={"Lcom/macrofocus/high_d/tablelens/AbstractTableLensComponent;", "Row", "Column", "Lcom/macrofocus/high_d/tablelens/TableLensComponent;", "view", "Lcom/macrofocus/high_d/tablelens/TableLensView;", "(Lcom/macrofocus/high_d/tablelens/TableLensView;)V", "axisListener", "Lcom/macrofocus/high_d/axis/AxisListener;", "canvas", "Lorg/mkui/canvas/CPCanvas;", "getCanvas", "()Lorg/mkui/canvas/CPCanvas;", "canvas$delegate", "Lkotlin/Lazy;", "listener", "Lcom/macrofocus/high_d/tablelens/TableLensListener;", "margin", "", "value", "Lcom/macrofocus/high_d/tablelens/TableLensModel;", "model", "getModel", "()Lcom/macrofocus/high_d/tablelens/TableLensModel;", "setModel", "(Lcom/macrofocus/high_d/tablelens/TableLensModel;)V", "orderListener", "Lcom/macrofocus/order/OrderListener;", "Lcom/macrofocus/high_d/axis/AxisModel;", "timer", "Lcom/macrofocus/common/timer/CPTimer;", "getTimer", "()Lcom/macrofocus/common/timer/CPTimer;", "getView", "()Lcom/macrofocus/high_d/tablelens/TableLensView;", "setView", "createOverplots", "", "getClosestRow", "x", "", "y", "(II)Ljava/lang/Object;", "getHeight", "getIndex", "getRows", "", "rect", "Lorg/mkui/geom/Rectangle2D;", "getWidth", "getY", "row", "objectCount", "height", "(Ljava/lang/Object;II)I", "refresh", "repaint", "AbstractVisualLayerIDrawing", "Companion", "highd"})
@StabilityInferred(parameters=0)
public abstract class AbstractTableLensComponent<Row, Column>
implements TableLensComponent<Row, Column> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private TableLensModel<Row, Column> model;
    private final double margin;
    @NotNull
    private final Lazy canvas$delegate;
    @Nullable
    private TableLensView<Row, Column> view;
    @NotNull
    private final TableLensListener listener;
    @NotNull
    private final AxisListener axisListener;
    @NotNull
    private final OrderListener<AxisModel<Row, Column>> orderListener;
    @NotNull
    private final CPTimer timer;
    public static final int $stable = 8;
    private static final boolean MULTITHREADED = true;
    @Nullable
    private static final ExecutorService executor = CPHelper.Companion.getInstance().visualizationExecutorService();

    protected AbstractTableLensComponent(@NotNull TableLensView<Row, Column> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        this.margin = 0.2;
        this.canvas$delegate = LazyKt.lazy((Function0)canvas.2.INSTANCE);
        this.listener = new TableLensListener(this){
            final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void tableLensChanged() {
                this.this$0.getTimer().restart();
            }
        };
        this.axisListener = new AxisListener(this){
            final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void axisChanged() {
                this.this$0.scheduleUpdate();
            }
        };
        this.orderListener = new OrderListener<AxisModel<Row, Column>>(this){
            final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void orderChanged(@Nullable OrderEvent<AxisModel<Row, Column>> event) {
                this.this$0.scheduleUpdate();
            }

            public void orderVisibility(@NotNull OrderEvent<AxisModel<Row, Column>> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.scheduleUpdate();
            }

            public void orderAdded(@NotNull OrderEvent<AxisModel<Row, Column>> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.scheduleUpdate();
            }

            public void orderRemoved(@NotNull OrderEvent<AxisModel<Row, Column>> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.scheduleUpdate();
            }
        };
        this.view = view;
        this.timer = CPHelper.Companion.getInstance().createTimer("TableLensResizer", 40, false, new CPTimerListener(){

            public void timerTriggered() {
                if (this.getWidth() > 0 && this.getHeight() > 0) {
                    this.refresh();
                }
            }
        });
    }

    @Override
    @Nullable
    public TableLensModel<Row, Column> getModel() {
        return this.model;
    }

    @Override
    public void setModel(@Nullable TableLensModel<Row, Column> value) {
        if (this.model != null) {
            TableLensModel<Row, Column> tableLensModel = this.model;
            Intrinsics.checkNotNull(tableLensModel);
            tableLensModel.removeTableLensListener(this.listener);
            TableLensModel<Row, Column> tableLensModel2 = this.model;
            Intrinsics.checkNotNull(tableLensModel2);
            MutableVisibleOrder mutableVisibleOrder = tableLensModel2.getAxisGroupModel().getAxisOrder();
            Intrinsics.checkNotNull((Object)mutableVisibleOrder);
            mutableVisibleOrder.removeOrderListener(this.orderListener);
            TableLensModel<Row, Column> tableLensModel3 = this.model;
            Intrinsics.checkNotNull(tableLensModel3);
            tableLensModel3.getAxisGroupModel().removeAxisListener(this.axisListener);
        }
        this.model = value;
        if (this.model != null) {
            this.createOverplots();
            TableLensModel<Row, Column> tableLensModel = this.model;
            Intrinsics.checkNotNull(tableLensModel);
            tableLensModel.addTableLensListener(this.listener);
            TableLensModel<Row, Column> tableLensModel4 = this.model;
            Intrinsics.checkNotNull(tableLensModel4);
            MutableVisibleOrder mutableVisibleOrder = tableLensModel4.getAxisGroupModel().getAxisOrder();
            Intrinsics.checkNotNull((Object)mutableVisibleOrder);
            mutableVisibleOrder.addOrderListener(this.orderListener);
            TableLensModel<Row, Column> tableLensModel5 = this.model;
            Intrinsics.checkNotNull(tableLensModel5);
            tableLensModel5.getAxisGroupModel().addAxisListener(this.axisListener);
        }
        this.timer.restart();
    }

    @NotNull
    protected final CPCanvas getCanvas() {
        Lazy lazy = this.canvas$delegate;
        return (CPCanvas)lazy.getValue();
    }

    @Nullable
    public final TableLensView<Row, Column> getView() {
        return this.view;
    }

    public final void setView(@Nullable TableLensView<Row, Column> tableLensView) {
        this.view = tableLensView;
    }

    @NotNull
    protected final CPTimer getTimer() {
        return this.timer;
    }

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract void refresh();

    protected abstract void repaint();

    @Override
    public void createOverplots() {
        if (this.getModel() != null) {
            this.getCanvas().removeAllLayers();
            this.getCanvas().addLayer((IDrawing)new AbstractIDrawing(this){
                final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
                    Color background;
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                    ColorTheme colorTheme = this.this$0.getView();
                    Color color = colorTheme != null && (colorTheme = colorTheme.getColorTheme()) != null && (colorTheme = (ColorTheme)colorTheme.getValue()) != null ? colorTheme.getBackground() : (background = null);
                    if (background != null) {
                        g.setColor(background);
                        g.fillRectangle2D((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
                    }
                }
            });
            CPCanvas cPCanvas = this.getCanvas();
            TableLensView<Row, Column> tableLensView = this.view;
            Intrinsics.checkNotNull(tableLensView);
            Rendering rendering = (Rendering)tableLensView.getRendering().getValue();
            TableLensModel<Row, Column> tableLensModel = this.getModel();
            Intrinsics.checkNotNull(tableLensModel);
            VisualLayer visualLayer = tableLensModel.getVisual().getMultipleSelected();
            cPCanvas.addDensityLayer(rendering, (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer){
                final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void draw(@NotNull IGraphics g, int x, int y, int width, int height, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    g.fillRectangle(x, y, this.this$0.getWidth(), height);
                }
            }, (Pressure)new LogPressure(), new PaletteProvider(this){
                final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public FixedPalette getPalette() {
                    TableLensView<Row, Column> tableLensView = this.this$0.getView();
                    Intrinsics.checkNotNull(tableLensView);
                    return ((ColorTheme)tableLensView.getColorTheme().getValue()).getSelectedShadowPalette();
                }
            });
            CPCanvas cPCanvas2 = this.getCanvas();
            TableLensModel<Row, Column> tableLensModel2 = this.getModel();
            Intrinsics.checkNotNull(tableLensModel2);
            visualLayer = tableLensModel2.getVisual().getSingleSelected();
            cPCanvas2.addLayer((IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer){
                @NotNull
                private final Color color;
                final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                    this.color = MkColorKt.colorOf((int)255, (int)0, (int)0);
                }

                @NotNull
                public final Color getColor() {
                    return this.color;
                }

                public void draw(@NotNull IGraphics g, int x, int y, int width, int height, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    g.setColor(this.color);
                    g.fillRectangle(x, y, this.this$0.getWidth(), height);
                }
            });
            CPCanvas cPCanvas3 = this.getCanvas();
            TableLensModel<Row, Column> tableLensModel3 = this.getModel();
            Intrinsics.checkNotNull(tableLensModel3);
            visualLayer = tableLensModel3.getVisual().getProbed();
            cPCanvas3.addLayer((IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer){
                @NotNull
                private final Color selectionColor;
                @NotNull
                private final Color color;
                final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                    this.selectionColor = MkColorKt.colorOf((int)255, (int)0, (int)0);
                    this.color = MkColorKt.colorOf((int)255, (int)200, (int)0);
                }

                @NotNull
                public final Color getSelectionColor() {
                    return this.selectionColor;
                }

                @NotNull
                public final Color getColor() {
                    return this.color;
                }

                public void draw(@NotNull IGraphics g, int x, int y, int width, int height, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    g.setColor(this.color);
                    g.fillRectangle(x, y - 1, this.this$0.getWidth(), height + 2);
                    TableLensModel<Row, Column> tableLensModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(tableLensModel);
                    if (tableLensModel.getVisual().getSelection().isSelected(row)) {
                        g.setColor(this.selectionColor);
                        g.fillRectangle(x, y, this.this$0.getWidth(), height);
                    }
                }
            });
            CPCanvas cPCanvas4 = this.getCanvas();
            TableLensView<Row, Column> tableLensView2 = this.view;
            Intrinsics.checkNotNull(tableLensView2);
            Rendering rendering2 = (Rendering)tableLensView2.getRendering().getValue();
            TableLensModel<Row, Column> tableLensModel4 = this.getModel();
            Intrinsics.checkNotNull(tableLensModel4);
            visualLayer = tableLensModel4.getVisual().getFiltered();
            cPCanvas4.addDensityLayer(rendering2, (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer){
                final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public boolean isActive() {
                    TableLensView<Row, Column> tableLensView = this.this$0.getView();
                    Intrinsics.checkNotNull(tableLensView);
                    return (Boolean)tableLensView.getShowFiltered().getValue() != false && super.isActive();
                }

                public void draw(@NotNull IGraphics g, int x, int y, int width, int height, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    g.fillRectangle(x, y, width, height);
                }
            }, (Pressure)new LogPressure(), new PaletteProvider(this){
                final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public FixedPalette getPalette() {
                    TableLensView<Row, Column> tableLensView = this.this$0.getView();
                    Intrinsics.checkNotNull(tableLensView);
                    return ((ColorTheme)tableLensView.getColorTheme().getValue()).getGhostedPalette();
                }
            });
            CPCanvas cPCanvas5 = this.getCanvas();
            TableLensView<Row, Column> tableLensView3 = this.view;
            Intrinsics.checkNotNull(tableLensView3);
            Rendering rendering3 = (Rendering)tableLensView3.getRendering().getValue();
            TableLensModel<Row, Column> tableLensModel5 = this.getModel();
            Intrinsics.checkNotNull(tableLensModel5);
            visualLayer = tableLensModel5.getVisual().getVisible();
            cPCanvas5.addDensityLayer(rendering3, (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer){

                public void draw(@NotNull IGraphics g, int x, int y, int width, int height, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    g.fillRectangle(x, y, width, height);
                }
            }, (Pressure)new LogPressure(), new PaletteProvider(this){
                final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public FixedPalette getPalette() {
                    TableLensView<Row, Column> tableLensView = this.this$0.getView();
                    Intrinsics.checkNotNull(tableLensView);
                    return ((ColorTheme)tableLensView.getColorTheme().getValue()).getVisiblePalette();
                }
            });
            CPCanvas cPCanvas6 = this.getCanvas();
            TableLensView<Row, Column> tableLensView4 = this.view;
            Intrinsics.checkNotNull(tableLensView4);
            Rendering rendering4 = (Rendering)tableLensView4.getRendering().getValue();
            TableLensModel<Row, Column> tableLensModel6 = this.getModel();
            Intrinsics.checkNotNull(tableLensModel6);
            visualLayer = tableLensModel6.getVisual().getColorMapped();
            cPCanvas6.addAveragingLayer(rendering4, (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer){
                final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void draw(@NotNull IGraphics g, int x, int y, int width, int height, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    TableLensModel<Row, Column> tableLensModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(tableLensModel);
                    Color color = tableLensModel.getColorMapping().getColor(row);
                    Intrinsics.checkNotNull((Object)color);
                    g.setColor(color);
                    g.fillRectangle(x, y, width, height);
                }
            });
            CPCanvas cPCanvas7 = this.getCanvas();
            TableLensModel<Row, Column> tableLensModel7 = this.getModel();
            Intrinsics.checkNotNull(tableLensModel7);
            visualLayer = tableLensModel7.getVisual().getColored();
            cPCanvas7.addBufferedLayer((IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer){
                final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void draw(@NotNull IGraphics g, int x, int y, int width, int height, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    TableLensModel<Row, Column> tableLensModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(tableLensModel);
                    Color color = tableLensModel.getColoring().getColor(row);
                    Intrinsics.checkNotNull((Object)color);
                    g.setColor(color);
                    g.fillRectangle(x, y, width, height);
                }
            });
            CPCanvas cPCanvas8 = this.getCanvas();
            TableLensView<Row, Column> tableLensView5 = this.view;
            Intrinsics.checkNotNull(tableLensView5);
            Rendering rendering5 = (Rendering)tableLensView5.getRendering().getValue();
            TableLensModel<Row, Column> tableLensModel8 = this.getModel();
            Intrinsics.checkNotNull(tableLensModel8);
            visualLayer = tableLensModel8.getVisual().getMultipleSelected();
            cPCanvas8.addDensityLayer(rendering5, (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer){

                public void draw(@NotNull IGraphics g, int x, int y, int width, int height, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    g.fillRectangle(x, y, width, height);
                }
            }, (Pressure)new LogPressure(), new PaletteProvider(this){
                final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public FixedPalette getPalette() {
                    TableLensView<Row, Column> tableLensView = this.this$0.getView();
                    Intrinsics.checkNotNull(tableLensView);
                    return ((ColorTheme)tableLensView.getColorTheme().getValue()).getSelectedPalette();
                }
            });
            CPCanvas cPCanvas9 = this.getCanvas();
            TableLensModel<Row, Column> tableLensModel9 = this.getModel();
            Intrinsics.checkNotNull(tableLensModel9);
            visualLayer = tableLensModel9.getVisual().getSingleSelected();
            cPCanvas9.addLayer((IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer){
                final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void draw(@NotNull IGraphics g, int x, int y, int width, int height, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    TableLensView<Row, Column> tableLensView = this.this$0.getView();
                    Intrinsics.checkNotNull(tableLensView);
                    g.setColor(((ColorTheme)tableLensView.getColorTheme().getValue()).getSelection());
                    g.fillRectangle(x, y, width, height);
                }
            });
            CPCanvas cPCanvas10 = this.getCanvas();
            TableLensModel<Row, Column> tableLensModel10 = this.getModel();
            Intrinsics.checkNotNull(tableLensModel10);
            visualLayer = tableLensModel10.getVisual().getProbed();
            cPCanvas10.addLayer((IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer){
                final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void draw(@NotNull IGraphics g, int x, int y, int width, int height, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    TableLensView<Row, Column> tableLensView = this.this$0.getView();
                    Intrinsics.checkNotNull(tableLensView);
                    g.setColor(((ColorTheme)tableLensView.getColorTheme().getValue()).getProbing());
                    g.fillRectangle(x, y - 1, width, height + 2);
                    TableLensModel<Row, Column> tableLensModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(tableLensModel);
                    if (tableLensModel.getVisual().getSelection().isSelected(row)) {
                        TableLensView<Row, Column> tableLensView2 = this.this$0.getView();
                        Intrinsics.checkNotNull(tableLensView2);
                        g.setColor(((ColorTheme)tableLensView2.getColorTheme().getValue()).getSelection());
                        g.fillRectangle(x, y, width, height);
                    }
                }
            });
            CPCanvas cPCanvas11 = this.getCanvas();
            TableLensView<Row, Column> tableLensView6 = this.view;
            Intrinsics.checkNotNull(tableLensView6);
            visualLayer = tableLensView6.getRubberBand();
            cPCanvas11.addLayer((IDrawing)new RubberbandDrawing(this, (RubberBand)visualLayer){
                final /* synthetic */ AbstractTableLensComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                @NotNull
                protected Property<ColorTheme> getColorTheme() {
                    TableLensView<Row, Column> tableLensView = this.this$0.getView();
                    Intrinsics.checkNotNull(tableLensView);
                    return (Property)tableLensView.getColorTheme();
                }
            });
        }
    }

    private final int getY(Row row, int objectCount, int height) {
        int n;
        if (objectCount > 1) {
            TableLensModel<Row, Column> tableLensModel = this.getModel();
            Intrinsics.checkNotNull(tableLensModel);
            n = tableLensModel.getIndex(row) * (height - 1) / objectCount;
        } else {
            n = 0;
        }
        return n;
    }

    private final int getIndex(int y) {
        TableLensModel<Row, Column> tableLensModel = this.getModel();
        Intrinsics.checkNotNull(tableLensModel);
        return y * (tableLensModel.getObjectCount() - 1) / (this.getHeight() - 1);
    }

    @Override
    @Nullable
    public Row getClosestRow(int x, int y) {
        TableLensModel<Row, Column> tableLensModel = this.getModel();
        Intrinsics.checkNotNull(tableLensModel);
        Row row = tableLensModel.getObject(this.getIndex(y));
        TableLensModel<Row, Column> tableLensModel2 = this.getModel();
        Intrinsics.checkNotNull(tableLensModel2);
        return (Row)(!tableLensModel2.getFilter().isFiltered(row) ? row : null);
    }

    @Override
    @NotNull
    public List<Row> getRows(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        List list = new ArrayList();
        int index1 = this.getIndex((int)rect.getMinY());
        int index2 = this.getIndex((int)rect.getMaxY());
        int i = index1;
        if (i <= index2) {
            while (true) {
                TableLensModel<Row, Column> tableLensModel = this.getModel();
                Intrinsics.checkNotNull(tableLensModel);
                Row row = tableLensModel.getObject(i);
                TableLensModel<Row, Column> tableLensModel2 = this.getModel();
                Intrinsics.checkNotNull(tableLensModel2);
                if (!tableLensModel2.getFilter().isFiltered(row)) {
                    list.add(row);
                }
                if (i == index2) break;
                ++i;
            }
        }
        return list;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u0015\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0004JO\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0004\u00a2\u0006\u0002\u0010\u0014J=\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0018J2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/macrofocus/high_d/tablelens/AbstractTableLensComponent$AbstractVisualLayerIDrawing;", "Lorg/mkui/graphics/AbstractIDrawing;", "visualLayer", "Lorg/mkui/visual/VisualLayer;", "(Lcom/macrofocus/high_d/tablelens/AbstractTableLensComponent;Lorg/mkui/visual/VisualLayer;)V", "isActive", "", "()Z", "draw", "", "g", "Lorg/mkui/graphics/IGraphics;", "row", "height", "", "axisOrder", "Lcom/macrofocus/order/MutableVisibleOrder;", "Lcom/macrofocus/high_d/axis/AxisModel;", "objectCount", "rowHeight", "(Lorg/mkui/graphics/IGraphics;Ljava/lang/Object;ILcom/macrofocus/order/MutableVisibleOrder;II)V", "x", "y", "width", "(Lorg/mkui/graphics/IGraphics;IIIILjava/lang/Object;)V", "point", "Lorg/mkui/geom/Point2D;", "", "clipBounds", "Lorg/mkui/geom/Rectangle;", "highd"})
    public abstract class AbstractVisualLayerIDrawing
    extends AbstractIDrawing {
        @NotNull
        private final VisualLayer<Row> visualLayer;

        protected AbstractVisualLayerIDrawing(VisualLayer<Row> visualLayer) {
            Intrinsics.checkNotNullParameter(visualLayer, (String)"visualLayer");
            this.visualLayer = visualLayer;
            visualLayer.addVisualListener(new VisualListener(){

                public void visualChanged() {
                    this.notifyIDrawingChanged();
                }
            });
        }

        public boolean isActive() {
            return this.visualLayer.isActive();
        }

        public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
            block9: {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                if (this.visualLayer.getObjectCount() <= 0) break block9;
                int height2 = AbstractTableLensComponent.this.getHeight();
                TableLensModel tableLensModel = AbstractTableLensComponent.this.getModel();
                Intrinsics.checkNotNull(tableLensModel);
                MutableVisibleOrder mutableVisibleOrder = tableLensModel.getAxisGroupModel().getAxisOrder();
                Intrinsics.checkNotNull((Object)mutableVisibleOrder);
                MutableVisibleOrder axisOrder = mutableVisibleOrder;
                TableLensModel tableLensModel2 = AbstractTableLensComponent.this.getModel();
                Intrinsics.checkNotNull(tableLensModel2);
                int objectCount = tableLensModel2.getObjectCount();
                int rowHeight = (int)Math.max(Math.ceil((double)height2 / (double)objectCount), 1.0);
                if (!g.isThreadSafe()) {
                    for (Object row : this.visualLayer) {
                        this.draw(g, row, height2, axisOrder, objectCount, rowHeight);
                    }
                } else {
                    int nTasks = Math.min(Runtime.Companion.getRuntime().availableProcessors(), this.visualLayer.getObjectCount());
                    int nRowsPerTask = this.visualLayer.getObjectCount() / nTasks;
                    List todo = new ArrayList(nTasks);
                    for (int nTask = 0; nTask < nTasks; ++nTask) {
                        int fromRow = nTask * nRowsPerTask;
                        int toRow = nTask < nTasks - 1 ? fromRow + nRowsPerTask : this.visualLayer.getObjectCount();
                        todo.add(new Callable<Object>(this, fromRow, toRow, g, height2, axisOrder, objectCount, rowHeight){
                            final /* synthetic */ AbstractVisualLayerIDrawing this$0;
                            final /* synthetic */ int $fromRow;
                            final /* synthetic */ int $toRow;
                            final /* synthetic */ IGraphics $g;
                            final /* synthetic */ int $height;
                            final /* synthetic */ MutableVisibleOrder<AxisModel<Row, Column>> $axisOrder;
                            final /* synthetic */ int $objectCount;
                            final /* synthetic */ int $rowHeight;
                            {
                                this.this$0 = $receiver;
                                this.$fromRow = $fromRow;
                                this.$toRow = $toRow;
                                this.$g = $g;
                                this.$height = $height;
                                this.$axisOrder = $axisOrder;
                                this.$objectCount = $objectCount;
                                this.$rowHeight = $rowHeight;
                            }

                            @Nullable
                            public Object call() throws Exception {
                                for (T row : AbstractVisualLayerIDrawing.access$getVisualLayer$p(this.this$0).iterable(this.$fromRow, this.$toRow - 1)) {
                                    this.this$0.draw(this.$g, row, this.$height, this.$axisOrder, this.$objectCount, this.$rowHeight);
                                }
                                return null;
                            }
                        });
                    }
                    try {
                        ExecutorService executorService = executor;
                        Intrinsics.checkNotNull((Object)executorService);
                        List answers = executorService.invokeAll((Collection)todo);
                        for (Future answer : answers) {
                            try {
                                answer.get();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        protected final void draw(@NotNull IGraphics g, Row row, int height, @NotNull MutableVisibleOrder<AxisModel<Row, Column>> axisOrder, int objectCount, int rowHeight) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter(axisOrder, (String)"axisOrder");
            int y = AbstractTableLensComponent.this.getY(row, objectCount, height);
            int axisCount = axisOrder.size();
            for (int i = 0; i < axisCount; ++i) {
                Number value;
                Double d;
                Object object = axisOrder.get(i);
                Intrinsics.checkNotNull((Object)object);
                AxisModel xAxisModel = (AxisModel)object;
                TableLensModel tableLensModel = AbstractTableLensComponent.this.getModel();
                Double x1Location = tableLensModel != null ? Double.valueOf(tableLensModel.getLocation(xAxisModel)) : null;
                Double x2Location = null;
                if (i + 1 < axisCount) {
                    TableLensModel tableLensModel2 = AbstractTableLensComponent.this.getModel();
                    if (tableLensModel2 != null) {
                        Object object2 = axisOrder.get(i + 1);
                        Intrinsics.checkNotNull((Object)object2);
                        d = tableLensModel2.getLocation((AxisModel)object2);
                    } else {
                        d = null;
                    }
                } else {
                    d = x2Location = Double.valueOf(1.0);
                }
                if (x1Location == null || x2Location == null || (value = xAxisModel.getValue(row)) == null) continue;
                int cw = AbstractTableLensComponent.this.getWidth();
                int x = (int)(x1Location * (double)cw);
                int w = (int)((x2Location * (double)cw - (double)x) * (1.0 - AbstractTableLensComponent.this.margin));
                double range = xAxisModel.getMaximum() - xAxisModel.getMinimum();
                int width = (int)((double)w * (value.doubleValue() - xAxisModel.getMinimum()) / range);
                width = Math.min(w, width);
                width = Math.max(1, width);
                this.draw(g, x, y, width, rowHeight, row);
            }
        }

        public abstract void draw(@NotNull IGraphics var1, int var2, int var3, int var4, int var5, Row var6);

        public static final /* synthetic */ VisualLayer access$getVisualLayer$p(AbstractVisualLayerIDrawing $this) {
            return $this.visualLayer;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/macrofocus/high_d/tablelens/AbstractTableLensComponent$Companion;", "", "()V", "MULTITHREADED", "", "executor", "Lcom/macrofocus/common/concurrent/ExecutorService;", "highd"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

