/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.distributions;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.filter.Filter;
import com.macrofocus.high_d.distributions.Histogram;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\u001b\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J\u001d\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0004H\u0016J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0004H\u0016J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J\b\u0010&\u001a\u00020\u0004H\u0016J\b\u0010'\u001a\u00020\u0004H\u0016J\b\u0010(\u001a\u00020\u0006H\u0016J\b\u0010)\u001a\u00020\u0006H\u0016J\b\u0010*\u001a\u00020\u0004H\u0016J\u0006\u0010+\u001a\u00020\u0004J\u0006\u0010,\u001a\u00020\u0004J\b\u0010-\u001a\u00020.H\u0016R\u001e\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/macrofocus/high_d/distributions/FixedBinsHistogram;", "R", "Lcom/macrofocus/high_d/distributions/Histogram;", "numberOfBins", "", "minValue", "", "maxValue", "filter", "Lcom/macrofocus/common/filter/Filter;", "(IDDLcom/macrofocus/common/filter/Filter;)V", "activeBins", "", "", "[Ljava/util/List;", "activeMaxCount", "activeOverflowBin", "activeUnderflowBin", "bins", "", "maxCount", "overflowBin", "underflowBin", "addValue", "", "row", "value", "(Ljava/lang/Object;D)V", "getActiveDensity", "index", "getActiveRowAtBin", "j", "(II)Ljava/lang/Object;", "getBin", "getBinEndValue", "bin", "getBinStartValue", "getDensity", "getMaxActiveDensity", "getMaxDensity", "getMaxValue", "getMinValue", "getNumberOfBins", "getOverflowBin", "getUnderflowBin", "toString", "", "highd"})
@StabilityInferred(parameters=0)
public final class FixedBinsHistogram<R>
implements Histogram<R> {
    private final int numberOfBins;
    private final double minValue;
    private final double maxValue;
    private int maxCount;
    private int activeMaxCount;
    @NotNull
    private final int[] bins;
    private int underflowBin;
    private int overflowBin;
    @NotNull
    private final List<R>[] activeBins;
    @NotNull
    private final List<R> activeUnderflowBin;
    @NotNull
    private final List<R> activeOverflowBin;
    @NotNull
    private final Filter<R> filter;
    public static final int $stable = 8;

    public FixedBinsHistogram(int numberOfBins, double minValue, double maxValue, @NotNull Filter<R> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        this.numberOfBins = numberOfBins;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.activeUnderflowBin = new ArrayList();
        this.activeOverflowBin = new ArrayList();
        this.bins = new int[this.numberOfBins];
        this.activeBins = new List[this.numberOfBins];
        int n = this.activeBins.length;
        for (int i = 0; i < n; ++i) {
            this.activeBins[i] = new ArrayList();
        }
        this.filter = filter;
    }

    public final void addValue(R row, double value) {
        if (this.numberOfBins <= 0) {
            return;
        }
        int bin = this.getBin(value);
        if (bin < 0) {
            switch (bin) {
                case -1: {
                    int n = this.underflowBin;
                    this.underflowBin = n + 1;
                    break;
                }
                case -2: {
                    int n = this.overflowBin;
                    this.overflowBin = n + 1;
                }
            }
        } else {
            int[] nArray = this.bins;
            int n = nArray[bin];
            nArray[bin] = n + 1;
            if (this.bins[bin] > this.maxCount) {
                this.maxCount = this.bins[bin];
            }
        }
        if (!this.filter.isFiltered(row)) {
            if (bin < 0) {
                switch (bin) {
                    case -1: {
                        this.activeUnderflowBin.add(row);
                        break;
                    }
                    case -2: {
                        this.activeOverflowBin.add(row);
                    }
                }
            } else {
                List<R> list = this.activeBins[bin];
                Intrinsics.checkNotNull(list);
                list.add(row);
                List<R> list2 = this.activeBins[bin];
                Intrinsics.checkNotNull(list2);
                if (list2.size() > this.activeMaxCount) {
                    List<R> list3 = this.activeBins[bin];
                    Intrinsics.checkNotNull(list3);
                    this.activeMaxCount = list3.size();
                }
            }
        }
    }

    @Override
    public int getActiveDensity(int index) {
        List<R> list = this.activeBins[index];
        Intrinsics.checkNotNull(list);
        return list.size();
    }

    @Override
    public R getActiveRowAtBin(int j, int index) {
        List<R> list = this.activeBins[j];
        Intrinsics.checkNotNull(list);
        return list.get(index);
    }

    @Override
    public int getDensity(int index) {
        return this.bins[index];
    }

    @Override
    public int getNumberOfBins() {
        return this.numberOfBins;
    }

    @Override
    public double getMinValue() {
        return this.minValue;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public double getBinStartValue(int bin) {
        return (double)bin * ((this.maxValue - this.minValue) / (double)this.numberOfBins) + this.minValue;
    }

    @Override
    public double getBinEndValue(int bin) {
        return (double)(bin + 1) * ((this.maxValue - this.minValue) / (double)this.numberOfBins) + this.minValue;
    }

    @Override
    public int getMaxActiveDensity() {
        return this.activeMaxCount;
    }

    @Override
    public int getMaxDensity() {
        return this.maxCount;
    }

    public final int getUnderflowBin() {
        return this.underflowBin;
    }

    public final int getOverflowBin() {
        return this.overflowBin;
    }

    @Override
    public int getBin(double value) {
        if (value < this.minValue) {
            return -1;
        }
        if (value > this.maxValue) {
            return -2;
        }
        if (value == this.maxValue) {
            return this.numberOfBins - 1;
        }
        return value == this.minValue ? 0 : (int)((value - this.minValue) / ((this.maxValue - this.minValue) / (double)this.numberOfBins));
    }

    @NotNull
    public String toString() {
        Object content = "------\n";
        content = (String)content + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "\n";
        content = (String)content + "   Number of bins: " + this.numberOfBins + "\n";
        content = (String)content + "   Min value:      " + this.minValue + "\n";
        content = (String)content + "   Max value:      " + this.maxValue + "\n";
        content = (String)content + "   Max count:      " + this.maxCount + "\n";
        content = (String)content + "   Underflow bin:  " + this.underflowBin + "\n";
        content = (String)content + "   Overflow bin:   " + this.overflowBin + "\n";
        return content;
    }
}

