/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.statistics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.filter.Filter;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.statistics.PresentationStatisticsDataFrame;
import com.macrofocus.high_d.statistics.Statistics;
import com.macrofocus.high_d.statistics.StatisticsDataFrame;
import com.macrofocus.high_d.table.ShowFilteredDataFrame;
import com.macrofocus.high_d.table.Table;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.colormap.ColorMapFactory;
import org.mkui.colormapping.MutableColorMapping;
import org.mkui.graphics.colortheme.ColorTheme;
import org.mkui.visual.Visual;
import org.mkui.visual.VisualObjects;
import org.molap.dataframe.DataFrame;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\tH$J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016JJ\u0010\u0015\u001a\u00020\u00132\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/macrofocus/high_d/statistics/AbstractStatistics;", "R", "C", "V", "Lcom/macrofocus/high_d/statistics/Statistics;", "colorMapFactory", "Lorg/mkui/colormap/ColorMapFactory;", "(Lorg/mkui/colormap/ColorMapFactory;)V", "table", "Lcom/macrofocus/high_d/table/Table;", "Lcom/macrofocus/high_d/statistics/StatisticsDataFrame$Stat;", "", "getTable", "()Lcom/macrofocus/high_d/table/Table;", "createTable", "getColorTheme", "Lcom/macrofocus/common/properties/MutableProperty;", "Lorg/mkui/graphics/colortheme/ColorTheme;", "setColorTheme", "", "colorTheme", "setModel", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "visual", "Lorg/mkui/visual/Visual;", "axisGroupModel", "Lcom/macrofocus/high_d/axis/group/AxisGroupModel;", "highd"})
@StabilityInferred(parameters=0)
public abstract class AbstractStatistics<R, C, V>
implements Statistics<R, C, V> {
    @NotNull
    private final ColorMapFactory colorMapFactory;
    @Nullable
    private final Table<StatisticsDataFrame.Stat, C, Object> table;
    public static final int $stable = ColorMapFactory.$stable;

    public AbstractStatistics(@NotNull ColorMapFactory colorMapFactory) {
        Intrinsics.checkNotNullParameter((Object)colorMapFactory, (String)"colorMapFactory");
        this.colorMapFactory = colorMapFactory;
        this.table = this.createTable();
    }

    @Nullable
    protected final Table<StatisticsDataFrame.Stat, C, Object> getTable() {
        return this.table;
    }

    @Override
    public void setModel(@NotNull DataFrame<R, C, V> dataFrame, @NotNull Visual<R, C> visual, @NotNull AxisGroupModel<R, C> axisGroupModel) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter(visual, (String)"visual");
        Intrinsics.checkNotNullParameter(axisGroupModel, (String)"axisGroupModel");
        StatisticsDataFrame<R, C> statisticsDataFrame = new StatisticsDataFrame<R, C>(dataFrame, visual.getProbing(), visual.getSelection(), (Filter)visual.getFilter(), visual.getColorMapping(), visual.getColoring());
        DataFrame annotationDataFrame = (DataFrame)new PresentationStatisticsDataFrame<R, C>(statisticsDataFrame, axisGroupModel);
        SimpleVisualObjects visualObjects = new SimpleVisualObjects(annotationDataFrame);
        VisualObjects visualObjects2 = (VisualObjects)visualObjects;
        MutableSingleSelection mutableSingleSelection = visual.getAnnotationProbing();
        Intrinsics.checkNotNull((Object)mutableSingleSelection, (String)"null cannot be cast to non-null type com.macrofocus.common.selection.MutableSingleSelection<com.macrofocus.high_d.statistics.StatisticsDataFrame.Stat>");
        MutableSelection mutableSelection = visual.getAnnotationSelection();
        Intrinsics.checkNotNull((Object)mutableSelection, (String)"null cannot be cast to non-null type com.macrofocus.common.selection.MutableSelection<com.macrofocus.high_d.statistics.StatisticsDataFrame.Stat>");
        Visual v = (Visual)new SimpleVisual(visualObjects2, mutableSingleSelection, mutableSelection, (MutableColorMapping)new SimpleColorMapping(this.colorMapFactory, annotationDataFrame));
        Table table = this.table;
        Intrinsics.checkNotNull(table);
        table.setModel(new ShowFilteredDataFrame(annotationDataFrame, annotationDataFrame, this.table.getShowFiltered()), v, axisGroupModel);
    }

    @Nullable
    protected abstract Table<StatisticsDataFrame.Stat, C, Object> createTable();

    @Override
    @NotNull
    public MutableProperty<ColorTheme> getColorTheme() {
        Table<StatisticsDataFrame.Stat, C, Object> table = this.table;
        Intrinsics.checkNotNull(table);
        return table.getColorTheme();
    }

    @Override
    public void setColorTheme(@NotNull MutableProperty<ColorTheme> colorTheme) {
        Intrinsics.checkNotNullParameter(colorTheme, (String)"colorTheme");
        Table<StatisticsDataFrame.Stat, C, Object> table = this.table;
        Intrinsics.checkNotNull(table);
        table.setColorTheme(colorTheme);
    }
}

