/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.distributions;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.RandomAccessIterable;
import com.macrofocus.common.collection.SimpleImmutableEntry;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.high_d.distributions.DistributionsController;
import com.macrofocus.high_d.distributions.DistributionsView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.MouseEvent;
import org.mkui.canvas.MouseListener;
import org.mkui.canvas.MouseMotionListener;
import org.mkui.interaction.InteractionMode;
import org.molap.subset.DistributionDimension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u0003*\u0004\b\u0003\u0010\u00042\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0005:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R*\u0010\u0007\u001a\u001e0\bR\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000RX\u0010\u000b\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\n2 \u0010\t\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/macrofocus/high_d/distributions/AbstractDistributionsController;", "Row", "Column", "Value", "Bin", "Lcom/macrofocus/high_d/distributions/DistributionsController;", "()V", "mouseListener", "Lcom/macrofocus/high_d/distributions/AbstractDistributionsController$DefaultMouseListener;", "value", "Lcom/macrofocus/high_d/distributions/DistributionsView;", "view", "getView", "()Lcom/macrofocus/high_d/distributions/DistributionsView;", "setView", "(Lcom/macrofocus/high_d/distributions/DistributionsView;)V", "probe", "", "e", "Lorg/mkui/canvas/MouseEvent;", "continuous", "", "select", "DefaultMouseListener", "highd"})
@StabilityInferred(parameters=0)
public class AbstractDistributionsController<Row, Column, Value, Bin>
implements DistributionsController<Row, Column, Value, Bin> {
    @Nullable
    private DistributionsView<Row, Column, Value, Bin> view;
    @NotNull
    private final DefaultMouseListener mouseListener = new DefaultMouseListener();
    public static final int $stable = 8;

    @Override
    @Nullable
    public DistributionsView<Row, Column, Value, Bin> getView() {
        return this.view;
    }

    @Override
    public void setView(@Nullable DistributionsView<Row, Column, Value, Bin> value) {
        if (this.view != null) {
            DistributionsView<Row, Column, Value, Bin> distributionsView = this.view;
            Intrinsics.checkNotNull(distributionsView);
            distributionsView.removeMouseListener(this.mouseListener);
            DistributionsView<Row, Column, Value, Bin> distributionsView2 = this.view;
            Intrinsics.checkNotNull(distributionsView2);
            distributionsView2.removeMouseMotionListener(this.mouseListener);
        }
        this.view = value;
        if (value != null) {
            value.addMouseListener(this.mouseListener);
            value.addMouseMotionListener(this.mouseListener);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void select(@NotNull MouseEvent e, boolean continuous) {
        boolean allSelected;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DistributionsView<Row, Column, Value, Bin> distributionsView = this.getView();
        Intrinsics.checkNotNull(distributionsView);
        DistributionDimension<Row, Value, Bin> dimension = distributionsView.getClosestDistribution(e.getX(), e.getY());
        DistributionsView<Row, Column, Value, Bin> distributionsView2 = this.getView();
        Intrinsics.checkNotNull(distributionsView2);
        Bin bin = distributionsView2.getClosestBin(e.getX(), e.getY());
        if (bin == null) return;
        DistributionDimension<Row, Value, Bin> distributionDimension = dimension;
        Double d = distributionDimension != null ? Double.valueOf(distributionDimension.getActiveDensity(bin)) : null;
        Intrinsics.checkNotNull((Object)d);
        boolean active = d > 0.0;
        if (!active) return;
        DistributionsView<Row, Column, Value, Bin> distributionsView3 = this.getView();
        Intrinsics.checkNotNull(distributionsView3);
        InteractionMode interactionMode = (InteractionMode)distributionsView3.getInteractionMode().getValue();
        if (e.isAltKeyDown()) {
            InteractionMode interactionMode2 = interactionMode;
            switch (interactionMode2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[interactionMode2.ordinal()]) {
                case 1: {
                    interactionMode = InteractionMode.Filter;
                    break;
                }
                case 2: {
                    interactionMode = InteractionMode.Filter;
                    break;
                }
                case 3: {
                    interactionMode = dimension.getSelection() != null ? InteractionMode.Selection : InteractionMode.Toggle;
                    break;
                }
            }
        }
        if (interactionMode == InteractionMode.Selection) {
            DistributionDimension<Row, Value, Bin> distributionDimension2 = dimension;
            if ((distributionDimension2 != null ? distributionDimension2.getSelection() : null) == null) return;
            if (e.isMenuShortcutKeyDown()) {
                MutableSelection mutableSelection = dimension.getSelection();
                Intrinsics.checkNotNull((Object)mutableSelection);
                Iterable iterable = dimension.getRows(bin);
                Intrinsics.checkNotNull((Object)iterable);
                mutableSelection.setSelectedIterableState(iterable, true);
                return;
            }
            MutableSelection mutableSelection = dimension.getSelection();
            Intrinsics.checkNotNull((Object)mutableSelection);
            Iterable iterable = dimension.getRows(bin);
            Intrinsics.checkNotNull((Object)iterable);
            mutableSelection.setSelectedIterable(iterable);
            return;
        }
        if (!continuous) {
            MutableSelection mutableSelection = dimension.getFilterExact();
            Intrinsics.checkNotNull((Object)mutableSelection);
            if (mutableSelection.isSelected(bin)) {
                MutableSelection mutableSelection2 = dimension.getFilterExact();
                Intrinsics.checkNotNull((Object)mutableSelection2);
                if (mutableSelection2.getSelectedCount() == 1) {
                    dimension.filterAll();
                    return;
                }
            }
        }
        if (interactionMode == InteractionMode.Filter && !e.isMenuShortcutKeyDown() || interactionMode == InteractionMode.Toggle && e.isMenuShortcutKeyDown()) {
            DistributionDimension<Row, Value, Bin> distributionDimension3 = dimension;
            Intrinsics.checkNotNull(distributionDimension3);
            Object[] objectArray = new Object[]{bin};
            distributionDimension3.filterExact(objectArray);
            return;
        }
        DistributionDimension<Row, Value, Bin> distributionDimension4 = dimension;
        Intrinsics.checkNotNull(distributionDimension4);
        MutableSelection mutableSelection = distributionDimension4.getFilterExact();
        Intrinsics.checkNotNull((Object)mutableSelection);
        boolean bl = allSelected = !mutableSelection.isActive();
        if (allSelected) {
            if (interactionMode == InteractionMode.Filter) {
                MutableSelection mutableSelection3 = dimension.getFilterExact();
                Intrinsics.checkNotNull((Object)mutableSelection3);
                RandomAccessIterable randomAccessIterable = dimension.getActiveBins();
                Intrinsics.checkNotNull((Object)randomAccessIterable);
                mutableSelection3.setSelectedIterable((Iterable)randomAccessIterable);
                MutableSelection mutableSelection4 = dimension.getFilterExact();
                Intrinsics.checkNotNull((Object)mutableSelection4);
                mutableSelection4.setSelectedState(bin, false);
                return;
            }
            Object[] objectArray = new Object[]{bin};
            dimension.filterExact(objectArray);
            return;
        }
        MutableSelection mutableSelection5 = dimension.getFilterExact();
        Intrinsics.checkNotNull((Object)mutableSelection5);
        boolean currentlySelected = mutableSelection5.isSelected(bin);
        MutableSelection mutableSelection6 = dimension.getFilterExact();
        Intrinsics.checkNotNull((Object)mutableSelection6);
        mutableSelection6.setSelectedState(bin, !currentlySelected);
    }

    public final void probe(@NotNull MouseEvent e, boolean continuous) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DistributionsView<Row, Column, Value, Bin> distributionsView = this.getView();
        Intrinsics.checkNotNull(distributionsView);
        DistributionDimension<Row, Value, Bin> dimension = distributionsView.getClosestDistribution(e.getX(), e.getY());
        DistributionsView<Row, Column, Value, Bin> distributionsView2 = this.getView();
        Intrinsics.checkNotNull(distributionsView2);
        Bin bin = distributionsView2.getClosestBin(e.getX(), e.getY());
        if (dimension != null && bin != null) {
            DistributionsView<Row, Column, Value, Bin> distributionsView3 = this.getView();
            Intrinsics.checkNotNull(distributionsView3);
            distributionsView3.getProbing().setSelected((Object)new SimpleImmutableEntry(dimension, bin));
        } else {
            DistributionsView<Row, Column, Value, Bin> distributionsView4 = this.getView();
            Intrinsics.checkNotNull(distributionsView4);
            distributionsView4.getProbing().clearSelection();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/macrofocus/high_d/distributions/AbstractDistributionsController$DefaultMouseListener;", "Lorg/mkui/canvas/MouseListener;", "Lorg/mkui/canvas/MouseMotionListener;", "(Lcom/macrofocus/high_d/distributions/AbstractDistributionsController;)V", "mouseClicked", "", "event", "Lorg/mkui/canvas/MouseEvent;", "mouseDragged", "mouseEntered", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "highd"})
    public final class DefaultMouseListener
    implements MouseListener,
    MouseMotionListener {
        public void mouseClicked(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }

        public void mousePressed(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractDistributionsController.this.select(event, false);
        }

        public void mouseReleased(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }

        public void mouseEntered(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractDistributionsController.this.probe(event, true);
        }

        public void mouseExited(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }

        public void mouseDragged(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractDistributionsController.this.probe(event, true);
            AbstractDistributionsController.this.select(event, true);
        }

        public void mouseMoved(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractDistributionsController.this.probe(event, true);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InteractionMode.values().length];
            try {
                nArray[InteractionMode.Selection.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InteractionMode.Toggle.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InteractionMode.Filter.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InteractionMode.DoNothing.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

