/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.command.Future;
import com.macrofocus.common.concurrent.Callable;
import com.macrofocus.common.concurrent.ExecutorService;
import com.macrofocus.common.concurrent.Runtime;
import com.macrofocus.common.crossplatform.CPHelper;
import com.macrofocus.common.filter.Filter;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.timer.CPTimer;
import com.macrofocus.common.timer.CPTimerListener;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesComponent;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesListener;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesView;
import com.macrofocus.high_d.parallelcoordinates.geometry.Geometry;
import com.macrofocus.high_d.parallelcoordinates.layout.ParallelCoordinatesLayout;
import com.macrofocus.order.MutableVisibleOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.CPCanvas;
import org.mkui.canvas.PaletteProvider;
import org.mkui.canvas.Rendering;
import org.mkui.color.MkColorKt;
import org.mkui.geom.Line2D;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.AbstractIDrawing;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.colortheme.ColorTheme;
import org.mkui.graphics.pressure.LogPressure;
import org.mkui.graphics.pressure.Pressure;
import org.mkui.palette.FixedPalette;
import org.mkui.rubberband.RubberBand;
import org.mkui.rubberband.RubberbandDrawing;
import org.mkui.visual.VisualLayer;
import org.mkui.visual.VisualListener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b'\u0018\u0000 7*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u00044567B+\b\u0004\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\u001f\u0010#\u001a\u0004\u0018\u00018\u00002\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\tH$J\u0018\u0010(\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0016J'\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH\u0004\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u00020\tH$J\b\u00102\u001a\u00020!H$J\b\u00103\u001a\u00020!H$R\u001e\u0010\u000b\u001a\u00120\fR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00142\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0014@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00068"}, d2={"Lcom/macrofocus/high_d/parallelcoordinates/AbstractParallelCoordinatesComponent;", "Row", "Column", "Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesComponent;", "view", "Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesView;", "canvas", "Lorg/mkui/canvas/CPCanvas;", "level", "", "(Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesView;Lorg/mkui/canvas/CPCanvas;I)V", "cache", "Lcom/macrofocus/high_d/parallelcoordinates/AbstractParallelCoordinatesComponent$Cache;", "getCanvas", "()Lorg/mkui/canvas/CPCanvas;", "getLevel", "()I", "listener", "Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesListener;", "value", "Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesModel;", "model", "getModel", "()Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesModel;", "setModel", "(Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesModel;)V", "timer", "Lcom/macrofocus/common/timer/CPTimer;", "getTimer", "()Lcom/macrofocus/common/timer/CPTimer;", "getView", "()Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesView;", "clearCache", "", "createOverplots", "getClosestRow", "x", "y", "(II)Ljava/lang/Object;", "getHeight", "getRows", "", "r", "Lorg/mkui/geom/Rectangle2D;", "getShape", "Lorg/mkui/geom/Shape;", "layer", "row", "(ILjava/lang/Object;I)Lorg/mkui/geom/Shape;", "getWidth", "refresh", "repaint", "AbstractVisualLayerIDrawing", "AnnotationIDrawing", "Cache", "Companion", "highd"})
@StabilityInferred(parameters=0)
public abstract class AbstractParallelCoordinatesComponent<Row, Column>
implements ParallelCoordinatesComponent<Row, Column> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ParallelCoordinatesView<Row, Column> view;
    @NotNull
    private final CPCanvas canvas;
    private final int level;
    @Nullable
    private ParallelCoordinatesModel<Row, Column> model;
    @NotNull
    private final Cache cache;
    @NotNull
    private final ParallelCoordinatesListener listener;
    @NotNull
    private final CPTimer timer;
    public static final int $stable = 8;
    private static final double coloredStroke = 1.5;
    private static final double probingStroke = 4.0;
    private static final double selectionStroke = 2.0;
    private static final double axisStroke = 3.0;
    private static final double rubberbandStroke = 1.0;
    private static final boolean MULTITHREADED = true;
    @Nullable
    private static final ExecutorService executor = CPHelper.Companion.getInstance().visualizationExecutorService();
    @NotNull
    private static final Pressure logPressure = new Pressure(){

        public double transform(double v) {
            return v > 0.0 ? v : 0.0;
        }
    };

    protected AbstractParallelCoordinatesComponent(@NotNull ParallelCoordinatesView<Row, Column> view, @NotNull CPCanvas canvas2, int level) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)canvas2, (String)"canvas");
        this.view = view;
        this.canvas = canvas2;
        this.level = level;
        this.cache = new Cache();
        this.listener = new ParallelCoordinatesListener(this){
            final /* synthetic */ AbstractParallelCoordinatesComponent<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void pararallelCoordinatesChanged() {
                this.this$0.repaint();
            }
        };
        this.timer = CPHelper.Companion.getInstance().createTimer("ParallelCoordinates$Resizer", 40, true, new CPTimerListener(){

            public void timerTriggered() {
                if (this.getWidth() > 0 && this.getHeight() > 0) {
                    this.refresh();
                }
            }
        });
    }

    @NotNull
    protected final ParallelCoordinatesView<Row, Column> getView() {
        return this.view;
    }

    @NotNull
    protected final CPCanvas getCanvas() {
        return this.canvas;
    }

    protected final int getLevel() {
        return this.level;
    }

    @Override
    @Nullable
    public ParallelCoordinatesModel<Row, Column> getModel() {
        return this.model;
    }

    @Override
    public void setModel(@Nullable ParallelCoordinatesModel<Row, Column> value) {
        ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel = this.model;
        if (parallelCoordinatesModel != null) {
            parallelCoordinatesModel.removeParallelCoordinateListener(this.listener);
        }
        this.model = value;
        if (value != null) {
            this.createOverplots();
            value.addParallelCoordinatesListener(this.listener);
        }
        this.cache.clear();
        if (value != null) {
            this.timer.restart();
        }
    }

    @NotNull
    protected final CPTimer getTimer() {
        return this.timer;
    }

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract void refresh();

    protected abstract void repaint();

    @Override
    public void createOverplots() {
        if (this.getModel() != null) {
            this.canvas.removeAllLayers();
            this.canvas.addLayer((IDrawing)new AbstractIDrawing(this){
                final /* synthetic */ AbstractParallelCoordinatesComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                    Color background = ((ColorTheme)this.this$0.getView().getColorTheme().getValue()).getBackground();
                    if (background != null) {
                        g.setColor(background);
                        g.fillRectangle2D((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
                    }
                }
            });
            this.canvas.addLayer((IDrawing)new AbstractIDrawing(this){
                final /* synthetic */ AbstractParallelCoordinatesComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                    if (this.this$0.getView().getGeometry().getValue() != Geometry.Steps && ((Boolean)this.this$0.getView().getAxisLine().getValue()).booleanValue()) {
                        g.setColor(((ColorTheme)this.this$0.getView().getColorTheme().getValue()).getForeground());
                        g.setLineWidth(3.0);
                        ParallelCoordinatesLayout<Row, Column> layout = this.this$0.getView().getParallelCoordinatesLayout();
                        for (AxisGroupModel<Row, Column> axisGroup : layout.getAxisGroups(this.this$0.getLevel())) {
                            MutableVisibleOrder mutableVisibleOrder = axisGroup.getAxisOrder();
                            Intrinsics.checkNotNull((Object)mutableVisibleOrder);
                            for (AxisModel axisModel : mutableVisibleOrder) {
                                int x = this.this$0.getView().getAxisX(axisGroup, axisModel) + layout.getAxisPreferredWidth() / 2;
                                Rectangle2D trackBounds = layout.getTrackBounds(axisGroup, axisModel);
                                g.drawLine(x, (int)trackBounds.getY(), x, (int)(trackBounds.getY() + trackBounds.getHeight()));
                            }
                        }
                    }
                }
            });
            Rendering rendering = (Rendering)this.view.getRendering().getValue();
            ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel = this.getModel();
            Intrinsics.checkNotNull(parallelCoordinatesModel);
            VisualLayer visualLayer = parallelCoordinatesModel.getVisual().getFiltered();
            Cache cache = this.cache;
            int n = this.level;
            this.canvas.addDensityLayer(rendering, (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer, cache, n){
                final /* synthetic */ AbstractParallelCoordinatesComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2, 0, $super_call_param$3);
                }

                public boolean isActive() {
                    return (Boolean)this.this$0.getView().getShowFiltered().getValue() != false && super.isActive();
                }

                public void draw(@NotNull IGraphics g, @NotNull Shape shape, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
                    g.drawShape(shape);
                }
            }, (Pressure)new LogPressure(), new PaletteProvider(this){
                final /* synthetic */ AbstractParallelCoordinatesComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public FixedPalette getPalette() {
                    return ((ColorTheme)this.this$0.getView().getColorTheme().getValue()).getGhostedPalette();
                }
            });
            Rendering rendering2 = (Rendering)this.view.getRendering().getValue();
            ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel2 = this.getModel();
            Intrinsics.checkNotNull(parallelCoordinatesModel2);
            visualLayer = parallelCoordinatesModel2.getVisual().getVisible();
            cache = this.cache;
            n = this.level;
            this.canvas.addDensityLayer(rendering2, (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer, cache, n){

                public void draw(@NotNull IGraphics g, @NotNull Shape shape, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
                    g.drawShape(shape);
                }
            }, (Pressure)new LogPressure(), new PaletteProvider(this){
                final /* synthetic */ AbstractParallelCoordinatesComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public FixedPalette getPalette() {
                    return ((ColorTheme)this.this$0.getView().getColorTheme().getValue()).getVisiblePalette();
                }
            });
            Rendering rendering3 = (Rendering)this.view.getRendering().getValue();
            ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel3 = this.getModel();
            Intrinsics.checkNotNull(parallelCoordinatesModel3);
            visualLayer = parallelCoordinatesModel3.getVisual().getColorMapped();
            cache = this.cache;
            n = this.level;
            this.canvas.addAveragingLayer(rendering3, (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer, cache, n){
                final /* synthetic */ AbstractParallelCoordinatesComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2, 0, $super_call_param$3);
                }

                public void draw(@NotNull IGraphics g, @NotNull Shape shape, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
                    ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(parallelCoordinatesModel);
                    Color color = parallelCoordinatesModel.getColorMapping().getColor(row);
                    Intrinsics.checkNotNull((Object)color);
                    g.setColor(color);
                    g.drawShape(shape);
                }
            });
            ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel4 = this.getModel();
            Intrinsics.checkNotNull(parallelCoordinatesModel4);
            visualLayer = parallelCoordinatesModel4.getVisual().getColored();
            cache = this.cache;
            n = this.level;
            this.canvas.addBufferedLayer((IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer, cache, n){
                final /* synthetic */ AbstractParallelCoordinatesComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2, 0, $super_call_param$3);
                }

                public void draw(@NotNull IGraphics g, @NotNull Shape shape, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
                    g.setLineWidth(1.5);
                    ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(parallelCoordinatesModel);
                    Color color = parallelCoordinatesModel.getColoring().getColor(row);
                    Intrinsics.checkNotNull((Object)color);
                    g.setColor(color);
                    g.drawShape(shape);
                }
            });
            Rendering rendering4 = (Rendering)this.view.getRendering().getValue();
            ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel5 = this.getModel();
            Intrinsics.checkNotNull(parallelCoordinatesModel5);
            visualLayer = parallelCoordinatesModel5.getVisual().getMultipleSelected();
            cache = this.cache;
            n = this.level;
            this.canvas.addDensityLayer(rendering4, (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer, cache, n){
                final /* synthetic */ AbstractParallelCoordinatesComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2, 0, $super_call_param$3);
                }

                public void draw(@NotNull IGraphics g, @NotNull Shape shape, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
                    g.setColor(((ColorTheme)this.this$0.getView().getColorTheme().getValue()).getSelection());
                    g.drawShape(shape);
                }
            }, (Pressure)new LogPressure(), new PaletteProvider(this){
                final /* synthetic */ AbstractParallelCoordinatesComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public FixedPalette getPalette() {
                    return ((ColorTheme)this.this$0.getView().getColorTheme().getValue()).getSelectedPalette();
                }
            });
            ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel6 = this.getModel();
            Intrinsics.checkNotNull(parallelCoordinatesModel6);
            visualLayer = parallelCoordinatesModel6.getVisual().getSingleSelected();
            cache = this.cache;
            n = this.level;
            this.canvas.addLayer((IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer, cache, n){
                final /* synthetic */ AbstractParallelCoordinatesComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2, 0, $super_call_param$3);
                }

                public void draw(@NotNull IGraphics g, @NotNull Shape shape, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
                    g.setLineWidth(2.0);
                    g.setColor(((ColorTheme)this.this$0.getView().getColorTheme().getValue()).getSelection());
                    g.drawShape(shape);
                }
            });
            ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel7 = this.getModel();
            Intrinsics.checkNotNull(parallelCoordinatesModel7);
            visualLayer = parallelCoordinatesModel7.getVisual().getProbed();
            cache = this.cache;
            n = this.level;
            this.canvas.addLayer((IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer, cache, n){
                final /* synthetic */ AbstractParallelCoordinatesComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2, 0, $super_call_param$3);
                }

                public void draw(@NotNull IGraphics g, @NotNull Shape shape, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
                    g.setLineWidth(4.0);
                    g.setColor(((ColorTheme)this.this$0.getView().getColorTheme().getValue()).getProbing());
                    g.drawShape(shape);
                    ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(parallelCoordinatesModel);
                    if (parallelCoordinatesModel.getVisual().getSelection().isSelected(row)) {
                        g.setLineWidth(2.0);
                        g.setColor(((ColorTheme)this.this$0.getView().getColorTheme().getValue()).getSelection());
                        g.drawShape(shape);
                    }
                }
            });
            ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel8 = this.getModel();
            Intrinsics.checkNotNull(parallelCoordinatesModel8);
            this.canvas.addLayer((IDrawing)new AnnotationIDrawing((Selection<Object>)((Selection)parallelCoordinatesModel8.getVisual().getAnnotationProbing()), MkColorKt.colorOf((int)255, (int)150, (int)0, (int)200)));
            ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel9 = this.getModel();
            Intrinsics.checkNotNull(parallelCoordinatesModel9);
            this.canvas.addLayer((IDrawing)new AnnotationIDrawing((Selection<Object>)((Selection)parallelCoordinatesModel9.getVisual().getAnnotationSelection()), MkColorKt.colorOf((int)255, (int)100, (int)0, (int)200)));
            this.canvas.addLayer((IDrawing)new AbstractIDrawing(this){
                final /* synthetic */ AbstractParallelCoordinatesComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean isActive() {
                    return (Boolean)this.this$0.getView().getShowProbedValues().getValue();
                }

                public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                    ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(parallelCoordinatesModel);
                    Object row = parallelCoordinatesModel.getProbing().getSelected();
                    if (row != null) {
                        ParallelCoordinatesLayout<Row, Column> layout = this.this$0.getView().getParallelCoordinatesLayout();
                        for (AxisGroupModel<Row, Column> axisGroup : layout.getAxisGroups(this.this$0.getLevel())) {
                            if (axisGroup.isCollapsed()) continue;
                            MutableVisibleOrder mutableVisibleOrder = axisGroup.getAxisOrder();
                            Intrinsics.checkNotNull((Object)mutableVisibleOrder);
                            for (AxisModel axisModel : mutableVisibleOrder) {
                                Rectangle2D trackBounds = layout.getTrackBounds(axisGroup, axisModel);
                                int x = (int)trackBounds.getX() + layout.getAxisPreferredWidth() / 2;
                                Number value = axisModel.getValue(0, row);
                                boolean currentAvailable = value != null;
                                if (!currentAvailable) continue;
                                int height2 = (int)trackBounds.getHeight();
                                Rectangle2D levelBounds = this.this$0.getView().getParallelCoordinatesLayout().getLevelBounds(this.this$0.getLevel());
                                int fullHeight = (int)levelBounds.getHeight();
                                int n = layout.getAxisAfterTrackGap();
                                Number number = value;
                                Intrinsics.checkNotNull((Object)number);
                                double y = Geometry.Companion.getY(fullHeight, height2, n, number.doubleValue(), axisModel);
                                String formattedValue = axisModel.getFormattedValue(row);
                                Rectangle2D bounds = g.getStringBounds(formattedValue);
                                if (((ColorTheme)this.this$0.getView().getColorTheme().getValue()).isDark()) {
                                    g.setColor(MkColorKt.colorOf((int)0, (int)0, (int)0, (int)191));
                                } else {
                                    g.setColor(MkColorKt.colorOf((int)0, (int)0, (int)0, (int)191));
                                }
                                y = y > (double)(fullHeight / 2) ? (y -= (double)16 + bounds.getHeight() / (double)2) : (y += (double)16 + bounds.getHeight() / (double)2);
                                g.fillRectangle2D((Rectangle2D)new Rectangle2D.Double((double)x - 2.0, y - bounds.getHeight() / (double)2 - (double)2, bounds.getWidth() + (double)4, bounds.getHeight() + (double)4));
                                g.setTextBaseline(IGraphics.TextBaseline.Middle);
                                g.setColor(((ColorTheme)this.this$0.getView().getColorTheme().getValue()).getProbing());
                                g.drawString(formattedValue, (float)x, (float)y);
                            }
                        }
                    }
                }
            });
            visualLayer = this.view.getRubberBand();
            this.canvas.addLayer((IDrawing)new RubberbandDrawing(this, (RubberBand)visualLayer){
                final /* synthetic */ AbstractParallelCoordinatesComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                @NotNull
                protected Property<ColorTheme> getColorTheme() {
                    return (Property)this.this$0.getView().getColorTheme();
                }
            });
        }
    }

    @Nullable
    protected final Shape getShape(int layer, Row row, int level) {
        return this.cache.getShape(layer, row, level);
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    @Nullable
    public Row getClosestRow(int x, int y) {
        double bestdistance = Double.MAX_VALUE;
        Row bestrow = null;
        if (this.getModel() != null) {
            ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel = this.getModel();
            Intrinsics.checkNotNull(parallelCoordinatesModel);
            int n = parallelCoordinatesModel.getObjectCount();
            for (int row = 0; row < n; ++row) {
                Shape line;
                ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel2 = this.getModel();
                Intrinsics.checkNotNull(parallelCoordinatesModel2);
                Row rowObject = parallelCoordinatesModel2.getObject(row);
                ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel3 = this.getModel();
                Intrinsics.checkNotNull(parallelCoordinatesModel3);
                Filter filter = (Filter)parallelCoordinatesModel3.getFilter();
                if (filter.isFiltered(rowObject) || (line = this.getShape(0, rowObject, this.level)) == null) continue;
                PathIterator pi = Shape.DefaultImpls.getPathIterator$default((Shape)line, null, (int)1, null);
                float[] data = new float[6];
                int previousX = 0;
                int previousY = 0;
                double lastdistance = Double.MAX_VALUE;
                boolean willNotImprove = false;
                while (!pi.isDone()) {
                    int segType = pi.currentSegment(data);
                    switch (segType) {
                        case 0: {
                            previousX = (int)data[0];
                            previousY = (int)data[1];
                            double distance = Companion.distance(previousX, previousY, x, y);
                            if (distance < bestdistance) {
                                bestdistance = distance;
                                bestrow = rowObject;
                            }
                            if (distance > lastdistance) {
                                // empty if block
                            }
                            lastdistance = distance;
                            break;
                        }
                        case 1: {
                            int currentX = (int)data[0];
                            int currentY = (int)data[1];
                            double distance = Line2D.Companion.ptSegDist((double)previousX, (double)previousY, (double)currentX, (double)currentY, (double)x, (double)y);
                            if (distance < bestdistance) {
                                bestdistance = distance;
                                bestrow = rowObject;
                            }
                            if (distance > lastdistance) {
                                // empty if block
                            }
                            lastdistance = distance;
                            previousX = currentX;
                            previousY = currentY;
                            break;
                        }
                        default: {
                            throw new Error("Segmented type unsupported");
                        }
                    }
                    pi.next();
                }
            }
        }
        return bestrow;
    }

    @Override
    @Nullable
    public List<Row> getRows(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        if (this.getModel() != null) {
            List list = new ArrayList();
            ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel = this.getModel();
            Intrinsics.checkNotNull(parallelCoordinatesModel);
            int n = parallelCoordinatesModel.getObjectCount();
            block4: for (int row = 0; row < n; ++row) {
                Shape line;
                ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel2 = this.getModel();
                Intrinsics.checkNotNull(parallelCoordinatesModel2);
                Row rowObject = parallelCoordinatesModel2.getObject(row);
                ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel3 = this.getModel();
                Intrinsics.checkNotNull(parallelCoordinatesModel3);
                Filter filter = (Filter)parallelCoordinatesModel3.getFilter();
                if (filter.isFiltered(rowObject) || (line = this.getShape(0, rowObject, this.level)) == null) continue;
                PathIterator pi = Shape.DefaultImpls.getPathIterator$default((Shape)line, null, (int)1, null);
                float[] data = new float[6];
                int previousX = 0;
                int previousY = 0;
                while (!pi.isDone()) {
                    int segType = pi.currentSegment(data);
                    switch (segType) {
                        case 0: {
                            previousX = (int)data[0];
                            previousY = (int)data[1];
                            break;
                        }
                        case 1: {
                            int currentX = (int)data[0];
                            int currentY = (int)data[1];
                            if (r.intersectsLine((double)previousX, (double)previousY, (double)currentX, (double)currentY)) {
                                list.add(rowObject);
                                continue block4;
                            }
                            previousX = currentX;
                            previousY = currentY;
                            break;
                        }
                        default: {
                            new Error("Segmented type unsupported");
                        }
                    }
                    pi.next();
                }
            }
            return list;
        }
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00a6\u0004\u0018\u00002\u00020\u0001B=\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0016\u0010\u0004\u001a\u00120\u0005R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J%\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u001e\u0010\u0004\u001a\u00120\u0005R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/macrofocus/high_d/parallelcoordinates/AbstractParallelCoordinatesComponent$AbstractVisualLayerIDrawing;", "Lorg/mkui/graphics/AbstractIDrawing;", "visualLayer", "Lorg/mkui/visual/VisualLayer;", "cache", "Lcom/macrofocus/high_d/parallelcoordinates/AbstractParallelCoordinatesComponent$Cache;", "Lcom/macrofocus/high_d/parallelcoordinates/AbstractParallelCoordinatesComponent;", "layer", "", "level", "(Lcom/macrofocus/high_d/parallelcoordinates/AbstractParallelCoordinatesComponent;Lorg/mkui/visual/VisualLayer;Lcom/macrofocus/high_d/parallelcoordinates/AbstractParallelCoordinatesComponent$Cache;II)V", "isActive", "", "()Z", "draw", "", "g", "Lorg/mkui/graphics/IGraphics;", "point", "Lorg/mkui/geom/Point2D;", "width", "", "height", "clipBounds", "Lorg/mkui/geom/Rectangle;", "shape", "Lorg/mkui/geom/Shape;", "row", "(Lorg/mkui/graphics/IGraphics;Lorg/mkui/geom/Shape;Ljava/lang/Object;)V", "init", "highd"})
    public abstract class AbstractVisualLayerIDrawing
    extends AbstractIDrawing {
        @NotNull
        private final VisualLayer<Row> visualLayer;
        @NotNull
        private final Cache cache;
        private final int layer;
        private final int level;

        protected AbstractVisualLayerIDrawing(@NotNull VisualLayer<Row> visualLayer, Cache cache, int layer, int level) {
            Intrinsics.checkNotNullParameter(visualLayer, (String)"visualLayer");
            Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
            this.visualLayer = visualLayer;
            this.cache = cache;
            this.layer = layer;
            this.level = level;
            visualLayer.addVisualListener(new VisualListener(){

                public void visualChanged() {
                    this.notifyIDrawingChanged();
                }
            });
        }

        public boolean isActive() {
            return this.visualLayer.isActive();
        }

        public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
            block9: {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                if (this.visualLayer.getObjectCount() <= 0) break block9;
                this.init(g);
                if (!g.isThreadSafe()) {
                    for (Object row : this.visualLayer) {
                        Shape geometry = this.cache.getShape(this.layer, row, this.level);
                        if (geometry == null) continue;
                        this.draw(g, geometry, row);
                    }
                } else {
                    int nTasks = Math.min(Runtime.Companion.getRuntime().availableProcessors(), this.visualLayer.getObjectCount());
                    int nRowsPerTask = this.visualLayer.getObjectCount() / nTasks;
                    List todo = new ArrayList(nTasks);
                    for (int nTask = 0; nTask < nTasks; ++nTask) {
                        int fromRow = nTask * nRowsPerTask;
                        int toRow = nTask < nTasks - 1 ? fromRow + nRowsPerTask : this.visualLayer.getObjectCount();
                        todo.add(new Callable<Object>(this, fromRow, toRow, g){
                            final /* synthetic */ AbstractVisualLayerIDrawing this$0;
                            final /* synthetic */ int $fromRow;
                            final /* synthetic */ int $toRow;
                            final /* synthetic */ IGraphics $g;
                            {
                                this.this$0 = $receiver;
                                this.$fromRow = $fromRow;
                                this.$toRow = $toRow;
                                this.$g = $g;
                            }

                            @Nullable
                            public Object call() throws Exception {
                                for (T row : AbstractVisualLayerIDrawing.access$getVisualLayer$p(this.this$0).iterable(this.$fromRow, this.$toRow - 1)) {
                                    Shape geometry = AbstractVisualLayerIDrawing.access$getCache$p(this.this$0).getShape(AbstractVisualLayerIDrawing.access$getLayer$p(this.this$0), row, AbstractVisualLayerIDrawing.access$getLevel$p(this.this$0));
                                    if (geometry == null) continue;
                                    this.this$0.draw(this.$g, geometry, row);
                                }
                                return null;
                            }
                        });
                    }
                    try {
                        ExecutorService executorService = executor;
                        Intrinsics.checkNotNull((Object)executorService);
                        List answers = executorService.invokeAll((Collection)todo);
                        for (Future answer : answers) {
                            try {
                                answer.get();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public final void init(@NotNull IGraphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        }

        public abstract void draw(@NotNull IGraphics var1, @NotNull Shape var2, Row var3);

        public static final /* synthetic */ VisualLayer access$getVisualLayer$p(AbstractVisualLayerIDrawing $this) {
            return $this.visualLayer;
        }

        public static final /* synthetic */ Cache access$getCache$p(AbstractVisualLayerIDrawing $this) {
            return $this.cache;
        }

        public static final /* synthetic */ int access$getLayer$p(AbstractVisualLayerIDrawing $this) {
            return $this.layer;
        }

        public static final /* synthetic */ int access$getLevel$p(AbstractVisualLayerIDrawing $this) {
            return $this.level;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/macrofocus/high_d/parallelcoordinates/AbstractParallelCoordinatesComponent$AnnotationIDrawing;", "Lorg/mkui/graphics/AbstractIDrawing;", "selection", "Lcom/macrofocus/common/selection/Selection;", "", "color", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "(Lcom/macrofocus/high_d/parallelcoordinates/AbstractParallelCoordinatesComponent;Lcom/macrofocus/common/selection/Selection;Ljavafx/scene/paint/Color;)V", "isActive", "", "()Z", "selectionListener", "Lcom/macrofocus/common/selection/SelectionListener;", "draw", "", "g", "Lorg/mkui/graphics/IGraphics;", "point", "Lorg/mkui/geom/Point2D;", "width", "", "height", "clipBounds", "Lorg/mkui/geom/Rectangle;", "highd"})
    private final class AnnotationIDrawing
    extends AbstractIDrawing {
        @NotNull
        private final Selection<Object> selection;
        @NotNull
        private final Color color;
        @NotNull
        private final SelectionListener<Object> selectionListener;

        public AnnotationIDrawing(@NotNull Selection<Object> selection, Color color) {
            Intrinsics.checkNotNullParameter(selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.selection = selection;
            this.selectionListener = (SelectionListener)new SelectionListener<Object>(this){
                final /* synthetic */ AnnotationIDrawing this$0;
                {
                    this.this$0 = $receiver;
                }

                public void selectionChanged(@NotNull SelectionEvent<Object> event) {
                    Intrinsics.checkNotNullParameter(event, (String)"event");
                    AnnotationIDrawing.access$notifyIDrawingChanged(this.this$0);
                }
            };
            this.color = color;
            this.selection.addWeakSelectionListener(this.selectionListener);
        }

        public boolean isActive() {
            return this.selection.isActive();
        }

        public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
            for (Object row : this.selection) {
                Shape shape;
                g.setColor(this.color);
                Rectangle2D levelBounds = AbstractParallelCoordinatesComponent.this.getView().getParallelCoordinatesLayout().getLevelBounds(AbstractParallelCoordinatesComponent.this.getLevel());
                int fullHeight = (int)levelBounds.getHeight();
                Shape shape2 = shape = AbstractParallelCoordinatesComponent.this.cache.createShape(fullHeight, 1, row, AbstractParallelCoordinatesComponent.this.getLevel());
                Intrinsics.checkNotNull((Object)shape2);
                g.drawShape(shape2);
            }
        }

        public static final /* synthetic */ void access$notifyIDrawingChanged(AnnotationIDrawing $this) {
            $this.notifyIDrawingChanged();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J-\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0010R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/macrofocus/high_d/parallelcoordinates/AbstractParallelCoordinatesComponent$Cache;", "", "(Lcom/macrofocus/high_d/parallelcoordinates/AbstractParallelCoordinatesComponent;)V", "shapes", "", "Lorg/mkui/geom/Shape;", "clear", "", "createShape", "fullHeight", "", "layer", "row", "level", "(IILjava/lang/Object;I)Lorg/mkui/geom/Shape;", "getShape", "(ILjava/lang/Object;I)Lorg/mkui/geom/Shape;", "highd"})
    public final class Cache {
        @NotNull
        private final Map<Row, Shape> shapes = new HashMap();

        @Nullable
        public final Shape getShape(int layer, Row row, int level) {
            if (this.shapes.containsKey(row)) {
                return this.shapes.get(row);
            }
            Shape shape = null;
            Rectangle2D levelBounds = AbstractParallelCoordinatesComponent.this.getView().getParallelCoordinatesLayout().getLevelBounds(level);
            int fullHeight = (int)levelBounds.getHeight();
            Shape shape2 = shape = this.createShape(fullHeight, layer, row, level);
            Intrinsics.checkNotNull((Object)shape2);
            this.shapes.put(row, shape2);
            return shape;
        }

        @Nullable
        public final Shape createShape(int fullHeight, int layer, Row row, int level) {
            Object object = AbstractParallelCoordinatesComponent.this.getView().getGeometry().getValue();
            Intrinsics.checkNotNull((Object)object);
            return ((Geometry)((Object)object)).createGeometry(AbstractParallelCoordinatesComponent.this.getView(), AbstractParallelCoordinatesComponent.this.getModel(), fullHeight, layer, row, level);
        }

        public final void clear() {
            this.shapes.clear();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/macrofocus/high_d/parallelcoordinates/AbstractParallelCoordinatesComponent$Companion;", "", "()V", "MULTITHREADED", "", "axisStroke", "", "coloredStroke", "executor", "Lcom/macrofocus/common/concurrent/ExecutorService;", "logPressure", "Lorg/mkui/graphics/pressure/Pressure;", "probingStroke", "rubberbandStroke", "selectionStroke", "distance", "x1", "y1", "x2", "y2", "highd"})
    public static final class Companion {
        private Companion() {
        }

        public final double distance(double x1, double y1, double x2, double y2) {
            double x12 = x1;
            double y12 = y1;
            return Math.sqrt((x12 -= x2) * x12 + (y12 -= y2) * y12);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

