/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplot;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.command.Future;
import com.macrofocus.common.concurrent.Callable;
import com.macrofocus.common.concurrent.ExecutorService;
import com.macrofocus.common.concurrent.Runtime;
import com.macrofocus.common.crossplatform.CPHelper;
import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.BoundedIntervalEvent;
import com.macrofocus.common.interval.BoundedIntervalListener;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.properties.EnumProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.common.timer.CPTimer;
import com.macrofocus.common.timer.CPTimerListener;
import com.macrofocus.common.transform.RangesScreenTransformCoordinator;
import com.macrofocus.common.transform.ScreenTransformEvent;
import com.macrofocus.common.transform.ScreenTransformListener;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.scatterplot.AbstractScatterPlotView;
import com.macrofocus.high_d.scatterplot.ScatterPlotListener;
import com.macrofocus.high_d.scatterplot.ScatterPlotModel;
import com.macrofocus.high_d.scatterplot.ScatterPlotView;
import com.macrofocus.plot.guide.Guide;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.paint.Color;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.CPCanvas;
import org.mkui.canvas.CanvasListener;
import org.mkui.canvas.KeyListener;
import org.mkui.canvas.MouseListener;
import org.mkui.canvas.MouseMotionListener;
import org.mkui.canvas.MouseWheelListener;
import org.mkui.canvas.PaletteProvider;
import org.mkui.canvas.Rendering;
import org.mkui.color.MkColorFactory;
import org.mkui.color.MkColorKt;
import org.mkui.geom.Point;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.graphics.AbstractIDrawing;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.colortheme.ColorTheme;
import org.mkui.graphics.colortheme.LightColorTheme;
import org.mkui.graphics.pressure.LinearPressure;
import org.mkui.graphics.pressure.Pressure;
import org.mkui.palette.FixedPalette;
import org.mkui.rubberband.RubberBand;
import org.mkui.rubberband.RubberbandDrawing;
import org.mkui.rubberband.ScreenTransformRubberBand;
import org.mkui.transform.MutableTwoDScreenTransform;
import org.mkui.transform.SimpleTwoDScreenTransform;
import org.mkui.transform.TwoDScreenTransform;
import org.mkui.visual.VisualLayer;
import org.mkui.visual.VisualListener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b#\b'\u0018\u0000 \u008b\u0001*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0006\u0089\u0001\u008a\u0001\u008b\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010>\u001a\u00020?2\u0006\u0010\u0012\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020?2\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020?2\u0006\u0010B\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020?2\u0006\u0010B\u001a\u00020GH\u0016J\u0006\u0010H\u001a\u00020?J\u000e\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00110JH\u0016J\u001f\u0010K\u001a\u0004\u0018\u00018\u00002\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020MH\u0016\u00a2\u0006\u0002\u0010OJ\u000e\u0010P\u001a\b\u0012\u0004\u0012\u00020Q0JH\u0016J\u000e\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00110JH\u0016J\u0010\u0010S\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010T0JH\u0016J\b\u0010U\u001a\u00020MH$J\u0010\u0010V\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010W0JH\u0016J\u001d\u0010V\u001a\u00020M2\u0006\u0010X\u001a\u00020M2\u0006\u0010Y\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010ZJ\u001d\u0010[\u001a\u0004\u0018\u00010\\2\u0006\u0010X\u001a\u00020M2\u0006\u0010Y\u001a\u00028\u0000\u00a2\u0006\u0002\u0010]J\u001d\u0010^\u001a\u0004\u0018\u00010\\2\u0006\u0010X\u001a\u00020M2\u0006\u0010Y\u001a\u00028\u0000\u00a2\u0006\u0002\u0010]J\u000e\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00110JH\u0016J\u000e\u0010`\u001a\b\u0012\u0004\u0012\u00020a0JH\u0016J\u0016\u0010b\u001a\b\u0012\u0004\u0012\u00028\u00000c2\u0006\u0010d\u001a\u00020eH\u0016J\b\u0010f\u001a\u00020)H\u0016J\u0016\u0010g\u001a\u0010\u0012\f\u0012\n\u0018\u00010hj\u0004\u0018\u0001`i0JH\u0016J\u000e\u0010j\u001a\b\u0012\u0004\u0012\u00020\u00110JH\u0016J\u000e\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00110JH\u0016J\b\u0010l\u001a\u00020MH$J\u001d\u0010m\u001a\u0004\u0018\u00010M2\u0006\u0010X\u001a\u00020M2\u0006\u0010Y\u001a\u00028\u0000\u00a2\u0006\u0002\u0010nJ\b\u0010o\u001a\u000209H\u0016J\u001d\u0010p\u001a\u0004\u0018\u00010M2\u0006\u0010X\u001a\u00020M2\u0006\u0010Y\u001a\u00028\u0000\u00a2\u0006\u0002\u0010nJ\b\u0010q\u001a\u000209H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010r\u001a\u00020?H\u0004J\b\u0010s\u001a\u00020?H$J\b\u0010t\u001a\u00020?H$J\u0006\u0010u\u001a\u00020?J\u0006\u0010v\u001a\u00020?J\b\u0010w\u001a\u00020?H$J\u0018\u0010x\u001a\u00020?2\u000e\u0010y\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010JH\u0016J\u0018\u0010z\u001a\u00020?2\u000e\u0010{\u001a\n\u0012\u0004\u0012\u00020Q\u0018\u00010JH\u0016J\u0018\u0010|\u001a\u00020?2\u000e\u0010}\u001a\n\u0012\u0004\u0012\u00020a\u0018\u00010JH\u0016J\u0010\u0010~\u001a\u00020?2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0019\u0010\u007f\u001a\u00020?2\u000f\u0010\u0080\u0001\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010JH\u0016J\t\u0010\u0081\u0001\u001a\u00020?H$J\t\u0010\u0082\u0001\u001a\u00020?H\u0004J6\u0010\u0083\u0001\u001a\u00020?2\u0007\u0010\u0084\u0001\u001a\u00020\u00112\u0007\u0010\u0085\u0001\u001a\u00020W2\u0007\u0010\u0086\u0001\u001a\u00020W2\u0007\u0010\u0087\u0001\u001a\u00020W2\u0007\u0010\u0088\u0001\u001a\u00020WH\u0016R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00152\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0015@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020/X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001c\u00102\u001a\u0004\u0018\u000103X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010:\u001a\u0004\u0018\u000103X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00105\"\u0004\b<\u00107R\u000e\u0010=\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008c\u0001"}, d2={"Lcom/macrofocus/high_d/scatterplot/AbstractScatterPlotView;", "Row", "Column", "Lcom/macrofocus/high_d/scatterplot/ScatterPlotView;", "()V", "axisSelectionListener", "Lcom/macrofocus/common/selection/SingleSelectionListener;", "Lcom/macrofocus/high_d/axis/AxisModel;", "canvas", "Lorg/mkui/canvas/CPCanvas;", "getCanvas", "()Lorg/mkui/canvas/CPCanvas;", "canvas$delegate", "Lkotlin/Lazy;", "intervalListener", "Lcom/macrofocus/common/interval/BoundedIntervalListener;", "isSelectionMode", "", "listener", "Lcom/macrofocus/high_d/scatterplot/ScatterPlotListener;", "value", "Lcom/macrofocus/high_d/scatterplot/ScatterPlotModel;", "model", "getModel", "()Lcom/macrofocus/high_d/scatterplot/ScatterPlotModel;", "setModel", "(Lcom/macrofocus/high_d/scatterplot/ScatterPlotModel;)V", "properties", "Lcom/macrofocus/common/properties/MutableProperties;", "Lcom/macrofocus/high_d/scatterplot/ScatterPlotView$PropertyType;", "getProperties", "()Lcom/macrofocus/common/properties/MutableProperties;", "propertiesListener", "Lcom/macrofocus/common/properties/PropertiesListener;", "rangesScreenTransformCoordinator", "Lcom/macrofocus/common/transform/RangesScreenTransformCoordinator;", "getRangesScreenTransformCoordinator", "()Lcom/macrofocus/common/transform/RangesScreenTransformCoordinator;", "setRangesScreenTransformCoordinator", "(Lcom/macrofocus/common/transform/RangesScreenTransformCoordinator;)V", "rubberBand", "Lorg/mkui/rubberband/RubberBand;", "screenTransform", "Lorg/mkui/transform/MutableTwoDScreenTransform;", "getScreenTransform", "()Lorg/mkui/transform/MutableTwoDScreenTransform;", "timer", "Lcom/macrofocus/common/timer/CPTimer;", "getTimer", "()Lcom/macrofocus/common/timer/CPTimer;", "xGuide", "Lcom/macrofocus/plot/guide/Guide;", "getXGuide", "()Lcom/macrofocus/plot/guide/Guide;", "setXGuide", "(Lcom/macrofocus/plot/guide/Guide;)V", "xRangeModel", "Lcom/macrofocus/common/interval/MutableBoundedInterval;", "yGuide", "getYGuide", "setYGuide", "yRangeModel", "addKeyListener", "", "Lorg/mkui/canvas/KeyListener;", "addMouseListener", "l", "Lorg/mkui/canvas/MouseListener;", "addMouseMotionListener", "Lorg/mkui/canvas/MouseMotionListener;", "addMouseWheelListener", "Lorg/mkui/canvas/MouseWheelListener;", "createOverplots", "getAntialiasing", "Lcom/macrofocus/common/properties/MutableProperty;", "getClosestRow", "x", "", "y", "(II)Ljava/lang/Object;", "getColorTheme", "Lorg/mkui/graphics/colortheme/ColorTheme;", "getDisplayLabels", "getGridThickness", "", "getHeight", "getMarkerSize", "", "layer", "row", "(ILjava/lang/Object;)I", "getPoint", "Lorg/mkui/geom/Point;", "(ILjava/lang/Object;)Lorg/mkui/geom/Point;", "getPoint2", "getRegression", "getRendering", "Lorg/mkui/canvas/Rendering;", "getRows", "", "rect", "Lorg/mkui/geom/Rectangle2D;", "getRubberBand", "getShowColor", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "getShowFiltered", "getShowGrid", "getWidth", "getXLine", "(ILjava/lang/Object;)Ljava/lang/Integer;", "getXRangeModel", "getYLine", "getYRangeModel", "populateOverplots", "refresh", "repaint", "resetXAxis", "resetYAxis", "scheduleUpdate", "setAntialiasing", "antialiasing", "setColorTheme", "colorTheme", "setRendering", "rendering", "setSelectionMode", "setShowFiltered", "showFiltered", "updateAxisType", "updateIntervals", "zoom", "animate", "x1", "x2", "y1", "y2", "AbstractVisualLayerIDrawing", "AnnotationIDrawing", "Companion", "highd"})
@StabilityInferred(parameters=0)
public abstract class AbstractScatterPlotView<Row, Column>
implements ScatterPlotView<Row, Column> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ScatterPlotModel<Row, Column> model;
    @NotNull
    private final MutableProperties<ScatterPlotView.PropertyType> properties = (MutableProperties)new EnumProperties((Enum[])ScatterPlotView.PropertyType.values());
    @NotNull
    private final Lazy canvas$delegate = LazyKt.lazy((Function0)canvas.2.INSTANCE);
    @NotNull
    private final CPTimer timer;
    @NotNull
    private final MutableBoundedInterval xRangeModel;
    @NotNull
    private final MutableBoundedInterval yRangeModel;
    @NotNull
    private final MutableTwoDScreenTransform screenTransform;
    @Nullable
    private RangesScreenTransformCoordinator rangesScreenTransformCoordinator;
    @Nullable
    private Guide xGuide;
    @Nullable
    private Guide yGuide;
    private boolean isSelectionMode = true;
    @NotNull
    private final RubberBand rubberBand;
    @NotNull
    private final PropertiesListener<ScatterPlotView.PropertyType> propertiesListener = (PropertiesListener)new PropertiesListener<ScatterPlotView.PropertyType>(this){
        final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
        {
            this.this$0 = $receiver;
        }

        public void propertyChanged(@NotNull ScatterPlotView.PropertyType name, @NotNull PropertyEvent<Object> event) {
            Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
            Intrinsics.checkNotNullParameter(event, (String)"event");
            this.this$0.createOverplots();
            this.this$0.scheduleUpdate();
        }
    };
    @NotNull
    private final ScatterPlotListener listener = new ScatterPlotListener(this){
        final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
        {
            this.this$0 = $receiver;
        }

        public void scatterPlotChanged() {
            this.this$0.resetXAxis();
            this.this$0.resetYAxis();
            this.this$0.scheduleUpdate();
        }
    };
    @NotNull
    private final BoundedIntervalListener intervalListener = new BoundedIntervalListener(this){
        final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
        {
            this.this$0 = $receiver;
        }

        public void boundedIntervalChanged(@NotNull BoundedIntervalEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.this$0.updateIntervals();
        }
    };
    @NotNull
    private final SingleSelectionListener<AxisModel<Row, Column>> axisSelectionListener = new SingleSelectionListener<AxisModel<Row, Column>>(this){
        final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
        {
            this.this$0 = $receiver;
        }

        public void selectionChanged(@NotNull SingleSelectionEvent<AxisModel<Row, Column>> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            if (event.getPreviousSelection() != null) {
                Object object = event.getPreviousSelection();
                Intrinsics.checkNotNull((Object)object);
                if (((AxisModel)object).getInterval() != null) {
                    Object object2 = event.getPreviousSelection();
                    Intrinsics.checkNotNull((Object)object2);
                    ((AxisModel)object2).getInterval().removeBoundedIntervalListener(AbstractScatterPlotView.access$getIntervalListener$p(this.this$0));
                }
            }
            if (event.getCurrentSelection() != null) {
                Object object = event.getCurrentSelection();
                Intrinsics.checkNotNull((Object)object);
                if (((AxisModel)object).getInterval() != null) {
                    Object object3 = event.getCurrentSelection();
                    Intrinsics.checkNotNull((Object)object3);
                    ((AxisModel)object3).getInterval().addBoundedIntervalListener(AbstractScatterPlotView.access$getIntervalListener$p(this.this$0));
                }
            }
            this.this$0.updateAxisType();
            this.this$0.updateIntervals();
        }
    };
    public static final int $stable = 8;
    private static final boolean MULTITHREADED = true;
    @Nullable
    private static final ExecutorService executor = CPHelper.Companion.getInstance().visualizationExecutorService();

    public AbstractScatterPlotView() {
        this.getProperties().createProperty((Object)ScatterPlotView.PropertyType.ShowFiltered, (Object)true);
        this.getProperties().createProperty((Object)ScatterPlotView.PropertyType.ShowGrid, (Object)true);
        this.getProperties().createProperty((Object)ScatterPlotView.PropertyType.Antialiasing, (Object)true);
        this.getProperties().createProperty((Object)ScatterPlotView.PropertyType.Rendering, (Object)Rendering.AlphaBlended);
        this.getProperties().createProperty((Object)ScatterPlotView.PropertyType.GridThickness, (Object)Float.valueOf(0.1f));
        this.getProperties().createProperty((Object)ScatterPlotView.PropertyType.ShowColor, (Object)MkColorKt.colorOf((int)128, (int)128, (int)128));
        this.getProperties().createProperty((Object)ScatterPlotView.PropertyType.Regression, (Object)true);
        this.getProperties().createProperty((Object)ScatterPlotView.PropertyType.MarkerSize, (Object)8.0);
        this.getProperties().createProperty((Object)ScatterPlotView.PropertyType.ColorTheme, (Object)new LightColorTheme());
        this.getProperties().createProperty((Object)ScatterPlotView.PropertyType.DisplayLabels, (Object)true);
        this.getProperties().addPropertiesListener(this.propertiesListener);
        this.timer = CPHelper.Companion.getInstance().createTimer("ScatterPlotResizer", 40, true, new CPTimerListener(){

            public void timerTriggered() {
                if (this.getWidth() > 0 && this.getHeight() > 0) {
                    this.refresh();
                }
            }
        });
        this.xRangeModel = (MutableBoundedInterval)new SimpleBoundedInterval(0.0, 1.0, 0.0, 1.0);
        this.yRangeModel = (MutableBoundedInterval)new SimpleBoundedInterval(0.0, 1.0, 0.0, 1.0);
        this.screenTransform = (MutableTwoDScreenTransform)new SimpleTwoDScreenTransform((BoundedInterval)this.xRangeModel, (BoundedInterval)this.yRangeModel, 0, 0, 0.0, 28, null);
        this.getScreenTransform().getX().setScreenMargins(8);
        this.getScreenTransform().getY().setScreenMargins(8);
        this.rubberBand = (RubberBand)new ScreenTransformRubberBand((TwoDScreenTransform)this.getScreenTransform());
        this.getCanvas().addCanvasListener(new CanvasListener(){

            public void sizeChange(int width, int height) {
                this.getScreenTransform().setScreenSize(width, height);
            }
        });
        this.getScreenTransform().addScreenTransformListener(new ScreenTransformListener(){

            public void transformChanged(@NotNull ScreenTransformEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.getTimer().restart();
            }
        });
    }

    @Override
    @Nullable
    public ScatterPlotModel<Row, Column> getModel() {
        return this.model;
    }

    @Override
    public void setModel(@Nullable ScatterPlotModel<Row, Column> value) {
        if (this.model != null) {
            ScatterPlotModel<Row, Column> scatterPlotModel = this.model;
            Intrinsics.checkNotNull(scatterPlotModel);
            scatterPlotModel.removeScatterPlotListener(this.listener);
            ScatterPlotModel<Row, Column> scatterPlotModel2 = this.model;
            Intrinsics.checkNotNull(scatterPlotModel2);
            if (scatterPlotModel2.getX() != null) {
                ScatterPlotModel<Row, Column> scatterPlotModel3 = this.model;
                Intrinsics.checkNotNull(scatterPlotModel3);
                scatterPlotModel3.getX().removeSingleSelectionListener(this.axisSelectionListener);
            }
            ScatterPlotModel<Row, Column> scatterPlotModel4 = this.model;
            Intrinsics.checkNotNull(scatterPlotModel4);
            if (scatterPlotModel4.getY() != null) {
                ScatterPlotModel<Row, Column> scatterPlotModel5 = this.model;
                Intrinsics.checkNotNull(scatterPlotModel5);
                scatterPlotModel5.getY().removeSingleSelectionListener(this.axisSelectionListener);
            }
        }
        this.model = value;
        this.createOverplots();
        if (this.model != null) {
            ScatterPlotModel<Row, Column> scatterPlotModel = this.model;
            Intrinsics.checkNotNull(scatterPlotModel);
            scatterPlotModel.addScatterPlotListener(this.listener);
            ScatterPlotModel<Row, Column> scatterPlotModel6 = this.model;
            Intrinsics.checkNotNull(scatterPlotModel6);
            if (scatterPlotModel6.getX() != null) {
                ScatterPlotModel<Row, Column> scatterPlotModel7 = this.model;
                Intrinsics.checkNotNull(scatterPlotModel7);
                MutableSingleSelection<AxisModel<Row, Column>> x = scatterPlotModel7.getX();
                x.addSingleSelectionListener(this.axisSelectionListener);
                if (x.isActive()) {
                    Object object = x.getSelected();
                    Intrinsics.checkNotNull((Object)object);
                    if (((AxisModel)object).getInterval() != null) {
                        Object object2 = x.getSelected();
                        Intrinsics.checkNotNull((Object)object2);
                        ((AxisModel)object2).getInterval().addBoundedIntervalListener(this.intervalListener);
                    }
                }
            }
            ScatterPlotModel<Row, Column> scatterPlotModel8 = this.model;
            Intrinsics.checkNotNull(scatterPlotModel8);
            if (scatterPlotModel8.getY() != null) {
                ScatterPlotModel<Row, Column> scatterPlotModel9 = this.model;
                Intrinsics.checkNotNull(scatterPlotModel9);
                MutableSingleSelection<AxisModel<Row, Column>> y = scatterPlotModel9.getY();
                y.addSingleSelectionListener(this.axisSelectionListener);
                if (y.isActive()) {
                    Object object = y.getSelected();
                    Intrinsics.checkNotNull((Object)object);
                    if (((AxisModel)object).getInterval() != null) {
                        Object object3 = y.getSelected();
                        Intrinsics.checkNotNull((Object)object3);
                        ((AxisModel)object3).getInterval().addBoundedIntervalListener(this.intervalListener);
                    }
                }
            }
        }
        this.updateIntervals();
        this.updateAxisType();
        this.resetXAxis();
        this.resetYAxis();
        this.timer.restart();
    }

    @Override
    @NotNull
    public MutableProperties<ScatterPlotView.PropertyType> getProperties() {
        return this.properties;
    }

    @NotNull
    protected final CPCanvas getCanvas() {
        Lazy lazy = this.canvas$delegate;
        return (CPCanvas)lazy.getValue();
    }

    @NotNull
    protected final CPTimer getTimer() {
        return this.timer;
    }

    @Override
    @NotNull
    public MutableTwoDScreenTransform getScreenTransform() {
        return this.screenTransform;
    }

    @Nullable
    protected final RangesScreenTransformCoordinator getRangesScreenTransformCoordinator() {
        return this.rangesScreenTransformCoordinator;
    }

    protected final void setRangesScreenTransformCoordinator(@Nullable RangesScreenTransformCoordinator rangesScreenTransformCoordinator) {
        this.rangesScreenTransformCoordinator = rangesScreenTransformCoordinator;
    }

    @Override
    @Nullable
    public Guide getXGuide() {
        return this.xGuide;
    }

    public void setXGuide(@Nullable Guide guide) {
        this.xGuide = guide;
    }

    @Override
    @Nullable
    public Guide getYGuide() {
        return this.yGuide;
    }

    public void setYGuide(@Nullable Guide guide) {
        this.yGuide = guide;
    }

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract void refresh();

    protected abstract void repaint();

    protected abstract void scheduleUpdate();

    @Override
    public void addMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.getCanvas().addMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.getCanvas().addMouseMotionListener(l);
    }

    @Override
    public void addMouseWheelListener(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.getCanvas().addMouseWheelListener(l);
    }

    @Override
    public void addKeyListener(@NotNull KeyListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.getCanvas().addKeyListener(listener2);
    }

    public final void createOverplots() {
        if (this.getModel() != null) {
            this.getCanvas().removeAllLayers();
            this.populateOverplots();
        }
    }

    protected final void populateOverplots() {
        ScatterPlotModel<Row, Column> scatterPlotModel = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel);
        VisualLayer visualLayer = scatterPlotModel.getVisual().getFiltered();
        IDrawing filteredDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer){
            final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public boolean isActive() {
                return (Boolean)this.this$0.getShowFiltered().getValue() != false && super.isActive();
            }

            public void draw(@NotNull IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint(0, row);
                if (mp != null) {
                    ScatterPlotModel<Row, Column> scatterPlotModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(scatterPlotModel);
                    if (scatterPlotModel.getSizeAxisModel() != null) {
                        int size = AbstractScatterPlotView.access$getMarkerSize(this.this$0, 0, row);
                        int radius = size / 2;
                        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)size, (double)size));
                    } else {
                        int size = Math.max(1, AbstractScatterPlotView.access$getMarkerSize(this.this$0, 0, row) / 2);
                        int radius = size / 2;
                        g.fillCircle((Rectangle2D)new Rectangle(mp.getIx() - radius, mp.getIy() - radius, size, size));
                    }
                }
            }
        };
        ScatterPlotModel<Row, Column> scatterPlotModel2 = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel2);
        VisualLayer visualLayer2 = scatterPlotModel2.getVisual().getVisible();
        IDrawing visibleDrawing3 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer2){
            final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(@NotNull IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint(0, row);
                if (mp != null) {
                    int size = AbstractScatterPlotView.access$getMarkerSize(this.this$0, 0, row);
                    int radius = size / 2;
                    g.fillCircle((Rectangle2D)new Rectangle(mp.getIx() - radius, mp.getIy() - radius, size, size));
                }
            }
        };
        ScatterPlotModel<Row, Column> scatterPlotModel3 = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel3);
        VisualLayer visualLayer3 = scatterPlotModel3.getVisual().getVisible();
        IDrawing visibleDrawing22 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer3){
            final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(@NotNull IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint2(0, row);
                if (mp != null) {
                    int size = AbstractScatterPlotView.access$getMarkerSize(this.this$0, 0, row);
                    int radius = size / 2;
                    g.setColor(MkColorFactory.Companion.getInstance().getDarkGray());
                    g.drawLine(mp.getX() - (double)radius, mp.getY(), mp.getX() + (double)radius, mp.getY());
                }
            }
        };
        ScatterPlotModel<Row, Column> scatterPlotModel4 = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel4);
        VisualLayer visualLayer4 = scatterPlotModel4.getVisual().getColorMapped();
        IDrawing colorMappedDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer4){
            final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(@NotNull IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint(0, row);
                if (mp != null) {
                    ScatterPlotModel<Row, Column> scatterPlotModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(scatterPlotModel);
                    Color color = scatterPlotModel.getColorMapping().getColor(row);
                    Intrinsics.checkNotNull((Object)color);
                    g.setColor(color);
                    int size = AbstractScatterPlotView.access$getMarkerSize(this.this$0, 0, row);
                    int radius = size / 2;
                    g.fillCircle((Rectangle2D)new Rectangle(mp.getIx() - radius, mp.getIy() - radius, size, size));
                }
            }
        };
        ScatterPlotModel<Row, Column> scatterPlotModel5 = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel5);
        VisualLayer visualLayer5 = scatterPlotModel5.getVisual().getColored();
        IDrawing coloredDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer5){
            final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(@NotNull IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint(0, row);
                if (mp != null) {
                    ScatterPlotModel<Row, Column> scatterPlotModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(scatterPlotModel);
                    Color color = scatterPlotModel.getColoring().getColor(row);
                    Intrinsics.checkNotNull((Object)color);
                    g.setColor(color);
                    int size = AbstractScatterPlotView.access$getMarkerSize(this.this$0, 0, row);
                    int radius = size / 2;
                    g.fillCircle((Rectangle2D)new Rectangle(mp.getIx() - radius, mp.getIy() - radius, size, size));
                }
            }
        };
        ScatterPlotModel<Row, Column> scatterPlotModel6 = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel6);
        VisualLayer visualLayer6 = scatterPlotModel6.getVisual().getSingleSelected();
        IDrawing singleSelectedDrawing3 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer6){
            final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(@NotNull IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint(0, row);
                if (mp != null) {
                    g.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                    ScatterPlotModel<Row, Column> scatterPlotModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(scatterPlotModel);
                    if (scatterPlotModel.getSizeAxisModel() != null) {
                        int size = AbstractScatterPlotView.access$getMarkerSize(this.this$0, 0, row) + 2;
                        int radius = size / 2;
                        g.fillCircle((Rectangle2D)new Rectangle(mp.getIx() - radius, mp.getIy() - radius, size, size));
                    } else {
                        int size = AbstractScatterPlotView.access$getMarkerSize(this.this$0, 0, row) + 2;
                        int radius = size / 2;
                        g.fillCircle((Rectangle2D)new Rectangle(mp.getIx() - radius, mp.getIy() - radius, size, size));
                    }
                }
            }
        };
        ScatterPlotModel<Row, Column> scatterPlotModel7 = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel7);
        VisualLayer visualLayer7 = scatterPlotModel7.getVisual().getSingleSelected();
        IDrawing singleSelectedDrawing22 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer7){
            final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(@NotNull IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint2(0, row);
                if (mp != null) {
                    g.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                    ScatterPlotModel<Row, Column> scatterPlotModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(scatterPlotModel);
                    if (scatterPlotModel.getSizeAxisModel() != null) {
                        int size = AbstractScatterPlotView.access$getMarkerSize(this.this$0, 0, row) + 2;
                        int radius = size / 2;
                        g.drawLine(mp.getX() - (double)radius, mp.getY(), mp.getX() + (double)radius, mp.getY());
                    } else {
                        int size = AbstractScatterPlotView.access$getMarkerSize(this.this$0, 0, row) + 2;
                        int radius = size / 2;
                        g.drawLine(mp.getX() - (double)radius, mp.getY(), mp.getX() + (double)radius, mp.getY());
                    }
                }
            }
        };
        ScatterPlotModel<Row, Column> scatterPlotModel8 = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel8);
        VisualLayer visualLayer8 = scatterPlotModel8.getVisual().getMultipleSelected();
        IDrawing multiSelectedDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer8){
            final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(@NotNull IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint(0, row);
                if (mp != null) {
                    g.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                    ScatterPlotModel<Row, Column> scatterPlotModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(scatterPlotModel);
                    if (scatterPlotModel.getSizeAxisModel() != null) {
                        int size = AbstractScatterPlotView.access$getMarkerSize(this.this$0, 0, row) + 2;
                        int radius = size / 2;
                        g.fillCircle((Rectangle2D)new Rectangle(mp.getIx() - radius, mp.getIy() - radius, size, size));
                    } else {
                        int size = AbstractScatterPlotView.access$getMarkerSize(this.this$0, 0, row) + 2;
                        int radius = size / 2;
                        g.fillCircle((Rectangle2D)new Rectangle(mp.getIx() - radius, mp.getIy() - radius, size, size));
                    }
                }
            }
        };
        ScatterPlotModel<Row, Column> scatterPlotModel9 = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel9);
        VisualLayer visualLayer9 = scatterPlotModel9.getVisual().getProbed();
        IDrawing probedDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer9){
            final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(@NotNull IGraphics g, Row row, double width, double height) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Point mp = this.this$0.getPoint(0, row);
                if (mp != null) {
                    ScatterPlotModel<Row, Column> scatterPlotModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(scatterPlotModel);
                    if (scatterPlotModel.getSizeAxisModel() != null) {
                        populateOverplots.probedDrawing.1 var8_6 = this;
                        AbstractScatterPlotView<Row, Column> abstractScatterPlotView = this.this$0;
                        populateOverplots.probedDrawing.1 $this$draw_u24lambda_u240 = var8_6;
                        boolean bl = false;
                        g.setColor(((ColorTheme)abstractScatterPlotView.getColorTheme().getValue()).getProbing());
                        int size = AbstractScatterPlotView.access$getMarkerSize(abstractScatterPlotView, 0, row) + 2;
                        int radius = size / 2;
                        g.fillCircle((Rectangle2D)new Rectangle(mp.getIx() - radius, mp.getIy() - radius, size, size));
                        ScatterPlotModel<Row, Column> scatterPlotModel2 = this.this$0.getModel();
                        Intrinsics.checkNotNull(scatterPlotModel2);
                        if (scatterPlotModel2.getSelection().isSelected(row)) {
                            g.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                            int size2 = AbstractScatterPlotView.access$getMarkerSize(this.this$0, 0, row);
                            int radius2 = size2 / 2;
                            g.fillCircle((Rectangle2D)new Rectangle(mp.getIx() - radius2, mp.getIy() - radius2, size2, size2));
                        }
                    } else {
                        populateOverplots.probedDrawing.1 size2 = this;
                        AbstractScatterPlotView<Row, Column> radius2 = this.this$0;
                        populateOverplots.probedDrawing.1 $this$draw_u24lambda_u241 = size2;
                        boolean bl = false;
                        g.setColor(((ColorTheme)radius2.getColorTheme().getValue()).getProbing());
                        int size = AbstractScatterPlotView.access$getMarkerSize(radius2, 0, row) + 2;
                        int radius = size / 2;
                        g.fillCircle((Rectangle2D)new Rectangle(mp.getIx() - radius, mp.getIy() - radius, size, size));
                        ScatterPlotModel<Row, Column> scatterPlotModel3 = this.this$0.getModel();
                        Intrinsics.checkNotNull(scatterPlotModel3);
                        if (scatterPlotModel3.getSelection().isSelected(row)) {
                            g.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                            int size3 = AbstractScatterPlotView.access$getMarkerSize(this.this$0, 0, row);
                            int radius3 = size3 / 2;
                            g.fillCircle((Rectangle2D)new Rectangle(mp.getIx() - radius3, mp.getIy() - radius3, size3, size3));
                        }
                    }
                }
            }
        };
        this.getCanvas().addLayer((IDrawing)new AbstractIDrawing(this){
            final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                Color background = ((ColorTheme)this.this$0.getColorTheme().getValue()).getBackground();
                if (background != null) {
                    g.setColor(background);
                    g.fillRectangle2D((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
                }
            }
        });
        if (((Boolean)this.getShowFiltered().getValue()).booleanValue()) {
            this.getCanvas().addDensityLayer((Rendering)this.getRendering().getValue(), filteredDrawing2, (Pressure)new LinearPressure(), new PaletteProvider(this){
                final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public FixedPalette getPalette() {
                    return ((ColorTheme)this.this$0.getColorTheme().getValue()).getGhostedPalette();
                }
            });
        }
        this.getCanvas().addDensityLayer((Rendering)this.getRendering().getValue(), visibleDrawing3, (Pressure)new LinearPressure(), new PaletteProvider(this){
            final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public FixedPalette getPalette() {
                return ((ColorTheme)this.this$0.getColorTheme().getValue()).getVisiblePalette();
            }
        });
        this.getCanvas().addAveragingLayer((Rendering)this.getRendering().getValue(), colorMappedDrawing2);
        this.getCanvas().addBufferedLayer(coloredDrawing2);
        this.getCanvas().addDensityLayer((Rendering)this.getRendering().getValue(), multiSelectedDrawing2, (Pressure)new LinearPressure(), new PaletteProvider(this){
            final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public FixedPalette getPalette() {
                return ((ColorTheme)this.this$0.getColorTheme().getValue()).getSelectedPalette();
            }
        });
        this.getCanvas().addLayer(singleSelectedDrawing3);
        this.getCanvas().addLayer(probedDrawing2);
        this.getCanvas().addDensityLayer((Rendering)this.getRendering().getValue(), visibleDrawing22, (Pressure)new LinearPressure(), new PaletteProvider(this){
            final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public FixedPalette getPalette() {
                return ((ColorTheme)this.this$0.getColorTheme().getValue()).getVisiblePalette();
            }
        });
        this.getCanvas().addLayer(singleSelectedDrawing22);
        CPCanvas cPCanvas = this.getCanvas();
        ScatterPlotModel<Row, Column> scatterPlotModel10 = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel10);
        cPCanvas.addLayer((IDrawing)new AnnotationIDrawing((Selection<Object>)((Selection)scatterPlotModel10.getVisual().getAnnotationProbing()), MkColorKt.colorOf((int)255, (int)150, (int)0, (int)200)));
        CPCanvas cPCanvas2 = this.getCanvas();
        ScatterPlotModel<Row, Column> scatterPlotModel11 = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel11);
        cPCanvas2.addLayer((IDrawing)new AnnotationIDrawing((Selection<Object>)((Selection)scatterPlotModel11.getVisual().getAnnotationSelection()), MkColorKt.colorOf((int)255, (int)100, (int)0, (int)200)));
        visualLayer9 = this.getRubberBand();
        this.getCanvas().addLayer((IDrawing)new RubberbandDrawing(this, (RubberBand)visualLayer9){
            final /* synthetic */ AbstractScatterPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            @NotNull
            protected Property<ColorTheme> getColorTheme() {
                return (Property)this.this$0.getColorTheme();
            }
        });
    }

    @Override
    @NotNull
    public MutableBoundedInterval getXRangeModel() {
        return this.xRangeModel;
    }

    @Override
    @NotNull
    public MutableBoundedInterval getYRangeModel() {
        return this.yRangeModel;
    }

    @Override
    @NotNull
    public RubberBand getRubberBand() {
        return this.rubberBand;
    }

    public final void resetXAxis() {
        ScatterPlotModel<Row, Column> scatterPlotModel = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel);
        if (scatterPlotModel.getXAxisModel() != null) {
            ScatterPlotModel<Row, Column> scatterPlotModel2 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotModel2);
            AxisModel<Row, ?> axisModel = scatterPlotModel2.getXAxisModel();
            Intrinsics.checkNotNull(axisModel);
            double min = axisModel.getMinimum();
            ScatterPlotModel<Row, Column> scatterPlotModel3 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotModel3);
            AxisModel<Row, ?> axisModel2 = scatterPlotModel3.getXAxisModel();
            Intrinsics.checkNotNull(axisModel2);
            double max = axisModel2.getMaximum();
            this.xRangeModel.setMinMax(min, max);
            this.xRangeModel.setValue(min, max - min);
        }
    }

    public final void resetYAxis() {
        ScatterPlotModel<Row, Column> scatterPlotModel = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel);
        if (scatterPlotModel.getYAxisModel() != null) {
            ScatterPlotModel<Row, Column> scatterPlotModel2 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotModel2);
            AxisModel<Row, ?> axisModel = scatterPlotModel2.getYAxisModel();
            Intrinsics.checkNotNull(axisModel);
            double min = axisModel.getMinimum();
            ScatterPlotModel<Row, Column> scatterPlotModel3 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotModel3);
            AxisModel<Row, ?> axisModel2 = scatterPlotModel3.getYAxisModel();
            Intrinsics.checkNotNull(axisModel2);
            double max = axisModel2.getMaximum();
            this.yRangeModel.setMinMax(min, max);
            this.yRangeModel.setValue(min, max - min);
        }
    }

    @Override
    public void zoom(boolean animate, double x1, double x2, double y1, double y2) {
        this.getXRangeModel().setValue(x1, x2 - x1);
        this.getYRangeModel().setValue(y1, y2 - y1);
    }

    /*
     * Unable to fully structure code
     */
    protected final void updateIntervals() {
        v0 = this.getModel();
        Intrinsics.checkNotNull(v0);
        x = v0.getX();
        v1 = this.getModel();
        Intrinsics.checkNotNull(v1);
        y = v1.getY();
        if (!x.isActive()) ** GOTO lbl-1000
        v2 = x.getSelected();
        Intrinsics.checkNotNull((Object)v2);
        if (((AxisModel)v2).getInterval() != null) {
            v3 = x.getSelected();
            Intrinsics.checkNotNull((Object)v3);
            min = ((AxisModel)v3).getInterval().getMinimum();
            v4 = x.getSelected();
            Intrinsics.checkNotNull((Object)v4);
            max = ((AxisModel)v4).getInterval().getMaximum();
            this.xRangeModel.setMinMax(min, max);
            this.xRangeModel.setValue(min, max - min);
        } else lbl-1000:
        // 2 sources

        {
            this.resetXAxis();
        }
        if (!y.isActive()) ** GOTO lbl-1000
        v5 = y.getSelected();
        Intrinsics.checkNotNull((Object)v5);
        if (((AxisModel)v5).getInterval() != null) {
            v6 = y.getSelected();
            Intrinsics.checkNotNull((Object)v6);
            min = ((AxisModel)v6).getInterval().getMinimum();
            v7 = y.getSelected();
            Intrinsics.checkNotNull((Object)v7);
            max = ((AxisModel)v7).getInterval().getMaximum();
            this.yRangeModel.setMinMax(min, max);
            this.yRangeModel.setValue(min, max - min);
        } else lbl-1000:
        // 2 sources

        {
            this.resetYAxis();
        }
        v8 = this.rangesScreenTransformCoordinator;
        if (v8 != null) {
            v8.setRanges(this.xRangeModel, this.yRangeModel);
        }
        this.scheduleUpdate();
    }

    protected abstract void updateAxisType();

    @Override
    @Nullable
    public Row getClosestRow(int x, int y) {
        double bestdistance = Double.MAX_VALUE;
        Row bestrow = null;
        ScatterPlotModel<Row, Column> scatterPlotModel = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel);
        VisualLayer visible = scatterPlotModel.getVisual().getActive();
        for (Object row : visible) {
            double distance;
            Point2D p = (Point2D)this.getPoint(0, row);
            if (p == null || !((distance = Point2D.Companion.distance(p.getX(), p.getY(), (double)x, (double)y)) < bestdistance)) continue;
            bestdistance = distance;
            bestrow = (Row)row;
        }
        return bestrow;
    }

    @Override
    @NotNull
    public List<Row> getRows(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        ScatterPlotModel<Row, Column> scatterPlotModel = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel);
        VisualLayer visible = scatterPlotModel.getVisual().getActive();
        List list = new ArrayList();
        for (Object row : visible) {
            Point2D p = (Point2D)this.getPoint(0, row);
            if (p == null || !rect.contains(p)) continue;
            list.add(row);
        }
        return list;
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getShowFiltered() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)ScatterPlotView.PropertyType.ShowFiltered);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Boolean>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getShowGrid() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)ScatterPlotView.PropertyType.ShowGrid);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Boolean>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getAntialiasing() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)ScatterPlotView.PropertyType.Antialiasing);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Boolean>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Rendering> getRendering() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)ScatterPlotView.PropertyType.Rendering);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<org.mkui.canvas.Rendering>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Float> getGridThickness() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)ScatterPlotView.PropertyType.GridThickness);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Float?>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Color> getShowColor() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)ScatterPlotView.PropertyType.ShowColor);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<javafx.scene.paint.Color?{ org.mkui.color.MkColorKt.MkColor? }>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getRegression() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)ScatterPlotView.PropertyType.Regression);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Boolean>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Double> getMarkerSize() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)ScatterPlotView.PropertyType.MarkerSize);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Double?>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<ColorTheme> getColorTheme() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)ScatterPlotView.PropertyType.ColorTheme);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<org.mkui.graphics.colortheme.ColorTheme>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getDisplayLabels() {
        MutableProperty mutableProperty = this.getProperties().getProperty((Object)ScatterPlotView.PropertyType.DisplayLabels);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Boolean>");
        return mutableProperty;
    }

    @Override
    public void setShowFiltered(@Nullable MutableProperty<Boolean> showFiltered) {
        MutableProperties<ScatterPlotView.PropertyType> mutableProperties = this.getProperties();
        MutableProperty<Boolean> mutableProperty = showFiltered;
        Intrinsics.checkNotNull(mutableProperty);
        mutableProperties.replaceProperty((Object)ScatterPlotView.PropertyType.ShowFiltered, mutableProperty);
    }

    @Override
    public void setRendering(@Nullable MutableProperty<Rendering> rendering) {
        MutableProperties<ScatterPlotView.PropertyType> mutableProperties = this.getProperties();
        MutableProperty<Rendering> mutableProperty = rendering;
        Intrinsics.checkNotNull(mutableProperty);
        mutableProperties.replaceProperty((Object)ScatterPlotView.PropertyType.Rendering, mutableProperty);
    }

    @Override
    public void setAntialiasing(@Nullable MutableProperty<Boolean> antialiasing) {
        MutableProperties<ScatterPlotView.PropertyType> mutableProperties = this.getProperties();
        MutableProperty<Boolean> mutableProperty = antialiasing;
        Intrinsics.checkNotNull(mutableProperty);
        mutableProperties.replaceProperty((Object)ScatterPlotView.PropertyType.Antialiasing, mutableProperty);
    }

    @Override
    public void setColorTheme(@Nullable MutableProperty<ColorTheme> colorTheme) {
        MutableProperties<ScatterPlotView.PropertyType> mutableProperties = this.getProperties();
        MutableProperty<ColorTheme> mutableProperty = colorTheme;
        Intrinsics.checkNotNull(mutableProperty);
        mutableProperties.replaceProperty((Object)ScatterPlotView.PropertyType.ColorTheme, mutableProperty);
    }

    @Override
    public boolean isSelectionMode() {
        return this.isSelectionMode;
    }

    @Override
    public void setSelectionMode(boolean value) {
        this.isSelectionMode = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Point getPoint(int layer, Row row) {
        ScatterPlotModel<Row, Column> scatterPlotModel = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel);
        if (scatterPlotModel.getXAxisModel() == null) return null;
        ScatterPlotModel<Row, Column> scatterPlotModel2 = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel2);
        if (scatterPlotModel2.getYAxisModel() == null) return null;
        ScatterPlotModel<Row, Column> scatterPlotModel3 = this.getModel();
        Number v1 = scatterPlotModel3 != null && (scatterPlotModel3 = scatterPlotModel3.getXAxisModel()) != null ? (Number)scatterPlotModel3.getValue(layer, row) : (Number)null;
        ScatterPlotModel<Row, Column> scatterPlotModel4 = this.getModel();
        Number v2 = scatterPlotModel4 != null && (scatterPlotModel4 = scatterPlotModel4.getYAxisModel()) != null ? (Number)scatterPlotModel4.getValue(layer, row) : (Number)null;
        if (v1 == null) return null;
        if (v2 == null) return null;
        Point point = new Point(this.getScreenTransform().getX().worldToScreen(v1.doubleValue()), this.getScreenTransform().getY().worldToScreen(v2.doubleValue()));
        return point;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Point getPoint2(int layer, Row row) {
        ScatterPlotModel<Row, Column> scatterPlotModel = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel);
        if (scatterPlotModel.getXAxisModel() == null) return null;
        ScatterPlotModel<Row, Column> scatterPlotModel2 = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel2);
        if (scatterPlotModel2.getY2AxisModel() == null) return null;
        ScatterPlotModel<Row, Column> scatterPlotModel3 = this.getModel();
        Number v1 = scatterPlotModel3 != null && (scatterPlotModel3 = scatterPlotModel3.getXAxisModel()) != null ? (Number)scatterPlotModel3.getValue(layer, row) : (Number)null;
        ScatterPlotModel<Row, Column> scatterPlotModel4 = this.getModel();
        Number v2 = scatterPlotModel4 != null && (scatterPlotModel4 = scatterPlotModel4.getY2AxisModel()) != null ? (Number)scatterPlotModel4.getValue(layer, row) : (Number)null;
        if (v1 == null) return null;
        if (v2 == null) return null;
        Point point = new Point(this.getScreenTransform().getX().worldToScreen(v1.doubleValue()), this.getScreenTransform().getY().worldToScreen(v2.doubleValue()));
        return point;
    }

    @Nullable
    public final Integer getXLine(int layer, Row row) {
        Integer n;
        ScatterPlotModel<Row, Column> scatterPlotModel = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel);
        if (scatterPlotModel.getXAxisModel() != null) {
            Number v1;
            ScatterPlotModel<Row, Column> scatterPlotModel2 = this.getModel();
            Number number = scatterPlotModel2 != null && (scatterPlotModel2 = scatterPlotModel2.getXAxisModel()) != null ? (Number)scatterPlotModel2.getValue(layer, row) : (Number)(v1 = null);
            n = v1 != null ? Integer.valueOf(this.getScreenTransform().getX().worldToScreen(v1.doubleValue())) : null;
        } else {
            n = null;
        }
        return n;
    }

    @Nullable
    public final Integer getYLine(int layer, Row row) {
        Integer n;
        ScatterPlotModel<Row, Column> scatterPlotModel = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel);
        if (scatterPlotModel.getYAxisModel() != null) {
            Number v2;
            ScatterPlotModel<Row, Column> scatterPlotModel2 = this.getModel();
            Number number = scatterPlotModel2 != null && (scatterPlotModel2 = scatterPlotModel2.getYAxisModel()) != null ? (Number)scatterPlotModel2.getValue(layer, row) : (Number)(v2 = null);
            n = v2 != null ? Integer.valueOf(this.getScreenTransform().getY().worldToScreen(v2.doubleValue())) : null;
        } else {
            n = null;
        }
        return n;
    }

    private final int getMarkerSize(int layer, Row row) {
        int n;
        ScatterPlotModel<Row, Column> scatterPlotModel = this.getModel();
        Intrinsics.checkNotNull(scatterPlotModel);
        AxisModel<Row, ?> sizeAxisModel = scatterPlotModel.getSizeAxisModel();
        if (sizeAxisModel != null) {
            Number v1 = sizeAxisModel.getValue(layer, row);
            if (v1 != null) {
                double range = (double)2 * Math.sqrt((sizeAxisModel.getMaximum() - sizeAxisModel.getMinimum()) / Math.PI);
                double v = (double)2 * Math.sqrt((v1.doubleValue() - sizeAxisModel.getMinimum()) / Math.PI);
                Object object = this.getMarkerSize().getValue();
                Intrinsics.checkNotNull((Object)object);
                n = (Integer)(v * ((double)((int)((Number)object).doubleValue()) - 1.0) / range) + 1;
            } else {
                n = false;
            }
        } else {
            Object object = this.getMarkerSize().getValue();
            Intrinsics.checkNotNull((Object)object);
            n = (int)((Number)object).doubleValue();
        }
        return n;
    }

    public static final /* synthetic */ BoundedIntervalListener access$getIntervalListener$p(AbstractScatterPlotView $this) {
        return $this.intervalListener;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u0015\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH&\u00a2\u0006\u0002\u0010\u0010J2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/macrofocus/high_d/scatterplot/AbstractScatterPlotView$AbstractVisualLayerIDrawing;", "Lorg/mkui/graphics/AbstractIDrawing;", "visualLayer", "Lorg/mkui/visual/VisualLayer;", "(Lcom/macrofocus/high_d/scatterplot/AbstractScatterPlotView;Lorg/mkui/visual/VisualLayer;)V", "isActive", "", "()Z", "draw", "", "g", "Lorg/mkui/graphics/IGraphics;", "row", "width", "", "height", "(Lorg/mkui/graphics/IGraphics;Ljava/lang/Object;DD)V", "point", "Lorg/mkui/geom/Point2D;", "clipBounds", "Lorg/mkui/geom/Rectangle;", "highd"})
    public abstract class AbstractVisualLayerIDrawing
    extends AbstractIDrawing {
        @NotNull
        private final VisualLayer<Row> visualLayer;

        protected AbstractVisualLayerIDrawing(VisualLayer<Row> visualLayer) {
            Intrinsics.checkNotNullParameter(visualLayer, (String)"visualLayer");
            this.visualLayer = visualLayer;
            visualLayer.addVisualListener(new VisualListener(){

                public void visualChanged() {
                    this.notifyIDrawingChanged();
                }
            });
        }

        public boolean isActive() {
            return this.visualLayer.isActive();
        }

        public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
            block9: {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                if (this.visualLayer.getObjectCount() <= 0) break block9;
                if (!g.isThreadSafe()) {
                    for (Object row : this.visualLayer) {
                        this.draw(g, row, width, height);
                    }
                } else {
                    int nTasks = Math.min(Runtime.Companion.getRuntime().availableProcessors(), this.visualLayer.getObjectCount());
                    int nRowsPerTask = this.visualLayer.getObjectCount() / nTasks;
                    List todo = new ArrayList(nTasks);
                    for (int nTask = 0; nTask < nTasks; ++nTask) {
                        int fromRow = nTask * nRowsPerTask;
                        int toRow = nTask < nTasks - 1 ? fromRow + nRowsPerTask : this.visualLayer.getObjectCount();
                        todo.add(new Callable<Object>(this, fromRow, toRow, g, width, height){
                            final /* synthetic */ AbstractVisualLayerIDrawing this$0;
                            final /* synthetic */ int $fromRow;
                            final /* synthetic */ int $toRow;
                            final /* synthetic */ IGraphics $g;
                            final /* synthetic */ double $width;
                            final /* synthetic */ double $height;
                            {
                                this.this$0 = $receiver;
                                this.$fromRow = $fromRow;
                                this.$toRow = $toRow;
                                this.$g = $g;
                                this.$width = $width;
                                this.$height = $height;
                            }

                            @Nullable
                            public Object call() throws Exception {
                                for (T row : AbstractVisualLayerIDrawing.access$getVisualLayer$p(this.this$0).iterable(this.$fromRow, this.$toRow - 1)) {
                                    this.this$0.draw(this.$g, row, this.$width, this.$height);
                                }
                                return null;
                            }
                        });
                    }
                    try {
                        ExecutorService executorService = executor;
                        Intrinsics.checkNotNull((Object)executorService);
                        List answers = executorService.invokeAll((Collection)todo);
                        for (Future answer : answers) {
                            try {
                                answer.get();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public abstract void draw(@NotNull IGraphics var1, Row var2, double var3, double var5);

        public static final /* synthetic */ VisualLayer access$getVisualLayer$p(AbstractVisualLayerIDrawing $this) {
            return $this.visualLayer;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/macrofocus/high_d/scatterplot/AbstractScatterPlotView$AnnotationIDrawing;", "Lorg/mkui/graphics/AbstractIDrawing;", "selection", "Lcom/macrofocus/common/selection/Selection;", "", "color", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "(Lcom/macrofocus/high_d/scatterplot/AbstractScatterPlotView;Lcom/macrofocus/common/selection/Selection;Ljavafx/scene/paint/Color;)V", "isActive", "", "()Z", "selectionListener", "Lcom/macrofocus/common/selection/SelectionListener;", "draw", "", "g", "Lorg/mkui/graphics/IGraphics;", "point", "Lorg/mkui/geom/Point2D;", "width", "", "height", "clipBounds", "Lorg/mkui/geom/Rectangle;", "highd"})
    private final class AnnotationIDrawing
    extends AbstractIDrawing {
        @NotNull
        private final Selection<Object> selection;
        @NotNull
        private final Color color;
        @NotNull
        private final SelectionListener<Object> selectionListener;

        public AnnotationIDrawing(@NotNull Selection<Object> selection, Color color) {
            Intrinsics.checkNotNullParameter(selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.selection = selection;
            this.selectionListener = (SelectionListener)new SelectionListener<Object>(this){
                final /* synthetic */ AnnotationIDrawing this$0;
                {
                    this.this$0 = $receiver;
                }

                public void selectionChanged(@NotNull SelectionEvent<Object> event) {
                    Intrinsics.checkNotNullParameter(event, (String)"event");
                    AnnotationIDrawing.access$notifyIDrawingChanged(this.this$0);
                }
            };
            this.color = color;
            this.selection.addWeakSelectionListener(this.selectionListener);
        }

        public boolean isActive() {
            return true;
        }

        public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
            g.setColor(this.color);
            for (Object row : this.selection) {
                Point mp = AbstractScatterPlotView.this.getPoint(1, row);
                if (mp != null) {
                    g.drawLine(mp.getIx(), 0, mp.getIx(), (int)height);
                    g.drawLine(0, mp.getIy(), (int)width, mp.getIy());
                    ScatterPlotModel scatterPlotModel = AbstractScatterPlotView.this.getModel();
                    Intrinsics.checkNotNull(scatterPlotModel);
                    if (scatterPlotModel.getSizeAxisModel() != null) {
                        int size = AbstractScatterPlotView.this.getMarkerSize(1, row);
                        int radius = size / 2;
                        g.fillCircle((Rectangle2D)new Rectangle(mp.getIx() - radius, mp.getIy() - radius, size, size));
                        continue;
                    }
                    int size = AbstractScatterPlotView.this.getMarkerSize(1, row) + 2;
                    int radius = size / 2;
                    g.fillCircle((Rectangle2D)new Rectangle(mp.getIx() - radius, mp.getIy() - radius, size, size));
                    continue;
                }
                Integer y = AbstractScatterPlotView.this.getYLine(1, row);
                if (y != null) {
                    g.drawLine(0, y.intValue(), (int)width, y.intValue());
                    continue;
                }
                Integer x = AbstractScatterPlotView.this.getXLine(1, row);
                if (x == null) continue;
                g.drawLine(x.intValue(), 0, x.intValue(), (int)height);
            }
        }

        public static final /* synthetic */ void access$notifyIDrawingChanged(AnnotationIDrawing $this) {
            $this.notifyIDrawingChanged();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/macrofocus/high_d/scatterplot/AbstractScatterPlotView$Companion;", "", "()V", "MULTITHREADED", "", "executor", "Lcom/macrofocus/common/concurrent/ExecutorService;", "highd"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

