/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplotmatrix;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.command.Future;
import com.macrofocus.common.concurrent.Callable;
import com.macrofocus.common.concurrent.ExecutorService;
import com.macrofocus.common.concurrent.Runtime;
import com.macrofocus.common.crossplatform.CPHelper;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.timer.CPTimer;
import com.macrofocus.common.timer.CPTimerListener;
import com.macrofocus.high_d.axis.AxisListener;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.parallelcoordinatesmatrix.ScatterPlotMatrixComponent;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixListener;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixModel;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixView;
import com.macrofocus.order.MutableVisibleOrder;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.CPCanvas;
import org.mkui.canvas.PaletteProvider;
import org.mkui.canvas.Rendering;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.graphics.AbstractIDrawing;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.colortheme.ColorTheme;
import org.mkui.graphics.pressure.LogPressure;
import org.mkui.graphics.pressure.Pressure;
import org.mkui.palette.FixedPalette;
import org.mkui.rubberband.RubberBand;
import org.mkui.rubberband.RubberbandDrawing;
import org.mkui.visual.VisualLayer;
import org.mkui.visual.VisualListener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u0000 6*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u000256B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020\"H$Ja\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00028\u00002\u0010\u0010)\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u00182\u0010\u0010*\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\"\u00a2\u0006\u0002\u0010-J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000/2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\"H$J\b\u00103\u001a\u00020\u001eH\u0014J\b\u00104\u001a\u00020\u001eH$R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00102\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0010@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/macrofocus/high_d/scatterplotmatrix/AbstractScatterPlotMatrixComponent;", "Row", "Column", "Lcom/macrofocus/high_d/parallelcoordinatesmatrix/ScatterPlotMatrixComponent;", "view", "Lcom/macrofocus/high_d/scatterplotmatrix/ScatterPlotMatrixView;", "(Lcom/macrofocus/high_d/scatterplotmatrix/ScatterPlotMatrixView;)V", "axisListener", "Lcom/macrofocus/high_d/axis/AxisListener;", "canvas", "Lorg/mkui/canvas/CPCanvas;", "getCanvas", "()Lorg/mkui/canvas/CPCanvas;", "listener", "Lcom/macrofocus/high_d/scatterplotmatrix/ScatterPlotMatrixListener;", "value", "Lcom/macrofocus/high_d/scatterplotmatrix/ScatterPlotMatrixModel;", "model", "getModel", "()Lcom/macrofocus/high_d/scatterplotmatrix/ScatterPlotMatrixModel;", "setModel", "(Lcom/macrofocus/high_d/scatterplotmatrix/ScatterPlotMatrixModel;)V", "orderListener", "Lcom/macrofocus/order/OrderListener;", "Lcom/macrofocus/high_d/axis/AxisModel;", "timer", "Lcom/macrofocus/common/timer/CPTimer;", "getTimer", "()Lcom/macrofocus/common/timer/CPTimer;", "createOverplots", "", "getClosestRow", "", "x", "", "y", "getHeight", "getPoint", "Lorg/mkui/geom/Point2D;", "layer", "row", "xAxisModel", "yAxisModel", "width", "height", "(ILjava/lang/Object;Lcom/macrofocus/high_d/axis/AxisModel;Lcom/macrofocus/high_d/axis/AxisModel;IIII)Lorg/mkui/geom/Point2D;", "getRows", "", "rect", "Lorg/mkui/geom/Rectangle2D;", "getWidth", "refresh", "repaint", "AbstractVisualLayerIDrawing", "Companion", "highd"})
@StabilityInferred(parameters=0)
public abstract class AbstractScatterPlotMatrixComponent<Row, Column>
implements ScatterPlotMatrixComponent<Row, Column> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScatterPlotMatrixView<Row, Column> view;
    @NotNull
    private final CPCanvas canvas;
    @Nullable
    private ScatterPlotMatrixModel<Row, Column> model;
    @NotNull
    private final CPTimer timer;
    @NotNull
    private final ScatterPlotMatrixListener listener;
    @NotNull
    private final AxisListener axisListener;
    @NotNull
    private final OrderListener<AxisModel<Row, Column>> orderListener;
    public static final int $stable = 8;
    private static final boolean MULTITHREADED = true;
    @Nullable
    private static final ExecutorService executor = CPHelper.Companion.getInstance().visualizationExecutorService();

    public AbstractScatterPlotMatrixComponent(@NotNull ScatterPlotMatrixView<Row, Column> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        this.view = view;
        this.canvas = new CPCanvas();
        this.timer = CPHelper.Companion.getInstance().createTimer("ScatterPlotMatrixResizer", 40, true, new CPTimerListener(this){
            final /* synthetic */ AbstractScatterPlotMatrixComponent<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void timerTriggered() {
                if (this.this$0.getWidth() > 0 && this.this$0.getHeight() > 0) {
                    this.this$0.refresh();
                }
            }
        });
        this.listener = new ScatterPlotMatrixListener(this){
            final /* synthetic */ AbstractScatterPlotMatrixComponent<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void scatterPlotMatrixChanged() {
                this.this$0.getTimer().restart();
            }
        };
        this.axisListener = new AxisListener(this){
            final /* synthetic */ AbstractScatterPlotMatrixComponent<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void axisChanged() {
                this.this$0.scheduleUpdate();
            }
        };
        this.orderListener = new OrderListener<AxisModel<Row, Column>>(this){
            final /* synthetic */ AbstractScatterPlotMatrixComponent<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void orderChanged(@Nullable OrderEvent<AxisModel<Row, Column>> event) {
                this.this$0.scheduleUpdate();
            }

            public void orderVisibility(@NotNull OrderEvent<AxisModel<Row, Column>> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.scheduleUpdate();
            }

            public void orderAdded(@NotNull OrderEvent<AxisModel<Row, Column>> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.scheduleUpdate();
            }

            public void orderRemoved(@NotNull OrderEvent<AxisModel<Row, Column>> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.scheduleUpdate();
            }
        };
    }

    @NotNull
    protected final CPCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    @Nullable
    public ScatterPlotMatrixModel<Row, Column> getModel() {
        return this.model;
    }

    @Override
    public void setModel(@Nullable ScatterPlotMatrixModel<Row, Column> value) {
        if (this.model != null) {
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel = this.model;
            Intrinsics.checkNotNull(scatterPlotMatrixModel);
            scatterPlotMatrixModel.removeScatterPlotMatrixListener(this.listener);
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel2 = this.model;
            Intrinsics.checkNotNull(scatterPlotMatrixModel2);
            MutableVisibleOrder mutableVisibleOrder = scatterPlotMatrixModel2.getAxisGroupModel().getAxisOrder();
            Intrinsics.checkNotNull((Object)mutableVisibleOrder);
            mutableVisibleOrder.removeOrderListener(this.orderListener);
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel3 = this.model;
            Intrinsics.checkNotNull(scatterPlotMatrixModel3);
            scatterPlotMatrixModel3.getAxisGroupModel().removeAxisListener(this.axisListener);
        }
        this.model = value;
        if (this.model != null) {
            this.createOverplots();
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel = this.model;
            Intrinsics.checkNotNull(scatterPlotMatrixModel);
            scatterPlotMatrixModel.addScatterPlotMatrixListener(this.listener);
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel4 = this.model;
            Intrinsics.checkNotNull(scatterPlotMatrixModel4);
            MutableVisibleOrder mutableVisibleOrder = scatterPlotMatrixModel4.getAxisGroupModel().getAxisOrder();
            Intrinsics.checkNotNull((Object)mutableVisibleOrder);
            mutableVisibleOrder.addOrderListener(this.orderListener);
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel5 = this.model;
            Intrinsics.checkNotNull(scatterPlotMatrixModel5);
            scatterPlotMatrixModel5.getAxisGroupModel().addAxisListener(this.axisListener);
        }
        this.timer.restart();
    }

    @NotNull
    protected final CPTimer getTimer() {
        return this.timer;
    }

    protected void refresh() {
        this.canvas.refresh();
    }

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract void repaint();

    @Override
    public void createOverplots() {
        if (this.getModel() != null) {
            this.canvas.removeAllLayers();
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel = this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel);
            VisualLayer visualLayer = scatterPlotMatrixModel.getVisual().getFiltered();
            IDrawing filteredDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer){
                final /* synthetic */ AbstractScatterPlotMatrixComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public boolean isActive() {
                    return (Boolean)AbstractScatterPlotMatrixComponent.access$getView$p(this.this$0).getShowFiltered().getValue() != false && super.isActive();
                }

                public void draw(@NotNull IGraphics g, @NotNull Point2D mp, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
                    g.drawPoint(mp);
                }
            };
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel2 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel2);
            VisualLayer visualLayer2 = scatterPlotMatrixModel2.getVisual().getVisible();
            IDrawing visibleDrawing3 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer2){

                public void draw(@NotNull IGraphics g, @NotNull Point2D mp, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
                    int radius = 2;
                    g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)radius * 2.0, (double)radius * 2.0));
                }
            };
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel3 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel3);
            VisualLayer visualLayer3 = scatterPlotMatrixModel3.getVisual().getColorMapped();
            IDrawing colorMappedDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer3){
                final /* synthetic */ AbstractScatterPlotMatrixComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void draw(@NotNull IGraphics g, @NotNull Point2D mp, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
                    ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(scatterPlotMatrixModel);
                    Color color = scatterPlotMatrixModel.getColorMapping().getColor(row);
                    Intrinsics.checkNotNull((Object)color);
                    g.setColor(color);
                    int radius = 2;
                    g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)radius * 2.0, (double)radius * 2.0));
                }
            };
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel4 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel4);
            VisualLayer visualLayer4 = scatterPlotMatrixModel4.getVisual().getColored();
            IDrawing coloredDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer4){
                final /* synthetic */ AbstractScatterPlotMatrixComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void draw(@NotNull IGraphics g, @NotNull Point2D mp, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
                    ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(scatterPlotMatrixModel);
                    Color color = scatterPlotMatrixModel.getColoring().getColor(row);
                    Intrinsics.checkNotNull((Object)color);
                    g.setColor(color);
                    int radius = 2;
                    g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)radius * 2.0, (double)radius * 2.0));
                }
            };
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel5 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel5);
            VisualLayer visualLayer5 = scatterPlotMatrixModel5.getVisual().getSingleSelected();
            IDrawing singleSelectedDrawing3 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer5){
                final /* synthetic */ AbstractScatterPlotMatrixComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void draw(@NotNull IGraphics g, @NotNull Point2D mp, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
                    g.setColor(((ColorTheme)AbstractScatterPlotMatrixComponent.access$getView$p(this.this$0).getColorTheme().getValue()).getSelection());
                    int radius = 2;
                    g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)radius * 2.0, (double)radius * 2.0));
                }
            };
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel6 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel6);
            VisualLayer visualLayer6 = scatterPlotMatrixModel6.getVisual().getMultipleSelected();
            IDrawing multiSelectedDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer6){
                final /* synthetic */ AbstractScatterPlotMatrixComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void draw(@NotNull IGraphics g, @NotNull Point2D mp, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
                    g.setColor(((ColorTheme)AbstractScatterPlotMatrixComponent.access$getView$p(this.this$0).getColorTheme().getValue()).getSelection());
                    int radius = 2;
                    g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)radius * 2.0, (double)radius * 2.0));
                }
            };
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel7 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel7);
            VisualLayer visualLayer7 = scatterPlotMatrixModel7.getVisual().getProbed();
            IDrawing probedDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer7){
                final /* synthetic */ AbstractScatterPlotMatrixComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void draw(@NotNull IGraphics g, @NotNull Point2D mp, Row row) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
                    g.setColor(((ColorTheme)AbstractScatterPlotMatrixComponent.access$getView$p(this.this$0).getColorTheme().getValue()).getProbing());
                    int radius = 3;
                    g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)radius * 2.0, (double)radius * 2.0));
                    ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(scatterPlotMatrixModel);
                    if (scatterPlotMatrixModel.getSelection().isSelected(row)) {
                        g.setColor(((ColorTheme)AbstractScatterPlotMatrixComponent.access$getView$p(this.this$0).getColorTheme().getValue()).getSelection());
                        radius = 2;
                        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)radius * 2.0, (double)radius * 2.0));
                    }
                }
            };
            this.canvas.addLayer((IDrawing)new AbstractIDrawing(this){
                final /* synthetic */ AbstractScatterPlotMatrixComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                    g.setColor(((ColorTheme)AbstractScatterPlotMatrixComponent.access$getView$p(this.this$0).getColorTheme().getValue()).getBackground());
                    g.fillRectangle(0, 0, this.this$0.getWidth(), this.this$0.getHeight());
                    ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel = this.this$0.getModel();
                    Intrinsics.checkNotNull(scatterPlotMatrixModel);
                    int n = scatterPlotMatrixModel.getAxisCount();
                    for (int i = 0; i < n; ++i) {
                        ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel2 = this.this$0.getModel();
                        Intrinsics.checkNotNull(scatterPlotMatrixModel2);
                        AxisModel<Row, Column> xAxisModel = scatterPlotMatrixModel2.getAxisModel(i);
                        ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel3 = this.this$0.getModel();
                        Intrinsics.checkNotNull(scatterPlotMatrixModel3);
                        double location = scatterPlotMatrixModel3.getLocation(xAxisModel);
                        g.setColor(((ColorTheme)AbstractScatterPlotMatrixComponent.access$getView$p(this.this$0).getColorTheme().getValue()).getForeground());
                        g.setLineWidth(3.0);
                        int x = (int)(location * (double)this.this$0.getWidth());
                        int y = (int)(location * (double)this.this$0.getHeight());
                        g.drawLine(x, 0, x, this.this$0.getHeight());
                        g.drawLine(0, y, this.this$0.getWidth(), y);
                    }
                }
            });
            this.canvas.addDensityLayer((Rendering)this.view.getRendering().getValue(), filteredDrawing2, (Pressure)new LogPressure(), new PaletteProvider(this){
                final /* synthetic */ AbstractScatterPlotMatrixComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public FixedPalette getPalette() {
                    return ((ColorTheme)AbstractScatterPlotMatrixComponent.access$getView$p(this.this$0).getColorTheme().getValue()).getGhostedPalette();
                }
            });
            this.canvas.addDensityLayer((Rendering)this.view.getRendering().getValue(), visibleDrawing3, (Pressure)new LogPressure(), new PaletteProvider(this){
                final /* synthetic */ AbstractScatterPlotMatrixComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public FixedPalette getPalette() {
                    return ((ColorTheme)AbstractScatterPlotMatrixComponent.access$getView$p(this.this$0).getColorTheme().getValue()).getVisiblePalette();
                }
            });
            this.canvas.addAveragingLayer((Rendering)this.view.getRendering().getValue(), colorMappedDrawing2);
            this.canvas.addBufferedLayer(coloredDrawing2);
            this.canvas.addDensityLayer((Rendering)this.view.getRendering().getValue(), multiSelectedDrawing2, (Pressure)new LogPressure(), new PaletteProvider(this){
                final /* synthetic */ AbstractScatterPlotMatrixComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public FixedPalette getPalette() {
                    return ((ColorTheme)AbstractScatterPlotMatrixComponent.access$getView$p(this.this$0).getColorTheme().getValue()).getSelectedPalette();
                }
            });
            this.canvas.addLayer(singleSelectedDrawing3);
            this.canvas.addLayer(probedDrawing2);
            visualLayer7 = this.view.getRubberBand();
            this.canvas.addLayer((IDrawing)new RubberbandDrawing(this, (RubberBand)visualLayer7){
                final /* synthetic */ AbstractScatterPlotMatrixComponent<Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                @NotNull
                protected Property<ColorTheme> getColorTheme() {
                    return (Property)AbstractScatterPlotMatrixComponent.access$getView$p(this.this$0).getColorTheme();
                }
            });
        }
    }

    @Override
    @Nullable
    public Object getClosestRow(int x, int y) {
        ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel = this.getModel();
        Intrinsics.checkNotNull(scatterPlotMatrixModel);
        int n = scatterPlotMatrixModel.getAxisCount();
        for (int i = 0; i < n; ++i) {
            double d;
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel2 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel2);
            AxisModel<Row, Column> xAxisModel = scatterPlotMatrixModel2.getAxisModel(i);
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel3 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel3);
            double x1Location = scatterPlotMatrixModel3.getLocation(xAxisModel);
            double x2Location = 0.0;
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel4 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel4);
            if (i + 1 < scatterPlotMatrixModel4.getAxisCount()) {
                ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel5 = this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel5);
                ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel6 = this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel6);
                d = scatterPlotMatrixModel5.getLocation(scatterPlotMatrixModel6.getAxisModel(i + 1));
            } else {
                d = 1.0;
            }
            x2Location = d;
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel7 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel7);
            int n2 = scatterPlotMatrixModel7.getAxisCount();
            for (int j = 0; j < n2; ++j) {
                double d2;
                if (i == j) continue;
                ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel8 = this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel8);
                AxisModel<Row, Column> yAxisModel = scatterPlotMatrixModel8.getAxisModel(j);
                ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel9 = this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel9);
                double y1Location = scatterPlotMatrixModel9.getLocation(yAxisModel);
                double y2Location = 0.0;
                ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel10 = this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel10);
                if (j + 1 < scatterPlotMatrixModel10.getAxisCount()) {
                    ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel11 = this.getModel();
                    Intrinsics.checkNotNull(scatterPlotMatrixModel11);
                    ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel12 = this.getModel();
                    Intrinsics.checkNotNull(scatterPlotMatrixModel12);
                    d2 = scatterPlotMatrixModel11.getLocation(scatterPlotMatrixModel12.getAxisModel(j + 1));
                } else {
                    d2 = 1.0;
                }
                y2Location = d2;
                int x1 = (int)(x1Location * (double)this.getWidth());
                int y1 = (int)(y1Location * (double)this.getHeight());
                int x2 = (int)(x2Location * (double)this.getWidth());
                int y2 = (int)(y2Location * (double)this.getHeight());
                int width = x2 - x1;
                int height = y2 - y1;
                if (x < x1 || x > x2 || y < y1 || y > y2) continue;
                double minDistance = Double.MAX_VALUE;
                Object closest = null;
                ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel13 = this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel13);
                VisualLayer visible = scatterPlotMatrixModel13.getVisual().getActive();
                for (Object row : visible) {
                    double distance;
                    Point2D mp = this.getPoint(0, row, xAxisModel, yAxisModel, x1, y1, width, height);
                    if (mp == null || !((distance = Point2D.Companion.distance((double)x, (double)y, mp.getX(), mp.getY())) < minDistance)) continue;
                    closest = row;
                    minDistance = distance;
                }
                return closest;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<Row> getRows(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        List list = new ArrayList();
        ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel = this.getModel();
        Intrinsics.checkNotNull(scatterPlotMatrixModel);
        int n = scatterPlotMatrixModel.getAxisCount();
        for (int i = 0; i < n; ++i) {
            double d;
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel2 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel2);
            AxisModel<Row, Column> xAxisModel = scatterPlotMatrixModel2.getAxisModel(i);
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel3 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel3);
            double x1Location = scatterPlotMatrixModel3.getLocation(xAxisModel);
            double x2Location = 0.0;
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel4 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel4);
            if (i + 1 < scatterPlotMatrixModel4.getAxisCount()) {
                ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel5 = this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel5);
                ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel6 = this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel6);
                d = scatterPlotMatrixModel5.getLocation(scatterPlotMatrixModel6.getAxisModel(i + 1));
            } else {
                d = 1.0;
            }
            x2Location = d;
            ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel7 = this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel7);
            int n2 = scatterPlotMatrixModel7.getAxisCount();
            for (int j = 0; j < n2; ++j) {
                double d2;
                if (i == j) continue;
                ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel8 = this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel8);
                AxisModel<Row, Column> yAxisModel = scatterPlotMatrixModel8.getAxisModel(j);
                ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel9 = this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel9);
                double y1Location = scatterPlotMatrixModel9.getLocation(yAxisModel);
                double y2Location = 0.0;
                ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel10 = this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel10);
                if (j + 1 < scatterPlotMatrixModel10.getAxisCount()) {
                    ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel11 = this.getModel();
                    Intrinsics.checkNotNull(scatterPlotMatrixModel11);
                    ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel12 = this.getModel();
                    Intrinsics.checkNotNull(scatterPlotMatrixModel12);
                    d2 = scatterPlotMatrixModel11.getLocation(scatterPlotMatrixModel12.getAxisModel(j + 1));
                } else {
                    d2 = 1.0;
                }
                y2Location = d2;
                int x1 = (int)(x1Location * (double)this.getWidth());
                int y1 = (int)(y1Location * (double)this.getHeight());
                int x2 = (int)(x2Location * (double)this.getWidth());
                int y2 = (int)(y2Location * (double)this.getHeight());
                int width = x2 - x1;
                int height = y2 - y1;
                if (!(rect.getX() >= (double)x1) || !(rect.getX() <= (double)x2) || !(rect.getY() >= (double)y1) || !(rect.getY() <= (double)y2)) continue;
                ScatterPlotMatrixModel<Row, Column> scatterPlotMatrixModel13 = this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel13);
                VisualLayer visible = scatterPlotMatrixModel13.getVisual().getActive();
                for (Object row : visible) {
                    Point2D mp = this.getPoint(0, row, xAxisModel, yAxisModel, x1, y1, width, height);
                    if (mp == null || !rect.contains(mp)) continue;
                    list.add(row);
                }
                return list;
            }
        }
        return list;
    }

    @Nullable
    public final Point2D getPoint(int layer, Row row, @NotNull AxisModel<Row, ?> xAxisModel, @NotNull AxisModel<Row, ?> yAxisModel, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter(xAxisModel, (String)"xAxisModel");
        Intrinsics.checkNotNullParameter(yAxisModel, (String)"yAxisModel");
        int x2 = x;
        int y2 = y;
        int width2 = width;
        int height2 = height;
        int inset = 5;
        Number v1 = xAxisModel.getValue(layer, row);
        Number v2 = yAxisModel.getValue(layer, row);
        return v1 != null && v2 != null ? (Point2D)new Point2D.Double((double)(x2 += inset) + (double)((width2 -= inset + inset) - 1) * ((v1.doubleValue() - xAxisModel.getMinimum()) / (xAxisModel.getMaximum() - xAxisModel.getMinimum())), (double)((y2 += inset) + (height2 -= inset + inset)) - (double)(height2 - 1) * ((v2.doubleValue() - yAxisModel.getMinimum()) / (yAxisModel.getMaximum() - yAxisModel.getMinimum()))) : null;
    }

    public static final /* synthetic */ ScatterPlotMatrixView access$getView$p(AbstractScatterPlotMatrixComponent $this) {
        return $this.view;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u0015\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\rJ%\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0010J2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/macrofocus/high_d/scatterplotmatrix/AbstractScatterPlotMatrixComponent$AbstractVisualLayerIDrawing;", "Lorg/mkui/graphics/AbstractIDrawing;", "visualLayer", "Lorg/mkui/visual/VisualLayer;", "(Lcom/macrofocus/high_d/scatterplotmatrix/AbstractScatterPlotMatrixComponent;Lorg/mkui/visual/VisualLayer;)V", "isActive", "", "()Z", "draw", "", "g", "Lorg/mkui/graphics/IGraphics;", "row", "(Lorg/mkui/graphics/IGraphics;Ljava/lang/Object;)V", "p", "Lorg/mkui/geom/Point2D;", "(Lorg/mkui/graphics/IGraphics;Lorg/mkui/geom/Point2D;Ljava/lang/Object;)V", "point", "width", "", "height", "clipBounds", "Lorg/mkui/geom/Rectangle;", "getLayer", "", "highd"})
    public abstract class AbstractVisualLayerIDrawing
    extends AbstractIDrawing {
        @NotNull
        private final VisualLayer<Row> visualLayer;

        protected AbstractVisualLayerIDrawing(VisualLayer<Row> visualLayer) {
            Intrinsics.checkNotNullParameter(visualLayer, (String)"visualLayer");
            this.visualLayer = visualLayer;
            visualLayer.addVisualListener(new VisualListener(){

                public void visualChanged() {
                    this.notifyIDrawingChanged();
                }
            });
        }

        public boolean isActive() {
            return this.visualLayer.isActive();
        }

        public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
            block9: {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                if (this.visualLayer.getObjectCount() <= 0) break block9;
                if (!g.isThreadSafe()) {
                    for (Object row : this.visualLayer) {
                        this.draw(g, row);
                    }
                } else {
                    int nTasks = Math.min(Runtime.Companion.getRuntime().availableProcessors(), this.visualLayer.getObjectCount());
                    int nRowsPerTask = this.visualLayer.getObjectCount() / nTasks;
                    List todo = new ArrayList(nTasks);
                    for (int nTask = 0; nTask < nTasks; ++nTask) {
                        int fromRow = nTask * nRowsPerTask;
                        int toRow = nTask < nTasks - 1 ? fromRow + nRowsPerTask : this.visualLayer.getObjectCount();
                        todo.add(new Callable<Object>(this, fromRow, toRow, g){
                            final /* synthetic */ AbstractVisualLayerIDrawing this$0;
                            final /* synthetic */ int $fromRow;
                            final /* synthetic */ int $toRow;
                            final /* synthetic */ IGraphics $g;
                            {
                                this.this$0 = $receiver;
                                this.$fromRow = $fromRow;
                                this.$toRow = $toRow;
                                this.$g = $g;
                            }

                            @Nullable
                            public Object call() throws Exception {
                                for (T row : AbstractVisualLayerIDrawing.access$getVisualLayer$p(this.this$0).iterable(this.$fromRow, this.$toRow - 1)) {
                                    this.this$0.draw(this.$g, row);
                                }
                                return null;
                            }
                        });
                    }
                    try {
                        ExecutorService executorService = executor;
                        Intrinsics.checkNotNull((Object)executorService);
                        List answers = executorService.invokeAll((Collection)todo);
                        for (Future answer : answers) {
                            try {
                                answer.get();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        protected final void draw(@NotNull IGraphics g, Row row) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            ScatterPlotMatrixModel scatterPlotMatrixModel = AbstractScatterPlotMatrixComponent.this.getModel();
            Intrinsics.checkNotNull(scatterPlotMatrixModel);
            int n = scatterPlotMatrixModel.getAxisCount();
            for (int i = 0; i < n; ++i) {
                double d;
                ScatterPlotMatrixModel scatterPlotMatrixModel2 = AbstractScatterPlotMatrixComponent.this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel2);
                AxisModel xAxisModel = scatterPlotMatrixModel2.getAxisModel(i);
                ScatterPlotMatrixModel scatterPlotMatrixModel3 = AbstractScatterPlotMatrixComponent.this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel3);
                double x1Location = scatterPlotMatrixModel3.getLocation(xAxisModel);
                double x2Location = 0.0;
                ScatterPlotMatrixModel scatterPlotMatrixModel4 = AbstractScatterPlotMatrixComponent.this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel4);
                if (i + 1 < scatterPlotMatrixModel4.getAxisCount()) {
                    ScatterPlotMatrixModel scatterPlotMatrixModel5 = AbstractScatterPlotMatrixComponent.this.getModel();
                    Intrinsics.checkNotNull(scatterPlotMatrixModel5);
                    ScatterPlotMatrixModel scatterPlotMatrixModel6 = AbstractScatterPlotMatrixComponent.this.getModel();
                    Intrinsics.checkNotNull(scatterPlotMatrixModel6);
                    d = scatterPlotMatrixModel5.getLocation(scatterPlotMatrixModel6.getAxisModel(i + 1));
                } else {
                    d = 1.0;
                }
                x2Location = d;
                ScatterPlotMatrixModel scatterPlotMatrixModel7 = AbstractScatterPlotMatrixComponent.this.getModel();
                Intrinsics.checkNotNull(scatterPlotMatrixModel7);
                int n2 = scatterPlotMatrixModel7.getAxisCount();
                for (int j = 0; j < n2; ++j) {
                    double d2;
                    if (i == j) continue;
                    ScatterPlotMatrixModel scatterPlotMatrixModel8 = AbstractScatterPlotMatrixComponent.this.getModel();
                    Intrinsics.checkNotNull(scatterPlotMatrixModel8);
                    AxisModel yAxisModel = scatterPlotMatrixModel8.getAxisModel(j);
                    ScatterPlotMatrixModel scatterPlotMatrixModel9 = AbstractScatterPlotMatrixComponent.this.getModel();
                    Intrinsics.checkNotNull(scatterPlotMatrixModel9);
                    double y1Location = scatterPlotMatrixModel9.getLocation(yAxisModel);
                    double y2Location = 0.0;
                    ScatterPlotMatrixModel scatterPlotMatrixModel10 = AbstractScatterPlotMatrixComponent.this.getModel();
                    Intrinsics.checkNotNull(scatterPlotMatrixModel10);
                    if (j + 1 < scatterPlotMatrixModel10.getAxisCount()) {
                        ScatterPlotMatrixModel scatterPlotMatrixModel11 = AbstractScatterPlotMatrixComponent.this.getModel();
                        Intrinsics.checkNotNull(scatterPlotMatrixModel11);
                        ScatterPlotMatrixModel scatterPlotMatrixModel12 = AbstractScatterPlotMatrixComponent.this.getModel();
                        Intrinsics.checkNotNull(scatterPlotMatrixModel12);
                        d2 = scatterPlotMatrixModel11.getLocation(scatterPlotMatrixModel12.getAxisModel(j + 1));
                    } else {
                        d2 = 1.0;
                    }
                    y2Location = d2;
                    int x = (int)(x1Location * (double)AbstractScatterPlotMatrixComponent.this.getWidth());
                    int y = (int)(y1Location * (double)AbstractScatterPlotMatrixComponent.this.getHeight());
                    int width = (int)(x2Location * (double)AbstractScatterPlotMatrixComponent.this.getWidth()) - x;
                    int height = (int)(y2Location * (double)AbstractScatterPlotMatrixComponent.this.getHeight()) - y;
                    Point2D mp = AbstractScatterPlotMatrixComponent.this.getPoint(this.getLayer(), row, xAxisModel, yAxisModel, x, y, width, height);
                    if (mp == null) continue;
                    this.draw(g, mp, row);
                }
            }
        }

        public final int getLayer() {
            return 0;
        }

        public abstract void draw(@NotNull IGraphics var1, @NotNull Point2D var2, Row var3);

        public static final /* synthetic */ VisualLayer access$getVisualLayer$p(AbstractVisualLayerIDrawing $this) {
            return $this.visualLayer;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/macrofocus/high_d/scatterplotmatrix/AbstractScatterPlotMatrixComponent$Companion;", "", "()V", "MULTITHREADED", "", "executor", "Lcom/macrofocus/common/concurrent/ExecutorService;", "highd"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

