/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.distributions;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.distributions.AbstractDistributionsView;
import com.macrofocus.high_d.distributions.DefaultDistributionsComponent;
import com.macrofocus.high_d.distributions.DistributionsComponent;
import com.macrofocus.high_d.distributions.DistributionsModel;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.order.MutableVisibleOrder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.component.CPComponent;
import org.mkui.component.absolute.AbsoluteCPContainer;
import org.mkui.component.absolute.Layout;
import org.mkui.component.button.CPButton;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.molap.subset.DistributionDimension;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u0003*\u0004\b\u0003\u0010\u00042\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\u000f2\u000e\u0010\u0019\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eJ\u0018\u0010\u001a\u001a\u00020\u000f2\u000e\u0010\u0019\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eH\u0004J\b\u0010\u001b\u001a\u00020\u0017H\u0014J,\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J\u001f\u0010!\u001a\u0004\u0018\u00018\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\n\u0012\u0004\u0012\u00028\u0003\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0016J\u001f\u0010'\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010\"J\u0012\u0010(\u001a\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010+\u00a8\u0006."}, d2={"Lcom/macrofocus/high_d/distributions/DefaultDistributionsView;", "Row", "Column", "Value", "Bin", "Lcom/macrofocus/high_d/distributions/AbstractDistributionsView;", "<init>", "()V", "component", "Lorg/mkui/component/absolute/AbsoluteCPContainer;", "getComponent", "()Lorg/mkui/component/absolute/AbsoluteCPContainer;", "axisLabels", "", "Lcom/macrofocus/high_d/axis/AxisModel;", "Lorg/mkui/component/button/CPButton;", "distibutionsComponent", "Lcom/macrofocus/high_d/distributions/DistributionsComponent;", "getDistibutionsComponent", "()Lcom/macrofocus/high_d/distributions/DistributionsComponent;", "licenseModel", "Lcom/macrofocus/license/LicenseModel;", "runLayout", "", "getHeader", "axisModel", "createAxisHeaderView", "refresh", "getClosestDistribution", "Lorg/molap/subset/DistributionDimension;", "x", "", "y", "getClosestBin", "(II)Ljava/lang/Object;", "getBins", "", "rect", "Lorg/mkui/geom/Rectangle2D;", "getClosestRow", "setLicenseModel", "width", "getWidth", "()I", "height", "getHeight", "highd"})
@StabilityInferred(parameters=0)
public final class DefaultDistributionsView<Row, Column, Value, Bin>
extends AbstractDistributionsView<Row, Column, Value, Bin> {
    @NotNull
    private final AbsoluteCPContainer component = new AbsoluteCPContainer(new Layout(this){
        final /* synthetic */ DefaultDistributionsView<Row, Column, Value, Bin> this$0;
        {
            this.this$0 = $receiver;
        }

        public void layout(AbsoluteCPContainer container, double width, double height) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            DefaultDistributionsView.access$runLayout(this.this$0);
        }
    });
    @NotNull
    private final Map<AxisModel<?, ?>, CPButton> axisLabels = new HashMap();
    @NotNull
    private final DistributionsComponent<Row, Column, Value, Bin> distibutionsComponent = new DefaultDistributionsComponent(this);
    @Nullable
    private LicenseModel licenseModel;
    public static final int $stable = 8;

    public DefaultDistributionsView() {
        this.getComponent().addComponent(((DefaultDistributionsComponent)this.getDistibutionsComponent()).getComponent());
        this.setLicenseModel(this.licenseModel);
    }

    @NotNull
    public AbsoluteCPContainer getComponent() {
        return this.component;
    }

    @Override
    @NotNull
    protected DistributionsComponent<Row, Column, Value, Bin> getDistibutionsComponent() {
        return this.distibutionsComponent;
    }

    private final void runLayout() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            MutableVisibleOrder axisOrder;
            double headerMaximumHeight = 0.0;
            DistributionsModel distributionsModel = this.getModel();
            MutableVisibleOrder mutableVisibleOrder = distributionsModel != null && (distributionsModel = distributionsModel.getAxisGroupModel()) != null ? distributionsModel.getAxisOrder() : (axisOrder = null);
            if (axisOrder != null) {
                for (AxisModel axisModel : axisOrder.iterableAll()) {
                    if (axisModel == null) {
                        String string = "Required value was null.";
                        throw new IllegalStateException(string.toString());
                    }
                    CPButton header = this.getHeader(axisModel);
                    if (axisOrder.isVisible((Object)axisModel)) {
                        double d;
                        int i = axisOrder.indexOf((Object)axisModel);
                        DistributionsModel distributionsModel2 = this.getModel();
                        Intrinsics.checkNotNull(distributionsModel2);
                        double x1Location = distributionsModel2.getLocation(axisModel);
                        if (i + 1 < axisOrder.size()) {
                            DistributionsModel distributionsModel3 = this.getModel();
                            Intrinsics.checkNotNull(distributionsModel3);
                            d = distributionsModel3.getLocation((AxisModel)axisOrder.get(i + 1));
                        } else {
                            d = 1.0;
                        }
                        double x2Location = d;
                        double x = x1Location * (double)this.getWidth();
                        double y = 0.0;
                        double width = x2Location * (double)this.getWidth() - x;
                        double height = 20.0;
                        headerMaximumHeight = Math.max(height, headerMaximumHeight);
                        this.getComponent().setBounds((CPComponent)header, (Rectangle2D)new Rectangle((int)x, (int)y, (int)width, (int)height));
                        this.getComponent().setVisible((CPComponent)header, true);
                        continue;
                    }
                    this.getComponent().setVisible((CPComponent)header, false);
                }
                this.getComponent().setBounds(this.getDistibutionsComponent().getComponent(), (Rectangle2D)new Rectangle(0, (int)headerMaximumHeight, this.getWidth(), (int)((double)this.getHeight() - headerMaximumHeight)));
                this.getDistibutionsComponent().scheduleUpdate();
            }
        }
    }

    @NotNull
    public final CPButton getHeader(@NotNull AxisModel<?, ?> axisModel) {
        Intrinsics.checkNotNullParameter(axisModel, (String)"axisModel");
        if (!this.axisLabels.containsKey(axisModel)) {
            CPButton label = this.createAxisHeaderView(axisModel);
            this.axisLabels.put(axisModel, label);
            this.getComponent().addComponent((CPComponent)label);
        }
        CPButton cPButton = this.axisLabels.get(axisModel);
        Intrinsics.checkNotNull((Object)cPButton);
        return cPButton;
    }

    @NotNull
    protected final CPButton createAxisHeaderView(@NotNull AxisModel<?, ?> axisModel) {
        Intrinsics.checkNotNullParameter(axisModel, (String)"axisModel");
        CPButton button = new CPButton(null, (MutableProperty)new SimpleProperty((Object)axisModel.getName()), 1, null);
        return button;
    }

    @Override
    protected void refresh() {
        this.runLayout();
    }

    @Override
    @Nullable
    public DistributionDimension<Row, Value, Bin> getClosestDistribution(int x, int y) {
        Rectangle2D rectangle2D = this.getComponent().getBounds(this.getDistibutionsComponent().getComponent());
        Intrinsics.checkNotNull((Object)rectangle2D);
        Rectangle2D b = rectangle2D;
        if (b.contains((double)x, (double)y)) {
            return this.getDistibutionsComponent().getClosestDistribution((int)((double)x - b.getX()), (int)((double)y - b.getY()));
        }
        return null;
    }

    @Override
    @Nullable
    public Bin getClosestBin(int x, int y) {
        Rectangle2D rectangle2D = this.getComponent().getBounds(this.getDistibutionsComponent().getComponent());
        Intrinsics.checkNotNull((Object)rectangle2D);
        Rectangle2D b = rectangle2D;
        if (b.contains((double)x, (double)y)) {
            return this.getDistibutionsComponent().getClosestBin((int)((double)x - b.getX()), (int)((double)y - b.getY()));
        }
        return null;
    }

    @Override
    @Nullable
    public List<Bin> getBins(@NotNull Rectangle2D rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Rectangle2D rectangle2D = this.getComponent().getBounds(this.getDistibutionsComponent().getComponent());
        Intrinsics.checkNotNull((Object)rectangle2D);
        Rectangle2D b = rectangle2D;
        if (b.contains(rect.getX(), rect.getY())) {
            return this.getDistibutionsComponent().getBins((Rectangle2D)new Rectangle2D.Double(rect.getX() - b.getX(), rect.getY() - b.getY(), rect.getWidth(), rect.getHeight()));
        }
        return null;
    }

    @Override
    @Nullable
    public Row getClosestRow(int x, int y) {
        Rectangle2D rectangle2D = this.getComponent().getBounds(this.getDistibutionsComponent().getComponent());
        Intrinsics.checkNotNull((Object)rectangle2D);
        Rectangle2D b = rectangle2D;
        if (b.contains((double)x, (double)y)) {
            return this.getDistibutionsComponent().getClosestRow((int)((double)x - b.getX()), (int)((double)y - b.getY()));
        }
        return null;
    }

    @Override
    public void setLicenseModel(@Nullable LicenseModel licenseModel) {
    }

    public final int getWidth() {
        return (int)this.getComponent().getWidth();
    }

    public final int getHeight() {
        return (int)this.getComponent().getHeight();
    }

    public static final /* synthetic */ void access$runLayout(DefaultDistributionsView $this) {
        $this.runLayout();
    }
}

