/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates.geometry;

import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesView;
import com.macrofocus.high_d.parallelcoordinates.layout.ParallelCoordinatesLayout;
import com.macrofocus.order.MutableVisibleOrder;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.GeneralPath;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.geom.curve.CatmullRomSpline;
import org.mkui.geom.curve.ControlPath;
import org.mkui.geom.curve.Curve;
import org.mkui.geom.curve.GroupIterator;
import org.mkui.geom.curve.MultiPath;
import org.mkui.geom.curve.Point;
import org.mkui.geom.curve.ShapeMultiPath;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Je\u0010\u0007\u001a\u0004\u0018\u00010\b\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u0002H\t2\u0006\u0010\u0013\u001a\u00020\u0010H&\u00a2\u0006\u0002\u0010\u0014j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0016"}, d2={"Lcom/macrofocus/high_d/parallelcoordinates/geometry/Geometry;", "", "<init>", "(Ljava/lang/String;I)V", "Polylines", "Steps", "Polycurves", "createGeometry", "Lorg/mkui/geom/Shape;", "R", "C", "view", "Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesView;", "model", "Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesModel;", "fullHeight", "", "layer", "row", "level", "(Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesView;Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesModel;IILjava/lang/Object;I)Lorg/mkui/geom/Shape;", "Companion", "highd"})
public abstract class Geometry
extends Enum<Geometry> {
    @NotNull
    public static final Companion Companion;
    public static final /* enum */ Geometry Polylines;
    public static final /* enum */ Geometry Steps;
    public static final /* enum */ Geometry Polycurves;
    private static final /* synthetic */ Geometry[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private Geometry() {
    }

    @Nullable
    public abstract <R, C> Shape createGeometry(@NotNull ParallelCoordinatesView<R, C> var1, @Nullable ParallelCoordinatesModel<R, C> var2, int var3, int var4, R var5, int var6);

    public static Geometry[] values() {
        return (Geometry[])$VALUES.clone();
    }

    public static Geometry valueOf(String value) {
        return Enum.valueOf(Geometry.class, value);
    }

    @NotNull
    public static EnumEntries<Geometry> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ Geometry(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        Polylines = new Polylines("Polylines", 0);
        Steps = new Steps("Steps", 1);
        Polycurves = new Polycurves("Polycurves", 2);
        $VALUES = geometryArray = new Geometry[]{Geometry.Polylines, Geometry.Steps, Geometry.Polycurves};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/macrofocus/high_d/parallelcoordinates/geometry/Geometry$Companion;", "", "<init>", "()V", "getY", "", "fullHeight", "", "height", "offset", "value", "axisModel", "Lcom/macrofocus/high_d/axis/AxisModel;", "createPoint2", "Lorg/mkui/geom/curve/Point;", "x", "y", "highd"})
    public static final class Companion {
        private Companion() {
        }

        public final double getY(int fullHeight, int height, int offset, double value, @NotNull AxisModel<?, ?> axisModel) {
            double d;
            Intrinsics.checkNotNullParameter(axisModel, (String)"axisModel");
            if (!axisModel.isDegenerate()) {
                double d2 = fullHeight - 1;
                double d3 = height - 1;
                Double d4 = axisModel.getNormalizedValue(value);
                Intrinsics.checkNotNull((Object)d4);
                d = d2 - d3 * d4 - (double)offset;
            } else {
                d = (double)fullHeight - (double)height * 0.5 - (double)offset;
            }
            return d;
        }

        private final Point createPoint2(double x, double y) {
            double[] dArray = new double[]{x, y};
            double[] arr = dArray;
            return new Point(arr){
                final /* synthetic */ double[] $arr;
                {
                    this.$arr = $arr;
                }

                public double[] getLocation() {
                    return this.$arr;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001Je\u0010\u0002\u001a\u0004\u0018\u00010\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u0002H\u00042\u0006\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"com/macrofocus/high_d/parallelcoordinates/geometry/Geometry.Polycurves", "Lcom/macrofocus/high_d/parallelcoordinates/geometry/Geometry;", "createGeometry", "Lorg/mkui/geom/Shape;", "R", "C", "view", "Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesView;", "model", "Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesModel;", "fullHeight", "", "layer", "row", "level", "(Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesView;Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesModel;IILjava/lang/Object;I)Lorg/mkui/geom/Shape;", "highd"})
    static final class Polycurves
    extends Geometry {
        /*
         * WARNING - void declaration
         */
        Polycurves() {
            void var1_1;
        }

        @Override
        @Nullable
        public <R, C> Shape createGeometry(@NotNull ParallelCoordinatesView<R, C> view, @Nullable ParallelCoordinatesModel<R, C> model, int fullHeight, int layer, R row, int level) {
            Intrinsics.checkNotNullParameter(view, (String)"view");
            double x = 0.0;
            double y = 0.0;
            ControlPath curves = new ControlPath();
            ControlPath cp = null;
            boolean previousAvailable = false;
            ParallelCoordinatesLayout<R, C> layout = view.getParallelCoordinatesLayout();
            for (Object axisGroup : layout.getAxisGroups(level)) {
                MutableVisibleOrder mutableVisibleOrder = axisGroup.getAxisOrder();
                Intrinsics.checkNotNull((Object)mutableVisibleOrder);
                for (AxisModel axisModel : mutableVisibleOrder) {
                    boolean currentAvailable;
                    Rectangle2D trackBounds = layout.getTrackBounds((AxisGroupModel<R, C>)axisGroup, (AxisModel<R, C>)axisModel);
                    x = (double)view.getAxisX((AxisGroupModel<R, C>)axisGroup, (AxisModel<R, C>)axisModel) + (double)layout.getAxisPreferredWidth() / 2.0;
                    Number value = axisModel.getValue(layer, row);
                    boolean bl = currentAvailable = value != null;
                    if (currentAvailable) {
                        int height = (int)trackBounds.getHeight();
                        int n = layout.getAxisAfterTrackGap();
                        Number number = value;
                        Intrinsics.checkNotNull((Object)number);
                        y = Companion.getY(fullHeight, height, n, number.doubleValue(), axisModel);
                        if (cp != null) {
                            if (previousAvailable) {
                                cp.addPoint(Companion.createPoint2(x, y));
                            } else {
                                System.out.println((Object)"Error");
                            }
                        } else {
                            cp = new ControlPath();
                            cp.addPoint(Companion.createPoint2(x, y));
                            cp.addPoint(Companion.createPoint2(x, y));
                        }
                        previousAvailable = currentAvailable;
                        continue;
                    }
                    if (cp != null) {
                        cp.addPoint(Companion.createPoint2(x, y));
                        int[] nArray = new int[]{0, cp.numPoints() - 1};
                        CatmullRomSpline cardinalSpline = new CatmullRomSpline(cp, new GroupIterator(nArray));
                        curves.addCurve((Curve)cardinalSpline);
                    }
                    cp = null;
                }
            }
            if (cp != null) {
                Object axisGroup;
                cp.addPoint(Companion.createPoint2(x, y));
                axisGroup = new int[2];
                axisGroup[0] = (AxisGroupModel<R, C>)false;
                axisGroup[1] = (AxisGroupModel<R, C>)(cp.numPoints() - 1);
                CatmullRomSpline cardinalSpline = new CatmullRomSpline(cp, new GroupIterator(axisGroup));
                curves.addCurve((Curve)cardinalSpline);
            }
            int dimension = 2;
            ShapeMultiPath mp = new ShapeMultiPath(dimension);
            mp.setFlatness(1.0);
            int n = curves.numCurves();
            for (int i = 0; i < n; ++i) {
                Curve curve = curves.getCurve(i);
                curve.appendTo((MultiPath)mp);
            }
            return (Shape)mp;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001Je\u0010\u0002\u001a\u0004\u0018\u00010\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u0002H\u00042\u0006\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"com/macrofocus/high_d/parallelcoordinates/geometry/Geometry.Polylines", "Lcom/macrofocus/high_d/parallelcoordinates/geometry/Geometry;", "createGeometry", "Lorg/mkui/geom/Shape;", "R", "C", "view", "Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesView;", "model", "Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesModel;", "fullHeight", "", "layer", "row", "level", "(Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesView;Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesModel;IILjava/lang/Object;I)Lorg/mkui/geom/Shape;", "highd"})
    static final class Polylines
    extends Geometry {
        /*
         * WARNING - void declaration
         */
        Polylines() {
            void var1_1;
        }

        @Override
        @Nullable
        public <R, C> Shape createGeometry(@NotNull ParallelCoordinatesView<R, C> view, @Nullable ParallelCoordinatesModel<R, C> model, int fullHeight, int layer, R row, int level) {
            Intrinsics.checkNotNullParameter(view, (String)"view");
            GeneralPath path = null;
            boolean previousAvailable = false;
            ParallelCoordinatesLayout<R, C> layout = view.getParallelCoordinatesLayout();
            for (AxisGroupModel<R, C> axisGroup : layout.getAxisGroups(level)) {
                MutableVisibleOrder mutableVisibleOrder = axisGroup.getAxisOrder();
                Intrinsics.checkNotNull((Object)mutableVisibleOrder);
                for (AxisModel axisModel : mutableVisibleOrder) {
                    boolean currentAvailable;
                    Rectangle2D trackBounds = layout.getTrackBounds(axisGroup, axisModel);
                    int x = (int)trackBounds.getX() + layout.getAxisPreferredWidth() / 2;
                    Number value = axisModel.getValue(layer, row);
                    boolean bl = currentAvailable = value != null;
                    if (currentAvailable) {
                        int height = (int)trackBounds.getHeight();
                        int n = layout.getAxisAfterTrackGap();
                        Number number = value;
                        Intrinsics.checkNotNull((Object)number);
                        double y = Companion.getY(fullHeight, height, n, number.doubleValue(), axisModel);
                        if (path != null) {
                            if (previousAvailable) {
                                path.lineTo((double)x, y);
                            } else {
                                path.moveTo((double)(x - 1), y);
                                path.lineTo((double)x, y);
                            }
                        } else {
                            path = new GeneralPath();
                            path.moveTo((double)x, y);
                        }
                    }
                    previousAvailable = currentAvailable;
                }
            }
            return (Shape)path;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001Je\u0010\u0002\u001a\u0004\u0018\u00010\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u0002H\u00042\u0006\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"com/macrofocus/high_d/parallelcoordinates/geometry/Geometry.Steps", "Lcom/macrofocus/high_d/parallelcoordinates/geometry/Geometry;", "createGeometry", "Lorg/mkui/geom/Shape;", "R", "C", "view", "Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesView;", "model", "Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesModel;", "fullHeight", "", "layer", "row", "level", "(Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesView;Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesModel;IILjava/lang/Object;I)Lorg/mkui/geom/Shape;", "highd"})
    static final class Steps
    extends Geometry {
        /*
         * WARNING - void declaration
         */
        Steps() {
            void var1_1;
        }

        @Override
        @Nullable
        public <R, C> Shape createGeometry(@NotNull ParallelCoordinatesView<R, C> view, @Nullable ParallelCoordinatesModel<R, C> model, int fullHeight, int layer, R row, int level) {
            Intrinsics.checkNotNullParameter(view, (String)"view");
            GeneralPath path = null;
            boolean previousAvailable = false;
            ParallelCoordinatesLayout<R, C> layout = view.getParallelCoordinatesLayout();
            for (AxisGroupModel<R, C> axisGroup : layout.getAxisGroups(level)) {
                MutableVisibleOrder mutableVisibleOrder = axisGroup.getAxisOrder();
                Intrinsics.checkNotNull((Object)mutableVisibleOrder);
                for (AxisModel axisModel : mutableVisibleOrder) {
                    boolean currentAvailable;
                    Rectangle2D trackBounds = layout.getTrackBounds(axisGroup, axisModel);
                    int x = view.getAxisX(axisGroup, axisModel);
                    Number value = axisModel.getValue(layer, row);
                    boolean bl = currentAvailable = value != null;
                    if (currentAvailable) {
                        int height = (int)trackBounds.getHeight();
                        int n = layout.getAxisAfterTrackGap();
                        Number number = value;
                        Intrinsics.checkNotNull((Object)number);
                        double y = Companion.getY(fullHeight, height, n, number.doubleValue(), axisModel);
                        if (path != null) {
                            if (previousAvailable) {
                                path.lineTo((double)x, y);
                            } else {
                                path.moveTo((double)x, y);
                            }
                            path.lineTo((double)x + (double)layout.getAxisPreferredWidth(), y);
                        } else {
                            path = new GeneralPath();
                            path.moveTo((double)x, y);
                            path.lineTo((double)x + (double)layout.getAxisPreferredWidth(), y);
                        }
                    }
                    previousAvailable = currentAvailable;
                }
            }
            return (Shape)path;
        }
    }
}

