/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates.layout;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.hierarchy.Hierarchy;
import com.macrofocus.high_d.axis.Alignment;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.locations.AxisLocations;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesView;
import com.macrofocus.high_d.parallelcoordinates.layout.DefaultParallelCoordinatesLayoutEngine;
import com.macrofocus.high_d.parallelcoordinates.layout.ParallelCoordinatesLayout;
import com.macrofocus.high_d.parallelcoordinates.layout.ParallelCoordinatesLayoutEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Rectangle2D;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0001!B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J \u0010\u000e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J.\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00102\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0016J \u0010\u0017\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J\u001e\u0010\u0018\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00100\u001a0\u0019JT\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00110\u000f2\u001e\u0010\u001c\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00100\u001a0\u00192\u001e\u0010\u001d\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J6\u0010\u001e\u001a\u00020\u000b2\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00100 2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/macrofocus/high_d/parallelcoordinates/layout/DefaultParallelCoordinatesLayoutEngine;", "Row", "Column", "Lcom/macrofocus/high_d/parallelcoordinates/layout/ParallelCoordinatesLayoutEngine;", "view", "Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesView;", "<init>", "(Lcom/macrofocus/high_d/parallelcoordinates/ParallelCoordinatesView;)V", "doLayout", "Lcom/macrofocus/high_d/parallelcoordinates/layout/ParallelCoordinatesLayout;", "axisPreferredWidth", "", "axisBeforeTrackGap", "axisAfterTrackGap", "doHorizontalLayout", "", "Lcom/macrofocus/high_d/axis/group/AxisGroupModel;", "Lorg/mkui/geom/Rectangle2D;", "getPosition", "", "axisGroup", "axisModel", "Lcom/macrofocus/high_d/axis/AxisModel;", "doVerticalLayout", "doAxisGroupsPerLevel", "", "", "doLevelsLayout", "axisGroupsPerLevels", "verticalLayout", "getLevel", "hierarchy", "Lcom/macrofocus/hierarchy/Hierarchy;", "VerticalLayoutSize", "highd"})
@StabilityInferred(parameters=0)
public final class DefaultParallelCoordinatesLayoutEngine<Row, Column>
implements ParallelCoordinatesLayoutEngine<Row, Column> {
    @NotNull
    private final ParallelCoordinatesView<Row, Column> view;
    public static final int $stable = 8;

    public DefaultParallelCoordinatesLayoutEngine(@NotNull ParallelCoordinatesView<Row, Column> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        this.view = view;
    }

    @Override
    @NotNull
    public ParallelCoordinatesLayout<Row, Column> doLayout(int axisPreferredWidth, int axisBeforeTrackGap, int axisAfterTrackGap) {
        Map<AxisGroupModel<Row, Column>, Rectangle2D> verticalLayout = this.doVerticalLayout();
        Map<AxisGroupModel<Row, Column>, Rectangle2D> horizontalLayout = this.doHorizontalLayout();
        List<List<AxisGroupModel<Row, Column>>> axisGroupsPerLevels = this.doAxisGroupsPerLevel();
        Map<Integer, Rectangle2D> levelsLayout = this.doLevelsLayout(axisGroupsPerLevels, verticalLayout);
        return new ParallelCoordinatesLayout<Row, Column>(axisPreferredWidth, axisBeforeTrackGap, axisAfterTrackGap, verticalLayout, horizontalLayout, this, levelsLayout, axisGroupsPerLevels){
            final /* synthetic */ int $axisPreferredWidth;
            final /* synthetic */ int $axisBeforeTrackGap;
            final /* synthetic */ int $axisAfterTrackGap;
            final /* synthetic */ Map<AxisGroupModel<Row, Column>, Rectangle2D> $verticalLayout;
            final /* synthetic */ Map<AxisGroupModel<Row, Column>, Rectangle2D> $horizontalLayout;
            final /* synthetic */ DefaultParallelCoordinatesLayoutEngine<Row, Column> this$0;
            final /* synthetic */ Map<Integer, Rectangle2D> $levelsLayout;
            final /* synthetic */ List<List<AxisGroupModel<Row, Column>>> $axisGroupsPerLevels;
            {
                this.$axisPreferredWidth = $axisPreferredWidth;
                this.$axisBeforeTrackGap = $axisBeforeTrackGap;
                this.$axisAfterTrackGap = $axisAfterTrackGap;
                this.$verticalLayout = $verticalLayout;
                this.$horizontalLayout = $horizontalLayout;
                this.this$0 = $receiver;
                this.$levelsLayout = $levelsLayout;
                this.$axisGroupsPerLevels = $axisGroupsPerLevels;
            }

            public int getAxisPreferredWidth() {
                return this.$axisPreferredWidth;
            }

            public int getAxisBeforeTrackGap() {
                return this.$axisBeforeTrackGap;
            }

            public int getAxisAfterTrackGap() {
                return this.$axisAfterTrackGap;
            }

            public Rectangle2D getBounds(AxisGroupModel<Row, Column> axisGroup) {
                Intrinsics.checkNotNullParameter(axisGroup, (String)"axisGroup");
                Rectangle2D rectangle2D = this.$verticalLayout.get(axisGroup);
                Intrinsics.checkNotNull((Object)rectangle2D);
                Rectangle2D rectangle2D2 = this.$horizontalLayout.get(axisGroup);
                Intrinsics.checkNotNull((Object)rectangle2D2);
                return rectangle2D.createIntersection(rectangle2D2);
            }

            public Rectangle2D getBounds(AxisGroupModel<Row, Column> axisGroup, AxisModel<Row, Column> axisModel) {
                Intrinsics.checkNotNullParameter(axisGroup, (String)"axisGroup");
                Intrinsics.checkNotNullParameter(axisModel, (String)"axisModel");
                Rectangle2D groupBounds = this.getBounds(axisGroup);
                double position = this.this$0.getPosition(axisGroup, axisModel);
                double x = groupBounds.getX() + groupBounds.getWidth() * position;
                double width = 0.0;
                switch (doLayout.WhenMappings.$EnumSwitchMapping$0[((Alignment)DefaultParallelCoordinatesLayoutEngine.access$getView$p(this.this$0).getAlignment().getValue()).ordinal()]) {
                    case 1: {
                        width = groupBounds.getWidth() / (double)axisGroup.getVisibleAxisCount();
                        break;
                    }
                    case 2: {
                        width = groupBounds.getWidth() / (double)axisGroup.getVisibleAxisCount();
                        break;
                    }
                    case 3: {
                        width = groupBounds.getWidth() / (double)(axisGroup.getVisibleAxisCount() - 1);
                        break;
                    }
                    case 4: {
                        width = groupBounds.getWidth() / (double)axisGroup.getVisibleAxisCount();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return (Rectangle2D)new Rectangle2D.Double(x, groupBounds.getY(), width, groupBounds.getHeight());
            }

            /*
             * Enabled aggressive block sorting
             */
            public Rectangle2D getHeaderBounds(AxisGroupModel<Row, Column> axisGroup) {
                double d;
                Intrinsics.checkNotNullParameter(axisGroup, (String)"axisGroup");
                Rectangle2D bounds = this.getBounds(axisGroup);
                double d2 = bounds.getX();
                double d3 = bounds.getY();
                double d4 = bounds.getWidth();
                if (DefaultParallelCoordinatesLayoutEngine.access$getView$p(this.this$0).getAxisGroupView(axisGroup) != null) {
                    ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel = DefaultParallelCoordinatesLayoutEngine.access$getView$p(this.this$0).getModel();
                    Intrinsics.checkNotNull(parallelCoordinatesModel);
                    if (!parallelCoordinatesModel.getAxisHierarchy().getAxisGroupHierarchy().isRoot(axisGroup)) {
                        d = DefaultParallelCoordinatesLayoutEngine.access$getView$p(this.this$0).getHeaderAxisGroupMaximumHeight();
                        return (Rectangle2D)new Rectangle2D.Double(d2, d3, d4, d);
                    }
                }
                d = 0.0;
                return (Rectangle2D)new Rectangle2D.Double(d2, d3, d4, d);
            }

            public Rectangle2D getHeaderBounds(AxisGroupModel<Row, Column> axisGroup, AxisModel<Row, Column> axisModel) {
                Intrinsics.checkNotNullParameter(axisGroup, (String)"axisGroup");
                Intrinsics.checkNotNullParameter(axisModel, (String)"axisModel");
                Rectangle2D axisGroupBounds = this.getHeaderBounds(axisGroup);
                Rectangle2D axisBounds = this.getBounds(axisGroup, axisModel);
                switch (doLayout.WhenMappings.$EnumSwitchMapping$0[((Alignment)DefaultParallelCoordinatesLayoutEngine.access$getView$p(this.this$0).getAlignment().getValue()).ordinal()]) {
                    case 1: {
                        return (Rectangle2D)new Rectangle2D.Double(axisBounds.getX(), axisGroupBounds.getMaxY(), axisBounds.getWidth(), (double)DefaultParallelCoordinatesLayoutEngine.access$getView$p(this.this$0).getHeaderAxisMaximumHeight());
                    }
                    case 2: {
                        return (Rectangle2D)new Rectangle2D.Double(axisBounds.getX() - axisBounds.getWidth() / 2.0, axisGroupBounds.getMaxY(), axisBounds.getWidth(), (double)DefaultParallelCoordinatesLayoutEngine.access$getView$p(this.this$0).getHeaderAxisMaximumHeight());
                    }
                    case 3: {
                        double shift = 0.0;
                        double width = 0.0;
                        double p = this.this$0.getPosition(axisGroup, axisModel);
                        if (p == 0.0) {
                            shift = 0.0;
                            width = axisBounds.getWidth() / 2.0;
                        } else if (p == 1.0) {
                            shift = axisBounds.getWidth() / 2.0;
                            width = axisBounds.getWidth() / 2.0;
                        } else {
                            shift = axisBounds.getWidth() / 2.0;
                            width = axisBounds.getWidth();
                        }
                        return (Rectangle2D)new Rectangle2D.Double(axisBounds.getX() - shift, axisGroupBounds.getMaxY(), width, (double)DefaultParallelCoordinatesLayoutEngine.access$getView$p(this.this$0).getHeaderAxisMaximumHeight());
                    }
                    case 4: {
                        return (Rectangle2D)new Rectangle2D.Double(axisBounds.getX() - axisBounds.getWidth(), axisGroupBounds.getMaxY(), axisBounds.getWidth(), (double)DefaultParallelCoordinatesLayoutEngine.access$getView$p(this.this$0).getHeaderAxisMaximumHeight());
                    }
                }
                throw new NoWhenBranchMatchedException();
            }

            public Rectangle2D getSliderBounds(AxisGroupModel<Row, Column> axisGroup, AxisModel<Row, Column> axisModel) {
                Intrinsics.checkNotNullParameter(axisGroup, (String)"axisGroup");
                Intrinsics.checkNotNullParameter(axisModel, (String)"axisModel");
                Rectangle2D rectangle2D = this.getHeaderBounds(axisGroup, axisModel);
                Intrinsics.checkNotNull((Object)rectangle2D);
                Rectangle2D headerBounds = rectangle2D;
                Rectangle2D axisBounds = this.getBounds(axisGroup, axisModel);
                switch (doLayout.WhenMappings.$EnumSwitchMapping$0[((Alignment)DefaultParallelCoordinatesLayoutEngine.access$getView$p(this.this$0).getAlignment().getValue()).ordinal()]) {
                    case 1: {
                        return (Rectangle2D)new Rectangle2D.Double(axisBounds.getX(), headerBounds.getMaxY(), (double)this.$axisPreferredWidth, axisBounds.getHeight() - (headerBounds.getMaxY() - axisBounds.getY()));
                    }
                    case 2: {
                        return (Rectangle2D)new Rectangle2D.Double(axisBounds.getX() - (double)this.$axisPreferredWidth / 2.0, headerBounds.getMaxY(), (double)this.$axisPreferredWidth, axisBounds.getHeight() - (headerBounds.getMaxY() - axisBounds.getY()));
                    }
                    case 3: {
                        int shift = 0;
                        shift = axisBounds.getX() == 0.0 ? 0 : this.$axisPreferredWidth;
                        return (Rectangle2D)new Rectangle2D.Double(axisBounds.getX() - (double)shift, headerBounds.getMaxY(), (double)this.$axisPreferredWidth, axisBounds.getHeight() - (headerBounds.getMaxY() - axisBounds.getY()));
                    }
                    case 4: {
                        return (Rectangle2D)new Rectangle2D.Double(axisBounds.getX() - (double)this.$axisPreferredWidth, headerBounds.getMaxY(), (double)this.$axisPreferredWidth, axisBounds.getHeight() - (headerBounds.getMaxY() - axisBounds.getY()));
                    }
                }
                throw new NoWhenBranchMatchedException();
            }

            public Rectangle2D getTrackBounds(AxisGroupModel<Row, Column> axisGroup, AxisModel<Row, Column> axisModel) {
                Intrinsics.checkNotNullParameter(axisGroup, (String)"axisGroup");
                Intrinsics.checkNotNullParameter(axisModel, (String)"axisModel");
                Rectangle2D rectangle2D = this.getSliderBounds(axisGroup, axisModel);
                Intrinsics.checkNotNull((Object)rectangle2D);
                Rectangle2D sliderBounds = rectangle2D;
                return (Rectangle2D)new Rectangle2D.Double(sliderBounds.getX(), sliderBounds.getY() + (double)this.$axisBeforeTrackGap, sliderBounds.getWidth(), sliderBounds.getHeight() - (double)this.$axisBeforeTrackGap - (double)this.$axisAfterTrackGap);
            }

            public Rectangle2D getLevelBounds(int level) {
                Rectangle2D rectangle2D = this.$levelsLayout.get(level);
                Intrinsics.checkNotNull((Object)rectangle2D);
                return rectangle2D;
            }

            public int getLevelCount() {
                return this.$axisGroupsPerLevels.size();
            }

            public Iterable<AxisGroupModel<Row, Column>> getAxisGroups(int level) {
                return this.$axisGroupsPerLevels.get(level);
            }
        };
    }

    private final Map<AxisGroupModel<Row, Column>, Rectangle2D> doHorizontalLayout() {
        ParallelCoordinatesModel<Row, Column> model;
        Map horizontalLayout = new HashMap();
        ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel = model = this.view.getModel();
        Intrinsics.checkNotNull(parallelCoordinatesModel);
        Hierarchy hierarchy = parallelCoordinatesModel.getAxisHierarchy().getAxisGroupHierarchy();
        int sumAxisCount = 0;
        int sumRelativeCount = 0;
        int sumFixedCount = 0;
        int sumFixed = 0;
        for (AxisGroupModel axisGroup : hierarchy.leavesIterator()) {
            sumAxisCount += axisGroup.getVisibleAxisCount();
            if (axisGroup.isCollapsed()) {
                sumFixed += axisGroup.getVisibleAxisCount() * 4;
                sumFixedCount += axisGroup.getVisibleAxisCount();
                continue;
            }
            sumRelativeCount += axisGroup.getVisibleAxisCount();
        }
        double x = 0.0;
        for (AxisGroupModel axisGroup : hierarchy.leavesIterator()) {
            double width = 0.0;
            width = axisGroup.isCollapsed() ? (double)axisGroup.getVisibleAxisCount() * 4.0 : (double)((this.view.getWidth() - sumFixed) * axisGroup.getVisibleAxisCount()) / (double)(sumAxisCount - sumFixedCount);
            Rectangle2D.Double value = new Rectangle2D.Double(x, 0.0, width, (double)this.view.getHeight());
            horizontalLayout.put(axisGroup, value);
            x += width;
        }
        for (AxisGroupModel axisGroup : hierarchy.depthFirstIterator()) {
            AxisGroupModel parent = (AxisGroupModel)hierarchy.getParent((Object)axisGroup);
            if (parent == null) continue;
            Rectangle2D groupBounds = (Rectangle2D)horizontalLayout.get(axisGroup);
            if (!horizontalLayout.containsKey(parent)) {
                Rectangle2D rectangle2D = groupBounds;
                Intrinsics.checkNotNull((Object)rectangle2D);
                horizontalLayout.put(parent, rectangle2D);
                continue;
            }
            Object v = horizontalLayout.get(parent);
            Intrinsics.checkNotNull(v);
            Rectangle2D rectangle2D = (Rectangle2D)v;
            Rectangle2D rectangle2D2 = groupBounds;
            Intrinsics.checkNotNull((Object)rectangle2D2);
            horizontalLayout.put(parent, rectangle2D.createUnion(rectangle2D2));
        }
        return horizontalLayout;
    }

    public final double getPosition(@NotNull AxisGroupModel<Row, Column> axisGroup, @NotNull AxisModel<Row, Column> axisModel) {
        Intrinsics.checkNotNullParameter(axisGroup, (String)"axisGroup");
        Intrinsics.checkNotNullParameter(axisModel, (String)"axisModel");
        ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel = this.view.getModel();
        Intrinsics.checkNotNull(parallelCoordinatesModel);
        AxisLocations<Row, Column> axisLocations = parallelCoordinatesModel.getAxisLocations(axisGroup);
        Intrinsics.checkNotNull(axisLocations);
        return axisLocations.getLocation((Alignment)this.view.getAlignment().getValue(), axisModel);
    }

    private final Map<AxisGroupModel<Row, Column>, Rectangle2D> doVerticalLayout() {
        Map verticalLayout = new HashMap();
        ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel = this.view.getModel();
        Intrinsics.checkNotNull(parallelCoordinatesModel);
        ParallelCoordinatesModel<Row, Column> model = parallelCoordinatesModel;
        Hierarchy hierarchy = model.getAxisHierarchy().getAxisGroupHierarchy();
        int depth = hierarchy.getDepth();
        List layoutSizes = new ArrayList(depth + 1);
        int n = depth + 1;
        for (int i = 0; i < n; ++i) {
            layoutSizes.add(new VerticalLayoutSize());
        }
        for (AxisGroupModel axisGroup : hierarchy.breadthFirstIterator()) {
            int level = this.getLevel(hierarchy, axisGroup);
            VerticalLayoutSize layoutSize = (VerticalLayoutSize)layoutSizes.get(level);
            layoutSize.setRelative(axisGroup.getVisibleAxisCount() == 0 ? 0.0 : 1.0);
            layoutSize.setFixed(hierarchy.isRoot((Object)axisGroup) ? 0 : Math.max(layoutSize.getFixed(), 18));
        }
        int sumFixed = 0;
        double sumRelative = 0.0;
        for (VerticalLayoutSize layoutSize : layoutSizes) {
            sumFixed += layoutSize.getFixed();
            sumRelative += layoutSize.getRelative();
        }
        double remainingHeigh = this.view.getHeight() - sumFixed;
        double y = 0.0;
        for (VerticalLayoutSize layoutSize : layoutSizes) {
            layoutSize.setY(y);
            layoutSize.setHeight((double)layoutSize.getFixed() + remainingHeigh * layoutSize.getRelative() / sumRelative);
            y += (double)((int)layoutSize.getHeight());
        }
        for (AxisGroupModel axisGroup : hierarchy.breadthFirstIterator()) {
            int level = this.getLevel(hierarchy, axisGroup);
            VerticalLayoutSize layoutSize = (VerticalLayoutSize)layoutSizes.get(level);
            verticalLayout.put(axisGroup, new Rectangle2D.Double(0.0, layoutSize.getY(), (double)this.view.getWidth(), layoutSize.getHeight()));
        }
        return verticalLayout;
    }

    @NotNull
    public final List<List<AxisGroupModel<Row, Column>>> doAxisGroupsPerLevel() {
        List axisGroupsPerLevels = null;
        ParallelCoordinatesModel<Row, Column> parallelCoordinatesModel = this.view.getModel();
        Intrinsics.checkNotNull(parallelCoordinatesModel);
        ParallelCoordinatesModel<Row, Column> model = parallelCoordinatesModel;
        Hierarchy hierarchy = model.getAxisHierarchy().getAxisGroupHierarchy();
        int depth = hierarchy.getDepth();
        axisGroupsPerLevels = new ArrayList(depth + 1);
        int n = depth + 1;
        for (int i = 0; i < n; ++i) {
            ((ArrayList)axisGroupsPerLevels).add(new ArrayList());
        }
        for (AxisGroupModel axisGroup : hierarchy.breadthFirstIterator()) {
            int level = this.getLevel(hierarchy, axisGroup);
            Object e = ((ArrayList)axisGroupsPerLevels).get(level);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            List axisGroups = (List)e;
            axisGroups.add(axisGroup);
        }
        return axisGroupsPerLevels;
    }

    private final Map<Integer, Rectangle2D> doLevelsLayout(List<? extends List<AxisGroupModel<Row, Column>>> axisGroupsPerLevels, Map<AxisGroupModel<Row, Column>, ? extends Rectangle2D> verticalLayout) {
        Map levelsLayout = new HashMap();
        int n = ((Collection)axisGroupsPerLevels).size();
        for (int l = 0; l < n; ++l) {
            List<AxisGroupModel<Row, Column>> axisGroups = axisGroupsPerLevels.get(l);
            for (AxisGroupModel<Row, Column> axisGroup : axisGroups) {
                if (levelsLayout.containsKey(l)) {
                    Object v = levelsLayout.get(l);
                    Intrinsics.checkNotNull(v);
                    Rectangle2D rectangle2D = (Rectangle2D)v;
                    Rectangle2D rectangle2D2 = verticalLayout.get(axisGroup);
                    Intrinsics.checkNotNull((Object)rectangle2D2);
                    Rectangle2D bounds = rectangle2D.createUnion(rectangle2D2);
                    levelsLayout.put(l, bounds);
                    continue;
                }
                Integer n2 = l;
                Rectangle2D rectangle2D = verticalLayout.get(axisGroup);
                Intrinsics.checkNotNull((Object)rectangle2D);
                levelsLayout.put(n2, rectangle2D);
            }
        }
        return levelsLayout;
    }

    private final int getLevel(Hierarchy<AxisGroupModel<Row, Column>> hierarchy, AxisGroupModel<Row, Column> axisGroup) {
        return hierarchy.getLevel(axisGroup);
    }

    public static final /* synthetic */ ParallelCoordinatesView access$getView$p(DefaultParallelCoordinatesLayoutEngine $this) {
        return $this.view;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/macrofocus/high_d/parallelcoordinates/layout/DefaultParallelCoordinatesLayoutEngine$VerticalLayoutSize;", "", "<init>", "(Lcom/macrofocus/high_d/parallelcoordinates/layout/DefaultParallelCoordinatesLayoutEngine;)V", "fixed", "", "getFixed", "()I", "setFixed", "(I)V", "relative", "", "getRelative", "()D", "setRelative", "(D)V", "y", "getY", "setY", "height", "getHeight", "setHeight", "highd"})
    private final class VerticalLayoutSize {
        private int fixed;
        private double relative;
        private double y;
        private double height;

        public final int getFixed() {
            return this.fixed;
        }

        public final void setFixed(int n) {
            this.fixed = n;
        }

        public final double getRelative() {
            return this.relative;
        }

        public final void setRelative(double d) {
            this.relative = d;
        }

        public final double getY() {
            return this.y;
        }

        public final void setY(double d) {
            this.y = d;
        }

        public final double getHeight() {
            return this.height;
        }

        public final void setHeight(double d) {
            this.height = d;
        }
    }
}

