/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.AbstractAlgorithm;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapWorker;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u00010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JU\u0010\n\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r\"\u0004\b\u0002\u0010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u00122\u0006\u0010\u0013\u001a\u0002H\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016JA\u0010\u0017\u001a\u00020\u0005\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r\"\u0004\b\u0002\u0010\u000e2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u00122\u0006\u0010\u0013\u001a\u0002H\fH\u0002\u00a2\u0006\u0002\u0010\u0018Jm\u0010\u0019\u001a\u00020\u001a\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r\"\u0004\b\u0002\u0010\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u0002H\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\f0\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\f0%2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010&J\u0012\u0010-\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010.\u001a\u00020/H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010'\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010(R\u0014\u0010*\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0014\u0010+\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010(R\u0014\u0010,\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010(\u00a8\u00061"}, d2={"Lcom/treemap/IcicleAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "<init>", "()V", "maxDepth", "", "getMaxDepth", "()I", "setMaxDepth", "(I)V", "startLayout", "", "N", "Row", "Column", "bounds", "Lorg/mkui/geom/Rectangle2D;", "model", "Lcom/treemap/TreeMapModel;", "root", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Rectangle2D;Lcom/treemap/TreeMapModel;Ljava/lang/Object;Lcom/treemap/TreeMapWorker;)V", "getMaxDepthToLeaf", "(Lcom/treemap/TreeMapModel;Ljava/lang/Object;)I", "breadthFirstLayout", "", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSizes", "", "horizontalVanishingPoint", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "isRenderingLeafLabelsSupported", "()Z", "isRenderingParentLabelSupported", "isColorParent", "isChildContained", "isSpaceFilling", "isCompatible", "toString", "", "IcicleRectangle2D", "treemap"})
@StabilityInferred(parameters=0)
public final class IcicleAlgorithm
extends AbstractAlgorithm {
    private int maxDepth;
    public static final int $stable = 8;

    public final int getMaxDepth() {
        return this.maxDepth;
    }

    public final void setMaxDepth(int n) {
        this.maxDepth = n;
    }

    @Override
    public <N, Row, Column> void startLayout(@Nullable Rectangle2D bounds, @NotNull TreeMapModel<N, Row, Column> model, N root, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        super.startLayout(bounds, model, root, worker);
        this.maxDepth = this.getMaxDepthToLeaf(model, root) - model.getLevel(root);
    }

    private final <N, Row, Column> int getMaxDepthToLeaf(TreeMapModel<N, Row, Column> model, N root) {
        int maxDepth = 0;
        Iterator<N> it = model.depthFirstIterator(root).iterator();
        while (it.hasNext()) {
            int curDepth;
            N o;
            Intrinsics.checkNotNull(it.next());
            if (!model.hasNoChildren(o) || (curDepth = model.getLevel(o)) <= maxDepth) continue;
            maxDepth = curDepth;
        }
        return maxDepth;
    }

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        if (shape instanceof IcicleRectangle2D) {
            Rectangle2D bounds = ((IcicleRectangle2D)shape).getBounds2D();
            double width = bounds.getWidth();
            double sumShares = 0.0;
            for (N child : children) {
                Rectangle2D.Double r = null;
                double share = accessor.getSize(child) / sumSizes;
                r = new IcicleRectangle2D(bounds.getX() + width, bounds.getY() + bounds.getHeight() * sumShares, width, bounds.getHeight() * share, bounds.getWidth());
                accessor.setShape(child, (Shape)r);
                sumShares += share;
            }
        } else {
            Rectangle2D bounds = shape.getBounds2D();
            double width = bounds.getWidth() / (double)this.maxDepth;
            double sumShares = 0.0;
            for (N child : children) {
                Rectangle2D.Double r = null;
                double share = accessor.getSize(child) / sumSizes;
                r = new IcicleRectangle2D(bounds.getX(), bounds.getY() + bounds.getHeight() * sumShares, width, bounds.getHeight() * share, width);
                accessor.setShape(child, (Shape)r);
                sumShares += share;
            }
        }
        return false;
    }

    @Override
    public boolean isRenderingLeafLabelsSupported() {
        return true;
    }

    @Override
    public boolean isRenderingParentLabelSupported() {
        return true;
    }

    @Override
    public boolean isColorParent() {
        return true;
    }

    @Override
    public boolean isChildContained() {
        return false;
    }

    @Override
    public boolean isSpaceFilling() {
        return false;
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D;
    }

    @NotNull
    public String toString() {
        return "Icicle";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/treemap/IcicleAlgorithm$IcicleRectangle2D;", "Lorg/mkui/geom/Rectangle2D$Double;", "x", "", "y", "w", "h", "fullWidth", "<init>", "(DDDDD)V", "getFullWidth", "()D", "setFullWidth", "(D)V", "treemap"})
    private static final class IcicleRectangle2D
    extends Rectangle2D.Double {
        private double fullWidth;

        public IcicleRectangle2D(double x, double y, double w, double h, double fullWidth) {
            super(x, y, w, h);
            this.fullWidth = fullWidth;
        }

        public final double getFullWidth() {
            return this.fullWidth;
        }

        public final void setFullWidth(double d) {
            this.fullWidth = d;
        }
    }
}

