/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.AbstractAlgorithm;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Arc2D;
import org.mkui.geom.Ellipse2D;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JG\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000b\u001a\u0002H\u0006H\u0016\u00a2\u0006\u0002\u0010\fJm\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u0002H\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u001f\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lcom/treemap/PieAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "<init>", "()V", "iterator", "", "N", "Row", "Column", "model", "Lcom/treemap/TreeMapModel;", "root", "(Lcom/treemap/TreeMapModel;Ljava/lang/Object;)Ljava/lang/Iterable;", "breadthFirstLayout", "", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSizes", "", "horizontalVanishingPoint", "", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "isCompatible", "isSpaceFilling", "()Z", "toString", "", "treemap"})
@StabilityInferred(parameters=1)
public final class PieAlgorithm
extends AbstractAlgorithm {
    public static final int $stable;

    @Override
    @NotNull
    public <N, Row, Column> Iterable<N> iterator(@NotNull TreeMapModel<N, Row, Column> model, N root) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.depthFirstIterator(root);
    }

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        Rectangle2D bounds = shape.getBounds2D();
        double size = Math.min(bounds.getWidth(), bounds.getHeight());
        double shiftX = (bounds.getWidth() - size) / (double)2;
        double shiftY = (bounds.getHeight() - size) / (double)2;
        bounds = (Rectangle2D)new Rectangle2D.Double(bounds.getX() + shiftX, bounds.getY() + shiftY, size, size);
        double startAngle = 90.0;
        for (N child : children) {
            double arcAngle = accessor.getSize(child) * (double)360 / sumSizes;
            accessor.setShape(child, (Shape)new Arc2D.Double(bounds, startAngle, -arcAngle, 2));
            startAngle -= arcAngle;
        }
        return false;
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D || shape instanceof Ellipse2D;
    }

    @Override
    public boolean isSpaceFilling() {
        return false;
    }

    @NotNull
    public String toString() {
        return "Pie";
    }
}

