/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.AbstractAlgorithm;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0005\u001e\u001f !\"B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005Jm\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\t\"\u0004\b\u0002\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u0002H\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\b0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\b0\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/treemap/SliceAndDiceAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "orientationStrategy", "Lcom/treemap/SliceAndDiceAlgorithm$OrientationStragegy;", "<init>", "(Lcom/treemap/SliceAndDiceAlgorithm$OrientationStragegy;)V", "breadthFirstLayout", "", "N", "Row", "Column", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSizes", "", "horizontalVanishingPoint", "", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "isCompatible", "getName", "", "toString", "OrientationStragegy", "VerticalOrientationStrategy", "HoritzonalOrientationStrategy", "BestOrientationStrategy", "AlternateOrientationStrategy", "treemap"})
@StabilityInferred(parameters=0)
public final class SliceAndDiceAlgorithm
extends AbstractAlgorithm {
    @NotNull
    private final OrientationStragegy orientationStrategy;
    public static final int $stable = 8;

    public SliceAndDiceAlgorithm(@NotNull OrientationStragegy orientationStrategy) {
        Intrinsics.checkNotNullParameter((Object)orientationStrategy, (String)"orientationStrategy");
        this.orientationStrategy = orientationStrategy;
    }

    public /* synthetic */ SliceAndDiceAlgorithm(OrientationStragegy orientationStragegy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            orientationStragegy = new AlternateOrientationStrategy();
        }
        this(orientationStragegy);
    }

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        Rectangle2D bounds = shape.getBounds2D();
        double sumShares = 0.0;
        for (N child : children) {
            Rectangle2D.Double r = null;
            double share = accessor.getSize(child) / sumSizes;
            r = this.orientationStrategy.isVertical(bounds, parent, accessor) ? new Rectangle2D.Double(bounds.getX(), bounds.getY() + bounds.getHeight() * sumShares, bounds.getWidth(), bounds.getHeight() * share) : new Rectangle2D.Double(bounds.getX() + bounds.getWidth() * sumShares, bounds.getY(), bounds.getWidth() * share, bounds.getHeight());
            accessor.setShape(child, (Shape)r);
            sumShares += share;
        }
        return false;
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D;
    }

    @NotNull
    public final String getName() {
        return "Slice-and-dice";
    }

    @NotNull
    public String toString() {
        return this.getName();
    }

    public SliceAndDiceAlgorithm() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u0002H\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/treemap/SliceAndDiceAlgorithm$AlternateOrientationStrategy;", "Lcom/treemap/SliceAndDiceAlgorithm$OrientationStragegy;", "<init>", "()V", "isVertical", "", "N", "bounds", "Lorg/mkui/geom/Rectangle2D;", "parent", "accessor", "Lcom/treemap/TreeMapAccessor;", "(Lorg/mkui/geom/Rectangle2D;Ljava/lang/Object;Lcom/treemap/TreeMapAccessor;)Z", "treemap"})
    @StabilityInferred(parameters=1)
    public static final class AlternateOrientationStrategy
    implements OrientationStragegy {
        public static final int $stable;

        @Override
        public <N> boolean isVertical(@NotNull Rectangle2D bounds, N parent, @NotNull TreeMapAccessor<? super N> accessor) {
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
            return (accessor.getLevel(parent) + 1) % 2 == 0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u0002H\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/treemap/SliceAndDiceAlgorithm$BestOrientationStrategy;", "Lcom/treemap/SliceAndDiceAlgorithm$OrientationStragegy;", "<init>", "()V", "isVertical", "", "N", "bounds", "Lorg/mkui/geom/Rectangle2D;", "parent", "accessor", "Lcom/treemap/TreeMapAccessor;", "(Lorg/mkui/geom/Rectangle2D;Ljava/lang/Object;Lcom/treemap/TreeMapAccessor;)Z", "treemap"})
    @StabilityInferred(parameters=1)
    public static final class BestOrientationStrategy
    implements OrientationStragegy {
        public static final int $stable;

        @Override
        public <N> boolean isVertical(@NotNull Rectangle2D bounds, N parent, @NotNull TreeMapAccessor<? super N> accessor) {
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
            return bounds.getWidth() <= bounds.getHeight();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u0002H\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/treemap/SliceAndDiceAlgorithm$HoritzonalOrientationStrategy;", "Lcom/treemap/SliceAndDiceAlgorithm$OrientationStragegy;", "<init>", "()V", "isVertical", "", "N", "bounds", "Lorg/mkui/geom/Rectangle2D;", "parent", "accessor", "Lcom/treemap/TreeMapAccessor;", "(Lorg/mkui/geom/Rectangle2D;Ljava/lang/Object;Lcom/treemap/TreeMapAccessor;)Z", "treemap"})
    @StabilityInferred(parameters=1)
    public static final class HoritzonalOrientationStrategy
    implements OrientationStragegy {
        public static final int $stable;

        @Override
        public <N> boolean isVertical(@NotNull Rectangle2D bounds, N parent, @NotNull TreeMapAccessor<? super N> accessor) {
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J1\u0010\u0002\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u0002H\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00040\tH&\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b\u00c0\u0006\u0003"}, d2={"Lcom/treemap/SliceAndDiceAlgorithm$OrientationStragegy;", "", "isVertical", "", "N", "bounds", "Lorg/mkui/geom/Rectangle2D;", "parent", "accessor", "Lcom/treemap/TreeMapAccessor;", "(Lorg/mkui/geom/Rectangle2D;Ljava/lang/Object;Lcom/treemap/TreeMapAccessor;)Z", "treemap"})
    public static interface OrientationStragegy {
        public <N> boolean isVertical(@NotNull Rectangle2D var1, N var2, @NotNull TreeMapAccessor<? super N> var3);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u0002H\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/treemap/SliceAndDiceAlgorithm$VerticalOrientationStrategy;", "Lcom/treemap/SliceAndDiceAlgorithm$OrientationStragegy;", "<init>", "()V", "isVertical", "", "N", "bounds", "Lorg/mkui/geom/Rectangle2D;", "parent", "accessor", "Lcom/treemap/TreeMapAccessor;", "(Lorg/mkui/geom/Rectangle2D;Ljava/lang/Object;Lcom/treemap/TreeMapAccessor;)Z", "treemap"})
    @StabilityInferred(parameters=1)
    public static final class VerticalOrientationStrategy
    implements OrientationStragegy {
        public static final int $stable;

        @Override
        public <N> boolean isVertical(@NotNull Rectangle2D bounds, N parent, @NotNull TreeMapAccessor<? super N> accessor) {
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
            return true;
        }
    }
}

