/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.tagcloud;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.tagcloud.HierarchicalBoundingBoxes;
import com.treemap.tagcloud.Orientation;
import com.treemap.tagcloud.Point2d;
import com.treemap.tagcloud.TextShape;
import com.treemap.tagcloud.TextShapeFactory;
import com.treemap.tagcloud.Word;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.mkui.font.MkFontKt;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0018\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0002H\u0016J\u0019\u0010#\u001a\u00020\r2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0002H\u0096\u0002J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\bJ\u0012\u0010%\u001a\u00020&2\b\u0010,\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010-\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\t\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006."}, d2={"Lcom/treemap/tagcloud/DefaultWord;", "N", "Lcom/treemap/tagcloud/Word;", "textShapeFactory", "Lcom/treemap/tagcloud/TextShapeFactory;", "text", "", "size", "", "treeMapNode", "orientation", "Lcom/treemap/tagcloud/Orientation;", "nSubdivisions", "", "font", "Lorg/jetbrains/skia/Font;", "Lorg/mkui/font/MkFont;", "<init>", "(Lcom/treemap/tagcloud/TextShapeFactory;Ljava/lang/String;DLjava/lang/Object;Lcom/treemap/tagcloud/Orientation;ILorg/jetbrains/skia/Font;)V", "getText", "()Ljava/lang/String;", "getSize", "()D", "getTreeMapNode", "()Ljava/lang/Object;", "Ljava/lang/Object;", "location", "Lcom/treemap/tagcloud/Point2d;", "normedAndCenteredShape", "Lcom/treemap/tagcloud/TextShape;", "hierarchicalBoundingBoxes", "Lcom/treemap/tagcloud/HierarchicalBoundingBoxes;", "intersects", "", "otherWord", "compareTo", "anotherWord", "setLocation", "", "xPos", "yPos", "shapeForLayout", "getShapeForLayout", "()Lcom/treemap/tagcloud/TextShape;", "position", "toString", "treemap"})
@StabilityInferred(parameters=0)
public final class DefaultWord<N>
implements Word<N> {
    @NotNull
    private final String text;
    private final double size;
    private final N treeMapNode;
    @NotNull
    private final Point2d location;
    @NotNull
    private final TextShape normedAndCenteredShape;
    @NotNull
    private final HierarchicalBoundingBoxes hierarchicalBoundingBoxes;
    public static final int $stable = 8;

    public DefaultWord(@NotNull TextShapeFactory textShapeFactory, @NotNull String text, double size, N treeMapNode, @NotNull Orientation orientation, int nSubdivisions, @NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)textShapeFactory, (String)"textShapeFactory");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.location = new Point2d();
        Font font2 = font;
        this.text = text;
        this.size = size;
        this.treeMapNode = treeMapNode;
        font2 = MkFontKt.deriveFontSize((Font)font2, (double)40.0);
        TextShape outline = textShapeFactory.createTextShape(text, font2);
        Rectangle2D renderSizeBounds = outline.getBounds2D();
        Shape shape = outline.createTransformedShape(AffineTransform.Companion.getTranslateInstance(-renderSizeBounds.getWidth() / (double)2, renderSizeBounds.getHeight() / (double)2));
        Intrinsics.checkNotNull((Object)shape, (String)"null cannot be cast to non-null type com.treemap.tagcloud.TextShape");
        Shape shape2 = ((TextShape)shape).createTransformedShape(AffineTransform.Companion.getScaleInstance(size, size));
        Intrinsics.checkNotNull((Object)shape2, (String)"null cannot be cast to non-null type com.treemap.tagcloud.TextShape");
        TextShape normedAndCenteredShape = (TextShape)shape2;
        if (orientation == Orientation.Vertical) {
            Shape shape3 = normedAndCenteredShape.createTransformedShape(AffineTransform.Companion.getRotateInstance(1.5707963267948966));
            Intrinsics.checkNotNull((Object)shape3, (String)"null cannot be cast to non-null type com.treemap.tagcloud.TextShape");
            normedAndCenteredShape = (TextShape)shape3;
        }
        this.normedAndCenteredShape = normedAndCenteredShape;
        this.hierarchicalBoundingBoxes = new HierarchicalBoundingBoxes(normedAndCenteredShape, nSubdivisions, 1.25);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final double getSize() {
        return this.size;
    }

    @Override
    public N getTreeMapNode() {
        return this.treeMapNode;
    }

    @Override
    public boolean intersects(@Nullable Word<N> otherWord) {
        Intrinsics.checkNotNull(otherWord, (String)"null cannot be cast to non-null type com.treemap.tagcloud.DefaultWord<N of com.treemap.tagcloud.DefaultWord>");
        return this.hierarchicalBoundingBoxes.intersects(((DefaultWord)otherWord).hierarchicalBoundingBoxes);
    }

    @Override
    public int compareTo(@Nullable Word<N> anotherWord) {
        Intrinsics.checkNotNull(anotherWord, (String)"null cannot be cast to non-null type com.treemap.tagcloud.DefaultWord<N of com.treemap.tagcloud.DefaultWord>");
        return Double.compare(this.size, ((DefaultWord)anotherWord).size);
    }

    public final void setLocation(double xPos, double yPos) {
        this.location.set(xPos, yPos);
        this.hierarchicalBoundingBoxes.setTranslation(xPos, yPos);
    }

    @Override
    @NotNull
    public TextShape getShapeForLayout() {
        Shape shape = this.normedAndCenteredShape.createTransformedShape(AffineTransform.Companion.getTranslateInstance(this.location.getX(), this.location.getY()));
        Intrinsics.checkNotNull((Object)shape, (String)"null cannot be cast to non-null type com.treemap.tagcloud.TextShape");
        return (TextShape)shape;
    }

    @Override
    public void setLocation(@Nullable Point2d position) {
        Point2d point2d = position;
        Intrinsics.checkNotNull((Object)point2d);
        this.setLocation(point2d.getX(), position.getY());
    }

    @NotNull
    public String toString() {
        return "Word{text='" + this.text + "', size=" + this.size + ", child=" + this.getTreeMapNode() + ", location=" + this.location + ", normedAndCenteredShape=" + this.normedAndCenteredShape + ", hierarchicalBoundingBoxes=" + this.hierarchicalBoundingBoxes + "}";
    }
}

